/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.CommentById;
import com.Weibo.MyScrollPane;
import com.Weibo.Oauth2Code;
import com.Weibo.OneStatus;
import com.Weibo.RepostTimeline;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weibo4j.Comments;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.Status;
import weibo4j.model.WeiboException;

public class WeiboFrame
extends JFrame {
    private static final long serialVersionUID = -7876357592374972810L;
    private final boolean[] arrayOfTab;
    private static Status status;
    private static String type;
    private int is_comment;
    private JCheckBox firstCB;
    private static JTextArea repostTextArea;
    private static JTextArea commentTextArea;
    private static JTextArea textArea;
    private static JTabbedPane downTabbedPane;
    private Comment replyComment;
    private static WeiboFrame instance;

    static {
        instance = null;
    }

    public static WeiboFrame getInstance() {
        return instance;
    }

    public static WeiboFrame getInstance(Status status, String type) {
        if (instance == null) {
            instance = new WeiboFrame(status, type);
        } else if (!status.equals(WeiboFrame.status)) {
            instance.dispose();
            instance = new WeiboFrame(status, type);
        } else if (status.equals(WeiboFrame.status) && type.equals(WeiboFrame.type)) {
            instance.setVisible(true);
        } else if (status.equals(WeiboFrame.status) && !type.equals(WeiboFrame.type)) {
            instance.setVisible(true);
            WeiboFrame.SetSelectedIndex(type);
        }
        return instance;
    }

    private WeiboFrame(Status status, String type) {
        super("\u65b0\u6d6a\u5fae\u535a");
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        this.arrayOfTab = blArray;
        WeiboFrame.type = type;
        WeiboFrame.status = status;
        this.getContentPane().setBackground(new Color(240, 240, 240));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.setSize(500, 500);
        this.setLayout(null);
        this.setLocationRelativeTo(Oauth2Code.getMainDialog());
        this.initUp(status);
        this.initDown();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WeiboFrame.this.setVisible(false);
            }
        });
    }

    private void initUp(Status status) {
        final String id = status.getId();
        final JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(0, 0, 485, 280);
        tabbedPane.addTab("\u5fae\u535a\u6b63\u6587", null, this.getWeiboText(status), "\u5fae\u535a\u6b63\u6587");
        int repostCount = status.getRepostsCount();
        int commentCount = status.getCommentsCount();
        tabbedPane.addTab("\u5168\u90e8\u8f6c\u53d1" + this.descriCount(repostCount), null, this.getRepostTimeline(id), "\u5168\u90e8\u8f6c\u53d1");
        tabbedPane.addTab("\u5168\u90e8\u8bc4\u8bba" + this.descriCount(commentCount), null, this.getCommentTimeline(id), "\u5168\u90e8\u8bc4\u8bba");
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = tabbedPane.getSelectedIndex();
                if (WeiboFrame.this.arrayOfTab[index]) {
                    return;
                }
                FirstClick thread = new FirstClick((MyScrollPane)tabbedPane.getSelectedComponent(), index, id);
                thread.start();
            }
        });
        this.add(tabbedPane);
    }

    private Component getWeiboText(Status status2) {
        JScrollPane jsp = new JScrollPane(new OneStatus(status, OneStatus.StatusType.STATUS_TEXT));
        jsp.setBounds(10, 0, 480, 450);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.getVerticalScrollBar().setUnitIncrement(25);
        return jsp;
    }

    private Component getRepostTimeline(String id) {
        RepostTimeline reposts = new RepostTimeline(id);
        MyScrollPane jsp = new MyScrollPane(reposts);
        return jsp;
    }

    private Component getCommentTimeline(String id) {
        CommentById commentById = new CommentById(id);
        MyScrollPane jsp = new MyScrollPane(commentById);
        return jsp;
    }

    private void initDown() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(new Color(240, 240, 240));
        downTabbedPane = new JTabbedPane(1);
        repostTextArea = this.initTextArea();
        JScrollPane jsp = new JScrollPane(repostTextArea);
        downTabbedPane.addTab("\u8f6c\u53d1", null, jsp, "\u8f6c\u53d1");
        commentTextArea = this.initTextArea();
        jsp = new JScrollPane(commentTextArea);
        downTabbedPane.addTab("\u8bc4\u8bba", null, jsp, "\u8bc4\u8bba");
        WeiboFrame.SetSelectedIndex(type);
        downTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = downTabbedPane.getSelectedIndex();
                if (index == 0) {
                    WeiboFrame.this.firstCB.setText("\u540c\u65f6\u8bc4\u8bba");
                    textArea = repostTextArea;
                } else if (index == 1) {
                    WeiboFrame.this.firstCB.setText("\u540c\u65f6\u8f6c\u53d1");
                    textArea = commentTextArea;
                }
            }
        });
        panel.add(downTabbedPane);
        panel.add((Component)this.getButtonPanel(), "South");
        panel.setBounds(0, 280, 485, 180);
        this.add(panel);
    }

    private String descriCount(int count) {
        if (count != 0) {
            return "(" + count + ")";
        }
        return "";
    }

    private static void SetSelectedIndex(String type) {
        if (type.startsWith("\u539f\u6587\u8f6c\u53d1") || type.startsWith("\u8f6c\u53d1")) {
            textArea = repostTextArea;
            downTabbedPane.setSelectedIndex(0);
        } else {
            textArea = commentTextArea;
            downTabbedPane.setSelectedIndex(1);
        }
    }

    private JTextArea initTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        return textArea;
    }

    private JPanel getButtonPanel() {
        JPanel btPanel = new JPanel();
        btPanel.setBackground(new Color(240, 240, 240));
        StringBuffer cbText = new StringBuffer("\u540c\u65f6");
        if (type.startsWith("\u539f\u6587\u8f6c\u53d1") || type.startsWith("\u8f6c\u53d1")) {
            cbText.append("\u8bc4\u8bba");
        } else {
            cbText.append("\u8bc4\u8bba");
        }
        this.firstCB = new JCheckBox(cbText.toString());
        this.firstCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WeiboFrame weiboFrame = WeiboFrame.this;
                    weiboFrame.is_comment = weiboFrame.is_comment + 1;
                } else if (e.getStateChange() == 2) {
                    WeiboFrame weiboFrame = WeiboFrame.this;
                    weiboFrame.is_comment = weiboFrame.is_comment - 1;
                }
            }
        });
        btPanel.add(this.firstCB);
        Status retweeted = status.getRetweetedStatus();
        if (retweeted != null) {
            JCheckBox secendCB = new JCheckBox("\u540c\u65f6\u8bc4\u8bba\u7ed9\u539f\u4f5c\u8005");
            secendCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        WeiboFrame weiboFrame = WeiboFrame.this;
                        weiboFrame.is_comment = weiboFrame.is_comment + 2;
                    } else if (e.getStateChange() == 2) {
                        WeiboFrame weiboFrame = WeiboFrame.this;
                        weiboFrame.is_comment = weiboFrame.is_comment - 2;
                    }
                }
            });
            btPanel.add(secendCB);
        }
        JButton button = new JButton("\u53d1\u9001");
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                new Send().start();
            }
        });
        btPanel.add(button);
        return btPanel;
    }

    public void showOptionPane(int isSuccessed) {
        if (isSuccessed == 1) {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u6210\u529f");
            textArea.setText("");
        } else if (isSuccessed == -1) {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
        } else if (isSuccessed == 20019) {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u5185\u5bb9\u91cd\u590d", "\u9519\u8bef", 0);
        }
    }

    public int repost(String id, String text, Integer is_comment) {
        Timeline tl = new Timeline();
        tl.client.setToken(AccessTokenDao.read());
        Status result = null;
        try {
            result = tl.Repost(id, text, is_comment);
        }
        catch (WeiboException e) {
            if (e.getErrorCode() == 20019) {
                return 20019;
            }
            e.printStackTrace();
            return -1;
        }
        if (result != null) {
            return 1;
        }
        return -1;
    }

    public int aboutComment(String id, String reason, boolean isRetweeted) {
        int isSuccess = 0;
        if (this.replyComment != null) {
            isSuccess = this.reply();
        } else if (this.is_comment == 0) {
            isSuccess = this.createComment(id, reason, 0);
        } else if (this.is_comment == 2) {
            isSuccess = this.createComment(id, reason, 1);
        } else {
            if (isRetweeted) {
                reason = String.valueOf(reason) + "//@" + status.getUser().getName() + ":" + status.getText();
            }
            isSuccess = this.repost(id, reason, this.is_comment);
        }
        return isSuccess;
    }

    private int reply() {
        Comments cm = new Comments();
        cm.client.setToken(AccessTokenDao.read());
        Comment result = null;
        try {
            result = this.is_comment == 0 ? cm.replyComment(this.replyComment.getIdstr(), this.replyComment.getStatus().getId(), textArea.getText()) : cm.replyComment(this.replyComment.getIdstr(), this.replyComment.getStatus().getId(), textArea.getText(), 0, 1);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        this.replyComment = null;
        if (result != null) {
            return 1;
        }
        return -1;
    }

    private int createComment(String id, String text, Integer comment_ori) {
        Comments cm = new Comments();
        cm.client.setToken(AccessTokenDao.read());
        Comment result = null;
        try {
            result = cm.createComment(text, id, comment_ori);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (result != null) {
            return 1;
        }
        return -1;
    }

    public JTextArea getCommentTextArea() {
        downTabbedPane.setSelectedIndex(1);
        return textArea;
    }

    public void setReplyComment(Comment replyComment) {
        this.replyComment = replyComment;
    }

    public JTextArea getTextArea(String type) {
        WeiboFrame.SetSelectedIndex(type);
        return textArea;
    }

    private class FirstClick
    extends Thread {
        private static final int REPOST_TIMELINE = 1;
        private static final int COMMENT_TIMELINE = 2;
        private MyScrollPane msp;
        private int index;
        private String id;

        public FirstClick(MyScrollPane msp, int index, String id) {
            this.msp = msp;
            this.index = index;
            this.id = id;
            ((WeiboFrame)WeiboFrame.this).arrayOfTab[index] = true;
        }

        @Override
        public void run() {
            if (this.index == 1) {
                this.msp.setViewportView(new RepostTimeline(this.id));
            } else if (this.index == 2) {
                this.msp.setViewportView(new CommentById(this.id));
            }
        }
    }

    private class Send
    extends Thread {
        private Send() {
        }

        @Override
        public void run() {
            boolean isRetweeted;
            String reason = textArea.getText();
            String statusId = status.getId();
            int isSuccessed = -1;
            boolean bl = isRetweeted = status.getRetweetedStatus() != null;
            if (textArea.equals(repostTextArea)) {
                if (isRetweeted) {
                    reason = String.valueOf(reason) + "//@" + status.getUser().getName() + ":" + status.getText();
                }
                isSuccessed = WeiboFrame.this.repost(statusId, reason, WeiboFrame.this.is_comment);
            } else if (textArea.equals(commentTextArea)) {
                isSuccessed = WeiboFrame.this.aboutComment(statusId, reason, isRetweeted);
            }
            WeiboFrame.this.showOptionPane(isSuccessed);
        }
    }
}

