/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import weibo4j.Weibo;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.User;
import weibo4j.model.UserWapper;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.util.WeiboConfig;

public class Friendships
extends Weibo {
    private static final long serialVersionUID = 3603512821159421447L;

    public UserWapper getFriendsByID(String id) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", new PostParameter[]{new PostParameter("uid", id)}));
    }

    public UserWapper getFriendsByID(String id, Paging page) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", new PostParameter[]{new PostParameter("uid", id)}, page));
    }

    public UserWapper getFriendsByScreenName(String screen_name) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}));
    }

    public UserWapper getFriendsInCommon(String uid) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/in_common.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public UserWapper getFriendsInCommon(String uid, String suid, Paging page) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/in_common.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("suid", suid)}, page));
    }

    public UserWapper getFriendsBilateral(String uid) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public UserWapper getFriendsBilateral(String uid, Integer sort, Paging page) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("sort", sort.toString())}, page));
    }

    public String[] getFriendsBilateralIds(String uid) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral/ids.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public String[] getFriendsBilateralIds(String uid, Integer sort, Paging page) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("sort", sort.toString())}, page));
    }

    public String[] getFriendsIdsByUid(String uid) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public String[] getFriendsIdsByName(String screen_name) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}));
    }

    public String[] getFriendsIdsByUid(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public String[] getFriendsIdsByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public JSONArray getRemark(String uids) throws WeiboException {
        return this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/remark_batch.json", new PostParameter[]{new PostParameter("uids", uids)}).asJSONArray();
    }

    public UserWapper getFollowersByName(String screen_name) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}));
    }

    public UserWapper getFollowersByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public UserWapper getFollowersById(String uid) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public UserWapper getFollowersById(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public UserWapper getFollowersById(String id, Paging page) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("uid", id)}, page));
    }

    public String[] getFollowersIdsById(String uid) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public String[] getFollowersIdsById(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public String[] getFollowersIdsByName(String screen_name) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}));
    }

    public String[] getFollowersIdsByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}));
    }

    public UserWapper getFollowersActive(String uid) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/active.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public UserWapper getFollowersActive(String uid, Integer count) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/active.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString())}));
    }

    public UserWapper getFriendsChainFollowers(String uid) throws WeiboException {
        return User.constructWapperUsers(this.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends_chain/followers.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public User createFriendshipsById(String uid) throws WeiboException {
        return new User(this.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/create.json", new PostParameter[]{new PostParameter("uid", uid)}).asJSONObject());
    }

    public User createFriendshipsByName(String screen_name) throws WeiboException {
        return new User(this.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/create.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}).asJSONObject());
    }

    public User destroyFriendshipsDestroyById(String uid) throws WeiboException {
        return new User(this.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/destroy.json", new PostParameter[]{new PostParameter("uid", uid)}).asJSONObject());
    }

    public User destroyFriendshipsDestroyByName(String screen_name) throws WeiboException {
        return new User(this.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/destroy.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}).asJSONObject());
    }
}

