/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import weibo4j.Weibo;
import weibo4j.http.AccessToken;
import weibo4j.http.BASE64Encoder;
import weibo4j.model.PostParameter;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

public class Oauth
extends Weibo {
    private static final long serialVersionUID = 7003420545330439247L;
    public String access_token;
    public String user_id;

    public String getToken() {
        return this.access_token;
    }

    public String parseSignedRequest(String signed_request) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        String[] t = signed_request.split("\\.", 2);
        int padding = 4 - t[0].length() % 4;
        int i = 0;
        while (i < padding) {
            t[0] = String.valueOf(t[0]) + "=";
            ++i;
        }
        String part1 = t[0].replace("-", "+").replace("_", "/");
        SecretKeySpec key = new SecretKeySpec(WeiboConfig.getValue("client_SERCRET").getBytes(), "hmacSHA256");
        Mac m = Mac.getInstance("hmacSHA256");
        m.init(key);
        m.update(t[1].getBytes());
        String part1Expect = BASE64Encoder.encode(m.doFinal());
        BASE64Decoder decode = new BASE64Decoder();
        String s = new String(decode.decodeBuffer(t[1]));
        if (part1.equals(part1Expect)) {
            return this.ts(s);
        }
        return null;
    }

    public String ts(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            this.access_token = jsonObject.getString("oauth_token");
            this.user_id = jsonObject.getString("user_id");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.access_token;
    }

    public AccessToken getAccessTokenByCode(String code) throws WeiboException {
        return new AccessToken(this.client.post(WeiboConfig.getValue("accessTokenURL"), new PostParameter[]{new PostParameter("client_id", WeiboConfig.getValue("client_ID")), new PostParameter("client_secret", WeiboConfig.getValue("client_SERCRET")), new PostParameter("grant_type", "authorization_code"), new PostParameter("code", code), new PostParameter("redirect_uri", WeiboConfig.getValue("redirect_URI"))}, false));
    }

    public String authorize(String response_type, String state) throws WeiboException {
        return String.valueOf(WeiboConfig.getValue("authorizeURL").trim()) + "?client_id=" + WeiboConfig.getValue("client_ID").trim() + "&redirect_uri=" + WeiboConfig.getValue("redirect_URI").trim() + "&response_type=" + response_type + "&state=" + state;
    }

    public String authorize(String response_type, String state, String scope) throws WeiboException {
        return String.valueOf(WeiboConfig.getValue("authorizeURL").trim()) + "?client_id=" + WeiboConfig.getValue("client_ID").trim() + "&redirect_uri=" + WeiboConfig.getValue("redirect_URI").trim() + "&response_type=" + response_type + "&state=" + state + "&scope=" + scope;
    }

    public String authorize(String response_type) throws WeiboException {
        return String.valueOf(WeiboConfig.getValue("authorizeURL").trim()) + "?client_id=" + WeiboConfig.getValue("client_ID").trim() + "&redirect_uri=" + WeiboConfig.getValue("redirect_URI").trim() + "&response_type=" + response_type;
    }
}

