/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weibo4j.Weibo;
import weibo4j.http.Response;
import weibo4j.model.FavoritesTag;
import weibo4j.model.TagWapper;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Tag
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 2177657076940291492L;
    private String id;
    private String value;
    private String weight;

    public Tag(JSONObject json) throws WeiboException, JSONException {
        if (!json.getString("id").isEmpty()) {
            this.id = json.getString("id");
        }
        if (!json.getString("value").isEmpty()) {
            this.value = json.getString("value");
        } else {
            Iterator keys = json.sortedKeys();
            if (keys.hasNext()) {
                this.id = (String)keys.next();
                this.value = json.getString(this.id);
            }
        }
        this.weight = json.getString("weight");
    }

    public Tag(JSONObject json, Weibo weibo) throws WeiboException, JSONException {
        System.out.println(json);
        this.id = json.getString("id");
        this.value = json.getString("count");
        this.weight = json.getString("weight");
    }

    public static List<Tag> constructTags(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Tag> tags = new ArrayList<Tag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new Tag(list.getJSONObject(i)));
                ++i;
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public static TagWapper constructTagWapper(Response res) {
        try {
            JSONArray tags = res.asJSONArray();
            ArrayList<Tag> tagList = new ArrayList<Tag>();
            int i = 0;
            while (i < tags.getJSONObject(0).getJSONArray("tags").length()) {
                tagList.add(new Tag(tags.getJSONObject(0).getJSONArray("tags").getJSONObject(i)));
                ++i;
            }
            String id = tags.getJSONObject(0).getString("id");
            return new TagWapper(tagList, id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<FavoritesTag> constructTag(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("tags");
            int size = list.length();
            ArrayList<FavoritesTag> tags = new ArrayList<FavoritesTag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new FavoritesTag(list.getJSONObject(i)));
                ++i;
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String getId() {
        return this.id;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Tag [id=" + this.id + ", value=" + this.value + ", weight=" + this.weight + "]";
    }
}

