﻿function toForm(data) {
    var form = '';
    var index = 0;
    if (data[0]) {
        form = data[0].replace(/(<td[^>]*?>)((?:{.*?})?(?:<br\/?>)?)(<\/td>)/ig, function ($0, $1, $2, $3) {
            var str = '';
            var value = data[1] && data[1][index] ? data[1][index] : '';
            var rule = /class="(\d*)"/.exec($1);
            var field = $2.replace(/<br\/?>/, '');
            if (!data[2] && !rule || data[2] && rule && data[2] == rule[1]) {
                switch (field) {
                    case '{}': str = '<textarea style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;">' + value + '</textarea>';
                        break;
                    case '{ }': str = '<textarea style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" required>' + value + '</textarea>';
                        break;
                    case '<br/>': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + value + '" />';
                        break;
                    case '{0}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + value + '" required />';
                        break;
                    case '{1}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="number" step="0.01" value="' + value + '" required />';
                        break;
                    case '{2}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="number" value="' + value + '" required int />';
                        break;
                    case '{3}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="date" value="' + value + '" required />';
                        break;
                    case '{4}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="date" value="' + value + '" />';
                        break;
                    case '{5}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="datetime-local" value="' + value + '" required />';
                        break;
                    case '{6}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="tel" value="' + value + '" required tel />';
                        break;
                    case '{7}': var seal = data[3] ? '<img src="' + data[3] + '" style= "position:absolute; z-index:-1;" />' : '';
                        str = seal + '<input type="hidden" value="' + seal.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\'/g, '&#39;').replace(/\"/g, '&quot;') + '" />';
                        break;
                    case '{8}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + parent.window.userData.name + '" readonly />';
                        break;
                    case '{9}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + parent.window.userData.dept + '" readonly />';
                        break;
                    default:
                        var reg = /{(.*)}/.exec(field);
                        if (reg) {
                            var arr = reg[1].split(',');
                            if (arr.length > 1) {
                                str = '<select style="width:99%;border:1px dotted gray;background-color:transparent;">';
                                for (var i in arr)
                                    str += '<option value="' + arr[i] + '" ' + (value === arr[i] ? ' selected' : '') + '>' + arr[i] + '</option>';
                                str += '</select>';
                            }
                            else {
                                str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" value="' + (data[1] ? value : arr[0]) + '" type="text" required />';
                            }
                        }
                        else {
                            str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" value="' + value + '" type="text" />';
                        }
                }
            }
            else {
                str = value.replace('\n', '<br/>') + '<input type="hidden" value="' + value.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\'/g, '&#39;').replace(/\"/g, '&quot;') + '" />';
            }
            index++;
            return $1 + str + $3;
        });
    }
    return form;
}
function doForm(id) {
    var fields = document.getElementById(id).querySelectorAll('input,textarea,select');
    var data = [];
    for (var i = 0; i < fields.length; i++) {
        if (fields[i].value == '') {
            if (fields[i].hasAttribute('required')) {
                fields[i].focus();
                tip(fields[i], '请填写此字段。', true);
                return false;
            }
        }
        else {
            var type = fields[i].hasAttribute('int') ? 'int' : fields[i].hasAttribute('number') ? 'number' : fields[i].hasAttribute('tel') ? 'tel' : fields[i].getAttribute('type');
            if (type && fields[i].value != '') {
                switch (type) {
                    case 'int':
                        if (!/^(-?\d+)$/.test(fields[i].value)) {
                            fields[i].focus();
                            tip(frame, fields[i], '请填写有效的整数。', true);
                            return false;
                        }
                        break;
                    case 'number':
                        if (!/^(-?\d+)(\.\d+)?$/.test(fields[i].value)) {
                            fields[i].focus();
                            tip(fields[i], '请填写有效的数值。', true);
                            return false;
                        }
                        break;
                    case 'date':
                        if (!/^((?:19|20)\d\d)-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])$/.test(fields[i].value)) {
                            fields[i].focus();
                            tip(fields[i], '请填写有效的日期（如：2017-9-1）。', true);
                            return false;
                        }
                        break;
                    case 'datetime-local':
                        if (!/^((?:19|20)\d\d)-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])\s([0-1]?\d{1}|[2]{1}[0-3]{1}):([0-5]?\d{1}):([0-5]?\d{1})$/.test(fields[i].value)) {
                            fields[i].focus();
                            tip(fields[i], '请填写有效的日期时间（如：2017-9-1 13:01:59）。', true);
                            return false;
                        }
                        break;
                    case 'tel':
                        var tel = /^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/;
                        var mobile = /^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0-9]|170)\d{8}$/;
                        if (!(tel.test(fields[i].value) || (fields[i].value.length == 11 && mobile.test(fields[i].value)))) {
                            fields[i].focus();
                            tip(fields[i], '请填写有效的电话号码。', true);
                            return false;
                        }
                        break;
                }
            }
            var pattern = fields[i].getAttribute('pattern');
            if (pattern && !new RegExp(pattern).test(fields[i].value)) {
                fields[i].focus();
                tip(fields[i], fields[i].getAttribute('title'), true);
                return false;
            }
        }
        data.push((fields[i]).value);
    }
    return data;
}
function tip(elem, msg, icon) {
    var offsetX = (self.scrollWidth || (document.documentElement && document.documentElement.scrollWidth) || document.body.scrollWidth) - pageX(elem) > 120 ? 0 : 100;
    var tip = document.createElement("div");
    tip.style.cssText = 'position: absolute;top: ' + (pageY(elem) + elem.offsetHeight + 7) + 'px;left:' + (pageX(elem) - offsetX) + 'px;min-width:105px;max-width:280px;z-index: 1100000;box-sizing:content-box;border:1px solid #A9B7C7;border-radius: 5px;padding: 10px;background-color: #FBFBFB;font-size: 14px;line-height:150%;';
    tip.innerHTML = '<span style="position: absolute;top:-10px;left:' + (offsetX + 10) + 'px;color: #A9B7C7;font-family:SimSun;font-size: 14px;"><b style="position: absolute;color:#A9B7C7;z-index: 1;">◆</b><b style="position: absolute;color:#FBFBFB;z-index: 2;top:1px;">◆</b></span>';
    if (icon)
        tip.innerHTML += '<div style="display: inline-block;background-color: #FAAB20;color: white;font-family:SimHei;font-size: 15px;font-weight: bold;width: 18px;height: 18px;border-radius: 2px;text-align: center;margin-right: 5px;">!</div>';
    tip.innerHTML += msg;
    var tm = setTimeout(function () {
        try {
            document.body.removeChild(tip);
        }
        catch (err) {
        }
    }, 5000);
    tip.onmouseover = function () { clearTimeout(tm); }
    tip.onmouseout = function () { document.body.removeChild(tip); }
    document.body.appendChild(tip);
}
function pageX(elem) {
    return elem.offsetParent ? (elem.offsetLeft + pageX(elem.offsetParent)) : elem.offsetLeft;
}
function pageY(elem) {
    return elem.offsetParent ? (elem.offsetTop + pageY(elem.offsetParent)) : elem.offsetTop;
}