'cscript /nologo ics.vbs "" "" "off"
'ϴ뱣Ϊ*.batļУֱΪӵ֡ṩơ(on)ر(off)
' VBScript source code

Option Explicit

Dim ICSSC_DEFAULT, CONNECTION_PUBLIC, CONNECTION_PRIVATE, CONNECTION_ALL

Dim NetSharingManager

Dim PublicConnection, PrivateConnection

Dim EveryConnectionCollection

Dim objArgs

Dim priv_con, publ_con

Dim switch

ICSSC_DEFAULT = 0

CONNECTION_PUBLIC = 0

CONNECTION_PRIVATE = 1

CONNECTION_ALL = 2

Main()

Sub Main( )
    
    Set objArgs = WScript.Arguments
    
    If objArgs.Count = 3 Then
        
        priv_con = objArgs(0)'
        
        publ_con = objArgs(1)'
        
        switch = objArgs(2)'״̬л on Ϊ ics off ෴
        
        If Initialize() = True Then
            
            GetConnectionObjects()
            
            FirewallTestByName priv_con,publ_con
            
        End If
        
    Else
        
        Dim szMsg
        
        If Initialize() = True Then
            
            GetConnectionObjects()
            
            FirewallTestByName "list","list"
            
        End If
        
        szMsg = "To share your internet connection, please provide the name of the private and public connections as the argument." & vbCrLf & vbCrLf & _
        " Usage:" & vbCrLf & _
        " " & WScript.scriptname & " " & Chr(34) & "Private Connection Name" & Chr(34) & " " & Chr(34) & "Public Connection Name" & Chr(34)
        
        WScript.Echo( szMsg & vbCrLf & vbCrLf)
        
    End If
    
End Sub

Sub FirewallTestByName(con1,con2)
    
    On Error Resume Next
    
    Dim Item
    
    Dim EveryConnection
    
    Dim objNCProps
    
    Dim szMsg
    
    Dim bFound1,bFound2
    
    WScript.echo(vbCrLf & vbCrLf)
    
    bFound1 = False
    
    bFound2 = False
    
    For Each Item In EveryConnectionCollection
        
        Set EveryConnection = NetSharingManager.INetSharingConfigurationForINetConnection(Item)
        
        Set objNCProps = NetSharingManager.NetConnectionProps(Item)
        
        szMsg = "Name: " & objNCProps.Name & vbCrLf & _
        "Guid: " & objNCProps.Guid & vbCrLf & _
        "DeviceName: " & objNCProps.DeviceName & vbCrLf & _
        "Status: " & objNCProps.Status & vbCrLf & _
        "MediaType: " & objNCProps.MediaType
        
        If EveryConnection.SharingEnabled Then
            
            szMsg = szMsg & vbCrLf & _
            "SharingEnabled" & vbCrLf & _
            "SharingType: " & ConvertConnectionTypeToString(EveryConnection.SharingConnectionType)
            
        End If
        
        If objNCProps.Name = con1 Then
            
            bFound1 = True
            
            If EveryConnection.SharingEnabled = False And switch = "on" Then
                
                szMsg = szMsg & vbCrLf & "Not Shared... Enabling private connection share..."
                
                WScript.Echo(szMsg)
                
                EveryConnection.EnableSharing CONNECTION_PRIVATE
                
                szMsg = " Shared!"
                
            ElseIf(switch = "off") Then
                
                szMsg = szMsg & vbCrLf & "Shared... DisEnabling private connection share..."
                
                WScript.Echo(szMsg)
                
                EveryConnection.EnableSharing CONNECTION_ALL
                
            End If
            
        End If
        
        If objNCProps.Name = con2 Then
            
            bFound2 = True
            
            If EveryConnection.SharingEnabled = False And switch = "on" Then
                
                szMsg = szMsg & vbCrLf & "Not Shared... Enabling public connection share..."
                
                WScript.Echo(szMsg)
                
                EveryConnection.EnableSharing CONNECTION_PUBLIC
                
                szMsg = " Shared!"
                
            ElseIf(switch = "off") Then
                
                szMsg = szMsg & vbCrLf & "Shared... DisEnabling public connection share..."
                
                WScript.Echo(szMsg)
                
                EveryConnection.EnableSharing CONNECTION_ALL
                
            End If
            
        End If
        
        WScript.Echo(szMsg & vbCrLf & vbCrLf)
        
    Next
    
    If( con1 <> "list" ) Then
        
        If( bFound1 = False ) Then
            
            WScript.Echo( "Connection " & Chr(34) & con1 & Chr(34) & " was not found" )
            
        End If
        
        If( bFound2 = False ) Then
            
            WScript.Echo( "Connection " & Chr(34) & con2 & Chr(34) & " was not found" )
            
        End If
        
    End If
    
End Sub

Function Initialize()
    
    Dim bReturn
    
    bReturn = False
    
    Set NetSharingManager = WScript.CreateObject("HNetCfg.HNetShare.1")
    
    If (IsObject(NetSharingManager)) = False Then
        
        WScript.Echo("Unable to get the HNetCfg.HnetShare.1 object")
        
    Else
        
        If (IsNull(NetSharingManager.SharingInstalled) = True) Then
            
            WScript.Echo("Sharing isn't available on this platform.")
            
        Else
            
            bReturn = True
            
        End If
        
    End If
    
    Initialize = bReturn
    
End Function

Function GetConnectionObjects()
    
    Dim bReturn
    
    Dim Item
    
    bReturn = True
    
    If GetConnection(CONNECTION_PUBLIC) = False Then
        
        bReturn = False
        
    End If
    
    If GetConnection(CONNECTION_PRIVATE) = False Then
        
        bReturn = False
        
    End If
    
    If GetConnection(CONNECTION_ALL) = False Then
        
        bReturn = False
        
    End If
    
    GetConnectionObjects = bReturn
    
End Function

Function GetConnection(CONNECTION_TYPE)
    Dim bReturn
    Dim Connection
    Dim Item
    bReturn = True
    
    If (CONNECTION_PUBLIC = CONNECTION_TYPE) Then
        Set Connection = NetSharingManager.EnumPublicConnections(ICSSC_DEFAULT)
        
        If (Connection.Count > 0) And (Connection.Count < 2) Then
            
            For Each Item In Connection
                
                Set PublicConnection = NetSharingManager.INetSharingConfigurationForINetConnection(Item)
                
            Next
            
        Else
            
            bReturn = False
            
        End If
        
    ElseIf (CONNECTION_PRIVATE = CONNECTION_TYPE) Then
        
        Set Connection = NetSharingManager.EnumPrivateConnections(ICSSC_DEFAULT)
        
        If (Connection.Count > 0) And (Connection.Count < 2) Then
            
            For Each Item In Connection
                
                Set PrivateConnection = NetSharingManager.INetSharingConfigurationForINetConnection(Item)
                
            Next
            
        Else
            
            bReturn = False
            
        End If
        
    ElseIf (CONNECTION_ALL = CONNECTION_TYPE) Then
        
        Set Connection = NetSharingManager.EnumEveryConnection
        
        If (Connection.Count > 0) Then
            
            Set EveryConnectionCollection = Connection
            
        Else
            
            bReturn = False
            
        End If
        
    Else
        
        bReturn = False
        
    End If
    
    If (True = bReturn) Then
        
        If (Connection.Count = 0) Then
            
            WScript.Echo("No " + CStr(ConvertConnectionTypeToString(CONNECTION_TYPE)) + " connections exist (Connection.Count gave us 0)")
            
            bReturn = False
            
            'valid to have more than 1 connection returned from EnumEveryConnection
            
        ElseIf (Connection.Count > 1) And (CONNECTION_ALL <> CONNECTION_TYPE) Then
            
            WScript.Echo("ERROR: There was more than one " + ConvertConnectionTypeToString(CONNECTION_TYPE) + " connection (" + CStr(Connection.Count) + ")")
            
            bReturn = False
            
        End If
        
    End If
    
    WScript.Echo(CStr(Connection.Count) + " objects for connection type " + ConvertConnectionTypeToString(CONNECTION_TYPE))
    
    GetConnection = bReturn
    
End Function

Function ConvertConnectionTypeToString(ConnectionID)
    
    Dim ConnectionString
    
    If (ConnectionID = CONNECTION_PUBLIC) Then
        
        ConnectionString = "public"
        
    ElseIf (ConnectionID = CONNECTION_PRIVATE) Then
        
        ConnectionString = "private"
        
    ElseIf (ConnectionID = CONNECTION_ALL) Then
        
        ConnectionString = "all"
        
    Else
        
        ConnectionString = "Unknown: " + CStr(ConnectionID)
        
    End If
    
    ConvertConnectionTypeToString = ConnectionString
    
End Function