function output_tint(tint)
	return
	{
		r = tint.r,
		g = tint.g,
		b = tint.b,
		a = 1
	}
end

function input_tint(tint)
	return
	{
		r = tint.r * wp.dark_tint,
		g = tint.g * wp.dark_tint,
		b = tint.b * wp.dark_tint,
		a = 1
	}
end

function exists(name)
	if data then
		return data.raw.item[name] and true or false
	end
	if game then
		return game.item_prototypes[name] and true or false
	end
	return true
end


function display_number(value)
	if not value then
		return "0"
	end
	
	if value < 1000 then
		return math.floor(value * 10) / 10
	end
	value = value / 1000
	if value < 1000 then
		return (math.floor(value * 10) / 10) .. "k"
	end
	value = value / 1000
	if value < 1000 then
		return (math.floor(value * 10) / 10) .. "M"
	end
	value = value / 1000
	if value < 1000 then
		return (math.floor(value * 10) / 10) .. "G"
	end
	value = value / 1000
	if value < 1000 then
		return (math.floor(value * 10) / 10) .. "T"
	end
	return math.floor(value) .. "T"
end


wp = {
	dark_tint = 0.6,
	color_intensity = 0.5,
	stack_size = 10,
	mining_time = 1,
	-- Number of seconds worth of power required to warm up after placement.
	warmup_time = 15	,
	-- Controls how long (as a multiple of buffer_ticks) a tesseract is ignored when its order can't be fulfilled.
	unfulfilled_cooldown = 1,
}

local initial_flow = 500 * 1000 -- 500kW
local initial_upkeep = 300 * 1000 -- 300kW

local flow_multiplier = 8
local upkeep_multiplier = 10


wp.tesseract = {
	{  -- Tesseract mk1
		tint = {r=1, g=1, b=1-wp.color_intensity},
		
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return true end,
		
		-- Technology
		prereq = {"electric-energy-distribution-1", "engine"},
		unit =
		{
		  count = 75,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1}
		  },
		  time = 15
		},
		
		-- Entity
		flow_limit = initial_flow * (flow_multiplier ^ 0),
		global_drain = initial_upkeep * (upkeep_multiplier ^ 0),
		efficiency = 0.6,
		health = 100,
		
		-- Recipe
		input_ingredients =
		{
			{"engine-unit", 10},
			{"electronic-circuit", 5},
		},
		output_ingredients =
		{
			{"engine-unit", 10},
			{"electronic-circuit", 5},
		},
	},
	{  -- Tesseract mk2
		tint = {r=1, g=1-wp.color_intensity, b=1-wp.color_intensity},
		
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return true end,
		
		-- Technology
		prereq = {"wireless-power-1", "electric-energy-accumulators", "electric-engine"},
		unit =
		{
		  count = 150,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1}
		  },
		  time = 30
		},
		
		-- Entity
		flow_limit = initial_flow * (flow_multiplier ^ 1),
		global_drain = initial_upkeep * (upkeep_multiplier ^ 1),
		efficiency = 0.8,
		health = 150,
		
		-- Recipe
		input_ingredients =
		{
			{"input-tesseract-1", 5},
			{"electric-engine-unit", 5},
			{"accumulator", 2},
		},
		output_ingredients =
		{
			{"output-tesseract-1", 5},
			{"electric-engine-unit", 5},
			{"accumulator", 2},
		},
	},
	{  -- Tesseract mk3
		tint = {r=1-wp.color_intensity, g=1-wp.color_intensity, b=1},
		
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return true end,
		
		-- Technology
		prereq = {"wireless-power-2", "electric-energy-distribution-2", "nuclear-power"},
		unit =
		{
		  count = 250,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"chemical-science-pack", 1}
		  },
		  time = 45
		},
		
		-- Entity
		flow_limit = initial_flow * (flow_multiplier ^ 2),
		global_drain = initial_upkeep * (upkeep_multiplier ^ 2),
		efficiency = 0.9,
		health = 250,
		
		-- Recipe
		input_ingredients =
		{
			{"input-tesseract-2", 5},
			{"uranium-fuel-cell", 5},
			{"substation", 10},
		},
		output_ingredients =
		{
			{"output-tesseract-2", 5},
			{"uranium-fuel-cell", 5},
			{"substation", 10},
		},
	},
	{  -- Tesseract mk4
		tint = {r=1, g=1-wp.color_intensity, b=1},
		
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return exists("large-accumulator-3") end,
		
		-- Technology
		prereq = {"wireless-power-3", "bob-electric-energy-accumulators-4", "advanced-electronics-2"},
		unit =
		{
		  count = 500,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"chemical-science-pack", 1},
			{"production-science-pack", 1}
		  },
		  time = 60
		},
		
		-- Entity
		flow_limit = initial_flow * (flow_multiplier ^ 3),
		global_drain = initial_upkeep * (upkeep_multiplier ^ 3),
		efficiency = 0.95,
		health = 400,
		
		-- Recipe
		input_ingredients =
		{
			{"input-tesseract-3", 5},
			{"processing-unit", 5},
			{"large-accumulator-3", 50},
		},
		output_ingredients =
		{
			{"output-tesseract-3", 5},
			{"processing-unit", 5},
			{"large-accumulator-3", 50},
		},
	},
}



wp.personal_tesseract = {
	{  -- Personal Tesseract mk1
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return settings.startup["wp-config-personal"].value end,
		
		-- Technology
		prereq = {"wireless-power-3", "fusion-reactor-equipment"},
		unit =
		{
		  count = 400,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"military-science-pack", 1},
			{"chemical-science-pack", 1},
			{"utility-science-pack", 1}
		  },
		  time = 30
		},
		
		-- Equipment
		buffer_capacity = 750 * 1000,			-- J of buffer.
		flow_limit = 1500 * 1000,				-- W throughput
		individual_drain = 10 * 1000 * 1000,	-- W drain
		efficiency = 0.1,						-- Cost to the grid is multiplied by 1/efficiency.
		size = 4,								-- Equipment is size by size.
		
		-- Recipe
		ingredients =
		{
			{"fusion-reactor-equipment", 1},
			{"output-tesseract-3", 1},
		},
		result_count = 1,
	},
	{  -- Personal Tesseract mk2
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return settings.startup["wp-config-personal"].value and exists("fusion-reactor-equipment-2") end,
		
		-- Technology
		prereq = {"personal-tesseract-1", "fusion-reactor-equipment-2"},
		unit =
		{
		  count = 500,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"military-science-pack", 1},
			{"chemical-science-pack", 1},
			{"utility-science-pack", 1}
		  },
		  time = 45
		},
		
		-- Equipment
		buffer_capacity = 700 * 1000,			-- J of buffer.
		flow_limit = 1400 * 1000,				-- W throughput
		individual_drain = 7.5 * 1000 * 1000,	-- W drain
		efficiency = 0.08,						-- Cost to the grid is multiplied by 1/efficiency.
		size = 3,								-- Equipment is size by size.
		
		-- Recipe
		ingredients =
		{
			{"personal-tesseract-1", 1},
			{"fusion-reactor-equipment-2", 1},
		},
		result_count = 2,
	},
	{  -- Personal Tesseract mk3
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return settings.startup["wp-config-personal"].value and exists("fusion-reactor-equipment-3") end,
		
		-- Technology
		prereq = {"personal-tesseract-2", "fusion-reactor-equipment-3"},
		unit =
		{
		  count = 600,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"military-science-pack", 1},
			{"chemical-science-pack", 1},
			{"production-science-pack", 1},
			{"utility-science-pack", 1}
		  },
		  time = 45
		},
		
		-- Equipment
		buffer_capacity = 500 * 1000,			-- J of buffer.
		flow_limit = 1000 * 1000,				-- W throughput
		individual_drain = 5 * 1000 * 1000,		-- W drain
		efficiency = 0.05,						-- Cost to the grid is multiplied by 1/efficiency.
		size = 2,								-- Equipment is size by size.
		
		-- Recipe
		ingredients =
		{
			{"personal-tesseract-2", 1},
			{"fusion-reactor-equipment-3", 1},
		},
		result_count = 3,
	},
	{  -- Personal Tesseract mk4
		-- If false, exit loop and ignore this tier and all following tiers.
		enable = function() return settings.startup["wp-config-personal"].value and exists("fusion-reactor-equipment-4") end,
		
		-- Technology
		prereq = {"personal-tesseract-3", "fusion-reactor-equipment-4", "space-science-pack"},
		unit =
		{
		  count = 700,
		  ingredients =
		  {
			{"automation-science-pack", 1},
			{"logistic-science-pack", 1},
			{"military-science-pack", 1},
			{"chemical-science-pack", 1},
			{"production-science-pack", 1},
			{"utility-science-pack", 1},
			{"space-science-pack", 1}
		  },
		  time = 60
		},
		
		-- Equipment
		buffer_capacity = 250 * 1000,			-- J of buffer.
		flow_limit = 500 * 1000,				-- W throughput
		individual_drain = 0 * 1000 * 1000,		-- W drain
		efficiency = 0.02,						-- Cost to the grid is multiplied by 1/efficiency.
		size = 1,								-- Equipment is size by size.
		
		-- Recipe
		ingredients =
		{
			{"personal-tesseract-3", 1},
			{"fusion-reactor-equipment-4", 1},
		},
		result_count = 4,
	},
}



wp.vehicle_tesseract = {

}



if (not settings.startup["wp-config-drain"].value) then
	for i=1, #wp.tesseract do
		wp.tesseract[i].global_drain = 0
	end
end


if (settings.startup["wp-config-efficiency"].value == "High-Efficiency") then
	-- Make all tesseracts have half the power loss. (eg, 50% efficiency -> 75%, 60% efficiency -> 80%, etc)
	for i=1, #wp.tesseract do
		local tesseract = wp.personal_tesseract[i]
		tesseract.efficiency = 1 - (1 - tesseract.efficiency) / 2
	end
elseif (settings.startup["wp-config-efficiency"].value == "Perfect") then
	for i=1, #wp.tesseract do
		wp.tesseract[i].efficiency = 1
	end
end

if not settings.startup["wp-config-drain"].value then
	-- Make all tesseracts have no global drain.
	for i=1, #wp.tesseract do
		wp.tesseract[i].global_drain = 0
	end
end



for i=1, #wp.tesseract do
	local tesseract = wp.tesseract[i]
	tesseract.in_label = "input-tesseract-" .. i
	tesseract.out_label = "output-tesseract-" .. i
	-- Normal efficiency describes input + output. This describes only input OR output.
	tesseract.individual_efficiency = math.sqrt(tesseract.efficiency)
	
	-- Account for efficiency loss so that global drain is not multiplied by it.
	tesseract.global_drain_per_tick = tesseract.global_drain / 60 * tesseract.individual_efficiency
	tesseract.individual_drain_per_tick = 0
	tesseract.warmup_cost = wp.warmup_time * tesseract.flow_limit
	tesseract.index = i
	tesseract.key = "tesseract"
	tesseract.buffer_key = "electric_buffer_size"
end

if not settings.startup["wp-config-warmup"].value then
	-- Make all tesseracts have no warmup phase.
	for i=1, #wp.tesseract do
		wp.tesseract[i].warmup_cost = 0
	end
end


if settings.startup["wp-config-personal-reduced"].value then
	-- Make personal tesseracts output 66% power while still costing the same amount.
	for i=1, #wp.personal_tesseract do
		local tesseract = wp.personal_tesseract[i]
		tesseract.flow_limit = tesseract.flow_limit * 2/3
		tesseract.efficiency = tesseract.efficiency * 2/3
	end
end


if settings.startup["wp-config-personal-efficiency"].value == "High-Efficiency" then
	-- Make all personal tesseracts have half the power cost to the grid.
	for i=1, #wp.personal_tesseract do
		local tesseract = wp.personal_tesseract[i]
		tesseract.efficiency = tesseract.efficiency * 2
		tesseract.individual_drain = tesseract.individual_drain / 2
	end
end


for i=1, #wp.personal_tesseract do
	local tesseract = wp.personal_tesseract[i]
	tesseract.label = "personal-tesseract-" .. i
	-- Normal efficiency describes input + output. This describes only input OR output.
	tesseract.individual_efficiency = tesseract.efficiency
	
	tesseract.individual_drain_per_tick = tesseract.individual_drain / 60
	tesseract.warmup_cost = 0
	tesseract.global_drain_per_tick = 0
	tesseract.index = i
	tesseract.key = "personal_tesseract"
	tesseract.buffer_key = "max_energy"
	
	-- Need a max cost in MW.
	tesseract.max_cost = ((tesseract.flow_limit / tesseract.efficiency) + tesseract.individual_drain)
end