require "config"


-- These functions shamelessly copied from the base mod.
function accumulator_picture(tint, repeat_count)
  return
  {
    layers =
    {
      {
        filename = "__base__/graphics/entity/accumulator/accumulator.png",
        priority = "high",
        width = 66,
        height = 94,
        repeat_count = repeat_count,
        shift = util.by_pixel(0, -10),
        tint = tint,
        animation_speed = 0.5,
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator.png",
          priority = "high",
          width = 130,
          height = 189,
          repeat_count = repeat_count,
          shift = util.by_pixel(0, -11),
          tint = tint,
          animation_speed = 0.5,
          scale = 0.5
        }
      },
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-shadow.png",
        priority = "high",
        width = 120,
        height = 54,
        repeat_count = repeat_count,
        shift = util.by_pixel(28, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-shadow.png",
          priority = "high",
          width = 234,
          height = 106,
          repeat_count = repeat_count,
          shift = util.by_pixel(29, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  }
end

function accumulator_charge(tint)
  return
  {
    layers =
    {
      accumulator_picture(tint , 24),
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-charge.png",
        priority = "high",
        width = 90,
        height = 100,
        line_length = 6,
        frame_count = 24,
        blend_mode = "additive",
        shift = util.by_pixel(0, -22),
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-charge.png",
          priority = "high",
          width = 178,
          height = 206,
          line_length = 6,
          frame_count = 24,
          blend_mode = "additive",
          shift = util.by_pixel(0, -22),
          scale = 0.5
        }
      }
    }
  }
end

function accumulator_discharge(tint)
  return
  {
    layers =
    {
      accumulator_picture(tint , 24),
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-discharge.png",
        priority = "high",
        width = 88,
        height = 104,
        line_length = 6,
        frame_count = 24,
        blend_mode = "additive",
        shift = util.by_pixel(-2, -22),
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-discharge.png",
          priority = "high",
          width = 170,
          height = 210,
          line_length = 6,
          frame_count = 24,
          blend_mode = "additive",
          shift = util.by_pixel(-1, -23),
          scale = 0.5
        }
      }
    }
  }
end


for i=1, #wp.tesseract do
	tesseract = wp.tesseract[i]
	if not tesseract.enable() then
		break
	end
		
	data:extend(
	{
		{
			type = "electric-energy-interface",
			name = tesseract.in_label,
			localised_name = {"entity-name.input-tesseract", i},
			localised_description = {"description.tesseract", display_number(tesseract.flow_limit), tesseract.efficiency * 100, display_number(tesseract.global_drain), display_number(tesseract.flow_limit * wp.warmup_time), wp.warmup_time},
			icons = { {icon = "__base__/graphics/icons/accumulator.png", tint = input_tint(tesseract.tint)} },
			icon_size = 32,
			flags = {"placeable-neutral", "player-creation"},
			minable = {mining_time = wp.mining_time, result = tesseract.in_label},
			max_health = tesseract.health,
			corpse = "medium-remnants",
			subgroup = "other",
			collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
			selection_box = {{-1, -1}, {1, 1}},
			drawing_box = {{-1, -1.5}, {1, 1}},
			gui_mode = "none",
			allow_copy_paste = false,
			fast_replaceable_group = "tesseract",
			energy_source =
			{
				type = "electric",
				buffer_capacity = (tesseract.flow_limit / 60) .. "J",
				usage_priority = "secondary-input",
				input_flow_limit = tesseract.flow_limit .. "W",
				output_flow_limit = "0W"
			},

			energy_production = "0kW",
			energy_usage = "0kW",
			picture = accumulator_picture(input_tint(tesseract.tint)),
			charge_animation = accumulator_charge(input_tint(tesseract.tint)),
			charge_cooldown = 120,
			charge_light = {intensity = 0.3, size = 7},
			discharge_animation = accumulator_charge(input_tint(tesseract.tint)),
			discharge_cooldown = 120,
			discharge_light = {intensity = 0.3, size = 7},
			vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65},
			working_sound =
			{
				sound =
				{
					filename = "__base__/sound/accumulator-working.ogg",
					volume = 1
				},
				idle_sound =
				{
					filename = "__base__/sound/accumulator-idle.ogg",
					volume = 0.4
				},
				max_sounds_per_type = 5
			}
		},
		{
			type = "electric-energy-interface",
			name = tesseract.out_label,
			localised_name = {"entity-name.output-tesseract", i},
			localised_description = {"description.tesseract", display_number(tesseract.flow_limit), tesseract.efficiency * 100, display_number(tesseract.global_drain), display_number(tesseract.flow_limit * wp.warmup_time), wp.warmup_time},
			icons = { {icon = "__base__/graphics/icons/accumulator.png", tint = output_tint(tesseract.tint)} },
			icon_size = 32,
			flags = {"placeable-neutral", "player-creation"},
			minable = {mining_time = wp.mining_time, result = tesseract.out_label},
			max_health = tesseract.health,
			corpse = "medium-remnants",
			subgroup = "other",
			collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
			selection_box = {{-1, -1}, {1, 1}},
			drawing_box = {{-1, -1.5}, {1, 1}},
			gui_mode = "none",
			allow_copy_paste = false,
			fast_replaceable_group = "tesseract",
			energy_source =
			{
				type = "electric",
				buffer_capacity = (tesseract.flow_limit / 60) .. "J",
				usage_priority = "secondary-output",
				input_flow_limit = "0W",
				output_flow_limit = tesseract.flow_limit .. "W"
			},

			energy_production = "0kW",
			energy_usage = "0kW",
			picture = accumulator_picture(output_tint(tesseract.tint)),
			vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65},
			working_sound =
			{
				sound =
				{
					filename = "__base__/sound/accumulator-working.ogg",
					volume = 1
				},
				idle_sound =
				{
					filename = "__base__/sound/accumulator-idle.ogg",
					volume = 0.4
				},
				max_sounds_per_type = 5
			}
		},
	})
end
