require "config"

for i=1, #wp.personal_tesseract do
	local tesseract = wp.personal_tesseract[i]
	if not tesseract.enable() then
		break
	end

	data:extend({
	{
		type = "battery-equipment",
		name = tesseract.label,
		localised_name = {"equipment-name.personal-tesseract", i},
		--localised_description = {"description.personal-tesseract", tesseract.efficiency * 100, tesseract.global_drain, tesseract.max_cost},
		sprite = 
		{
			filename = "__wireless-power__/graphics/personal-tesseract/personal-tesseract-" .. tesseract.size .. "x" .. tesseract.size .. ".png",
			width = 32 * tesseract.size,
			height = 32 * tesseract.size,
			priority = "medium"
		},
		shape =
		{
			width = tesseract.size,
			height = tesseract.size,
			type = "full"
		},
		energy_source =
		{
			type = "electric",
			buffer_capacity = (tesseract.flow_limit / 60) .. "J",
			input_flow_limit = "0W",
			output_flow_limit = tesseract.flow_limit .. "W",
			usage_priority = "primary-output"
		},
		categories = {"armor"}
	},
	})
end