require "config"

for i=1, #wp.tesseract do
	tesseract = wp.tesseract[i]
	if not tesseract.enable() then
		break
	end

	data:extend(
	{
		{
			type = "item",
			name = tesseract.in_label,
			localised_name = {"entity-name.input-tesseract", i},
			localised_description = {"description.tesseract", display_number(tesseract.flow_limit), tesseract.efficiency * 100, display_number(tesseract.global_drain), display_number(tesseract.flow_limit * wp.warmup_time), wp.warmup_time},
			icons = { {icon = "__base__/graphics/icons/accumulator.png", tint = input_tint(tesseract.tint)} },
			icon_size = 32,
			subgroup = "energy",
			order = "e[accumulator]-x[tesseract-mk" .. i .. "]-i[input]",
			place_result = tesseract.in_label,
			stack_size = wp.stack_size
		},
		{
			type = "item",
			name = tesseract.out_label,
			localised_name = {"entity-name.output-tesseract", i},
			localised_description = {"description.tesseract", display_number(tesseract.flow_limit), tesseract.efficiency * 100, display_number(tesseract.global_drain), display_number(tesseract.flow_limit * wp.warmup_time), wp.warmup_time},
			icons = { {icon = "__base__/graphics/icons/accumulator.png", tint = output_tint(tesseract.tint)} },
			icon_size = 32,
			subgroup = "energy",
			order = "e[accumulator]-x[tesseract-mk" .. i .. "]-o[output]",
			place_result = tesseract.out_label,
			stack_size = wp.stack_size
		},
	})
end


for i=1, #wp.personal_tesseract do
	local tesseract = wp.personal_tesseract[i]
	if not tesseract.enable() then
		break
	end

	data:extend({
		{
			type = "item",
			name = tesseract.label,
			localised_name = {"item-name.personal-tesseract", i},
			localised_description = {"description.personal-tesseract", display_number(tesseract.flow_limit), tesseract.efficiency * 100, display_number(tesseract.individual_drain), display_number(tesseract.max_cost)},
			icon = "__wireless-power__/graphics/personal-tesseract/personal-tesseract.png",
			icon_size = 128,
			subgroup = "equipment",
			order = "a[energy-source]-c[tesseract]-" .. i,
			placed_as_equipment_result = tesseract.label,
			stack_size = wp.stack_size,
			default_requiest_amount = 10,
		},
	})
end