require "config"

for i=1, #wp.tesseract do
	if not wp.tesseract[i].enable() then
		break
	end
	
	data:extend({
		{
			type = "technology",
			name =  "wireless-power-" .. i,
			localised_name = {"technology-name.tesseract", i},
			localised_description = {"technology-description.tesseract"},
			icons = { {icon = "__base__/graphics/technology/electric-energy-acumulators.png", tint = input_tint(wp.tesseract[i].tint)} },
			icon_size = 128,
			effects = {
				{
					type = "unlock-recipe",
					recipe = wp.tesseract[i].in_label
				},
				{
					type = "unlock-recipe",
					recipe = wp.tesseract[i].out_label
				},
			},
			prerequisites = wp.tesseract[i].prereq,
			unit = wp.tesseract[i].unit,
			order = "c-e-b-" .. i,
			upgrade = false,
		}
	})
end

for i=1, #wp.personal_tesseract do
	local tesseract = wp.personal_tesseract[i]
	if not tesseract.enable() then
		break
	end
	
	data:extend({
		{
			type = "technology",
			name = tesseract.label,
			localised_name = {"technology-name.personal-tesseract", i},
			localised_description = {"technology-description.personal-tesseract"},
			icon = "__wireless-power__/graphics/personal-tesseract/personal-tesseract.png",
	        icon_size = 128,
			effects = {
				{
					type = "unlock-recipe",
					recipe = tesseract.label
				},
			},
			prerequisites = tesseract.prereq,
			unit = tesseract.unit,
			order = "c-e-c-" .. i,
			upgrade = false,
		},
	})
end