/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class BundleExplorer {
    private static final int HEADER_SIZE = 32;
    private static final int ALIGNMENT_TARGET = 4096;
    private static final String FOOTER_DATA = "AlignmentUnused";

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage:  java BundleExplorer <Input Bundle File> <Output File> <Mod Base Directory> [-r (optional, pass '-r' to automatically replace the input file with the output file upon completion)]");
            return;
        }
        String input = args[0];
        String output = args[1];
        String modRoot = args[2];
        boolean overwriteBundle = args.length > 3 && "-r".equals(args[3]);
        FileInputStream in = new FileInputStream(input);
        IOUtils.readAndDiscard(in, 8);
        int totalSize = IOUtils.readInt32LSBFirst(in);
        int otherSize = IOUtils.readInt32LSBFirst(in);
        int dataOffset = IOUtils.readInt32LSBFirst(in);
        byte[] otherHeaderData = IOUtils.readBytes(in, 12);
        System.out.println("Reading bundle '" + input + "', size=" + totalSize + ", dummySize=" + otherSize + ", dataOffset=" + dataOffset + ", dataOffset+32=" + (dataOffset + 32) + ", otherHeaderData:  " + BundleExplorer.bytesToString(otherHeaderData));
        int readOffset = 32;
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        while (readOffset < dataOffset + 32) {
            String filename = IOUtils.readFixedLengthString(in);
            readOffset += 256;
            byte[] hash = IOUtils.readBytes(in, 16);
            readOffset += 16;
            IOUtils.readAndDiscard(in, 4);
            readOffset += 4;
            int uncompressedSize = IOUtils.readInt32LSBFirst(in);
            readOffset += 4;
            int compressedSize = IOUtils.readInt32LSBFirst(in);
            readOffset += 4;
            int fileOffset = IOUtils.readInt32LSBFirst(in);
            readOffset += 4;
            long modifyTime = IOUtils.readInt64LSBFirst(in);
            readOffset += 8;
            IOUtils.readAndDiscard(in, 16);
            readOffset += 16;
            int unknownBytes = IOUtils.readInt32LSBFirst(in);
            readOffset += 4;
            int compressionAlgo = IOUtils.readInt32LSBFirst(in);
            readOffset += 4;
            BundleFile bundleFile = new BundleFile(filename, hash, uncompressedSize, compressedSize, dataOffset, fileOffset, modifyTime, unknownBytes, compressionAlgo);
            System.out.println("Read file descriptor; " + bundleFile);
            bundleFiles.add(bundleFile);
        }
        int numLoaded = 0;
        System.out.println("Loading " + bundleFiles.size() + " files, this may take awhile...");
        ArrayList sortedFiles = new ArrayList(bundleFiles);
        Collections.sort(sortedFiles, new BundleFileOffsetCompare());
        for (BundleFile file : sortedFiles) {
            int seekBy = file.getOffset(readOffset) - readOffset;
            IOUtils.readAndDiscard(in, seekBy);
            readOffset += seekBy;
            byte[] rawData = IOUtils.readBytes(in, file.getCompressedSize());
            readOffset += rawData.length;
            if (file.getCompressionAlgo() == 0) {
                file.setData(rawData);
            } else if (file.getCompressionAlgo() == 1) {
                int numRead = 0;
                if (numRead == file.getUncompressedSize()) {
                    System.out.println("Successfully decompressed:  " + file.getFilename());
                } else {
                    file.forceCompression(1);
                    file.setCompressionAlgo(0);
                    file.setData(rawData);
                }
            } else {
                file.forceCompression(file.getCompressionAlgo());
                file.setCompressionAlgo(0);
                file.setData(rawData);
            }
            if (++numLoaded % 100 != 0) continue;
            System.out.println("Loaded " + numLoaded + " / " + bundleFiles.size() + " files...");
        }
        ((InputStream)in).close();
        System.out.println("Done loading files; checking for mods...");
        for (BundleFile file : bundleFiles) {
            File modFile = new File(String.valueOf(modRoot) + "/" + file.getFilename());
            if (!modFile.exists()) continue;
            System.out.println("Overriding file " + file.getFilename() + " with content from '" + modFile.getAbsolutePath() + "'.");
            try {
                in = new FileInputStream(modFile);
                byte[] fileData = IOUtils.readBytes(in, (int)modFile.length());
                ((InputStream)in).close();
                file.forceCompression(-1);
                file.setCompressionAlgo(0);
                file.setData(fileData);
            }
            catch (Exception e) {
                System.out.println("ERROR:  Failed to override file " + file.getFilename() + ", detailed error message follows;");
                e.printStackTrace();
            }
        }
        System.out.println("Finished loading mods; writing output...");
        int writePosition = 32;
        for (BundleFile file : bundleFiles) {
            writePosition += file.getHeaderEntrySize();
        }
        if (writePosition != dataOffset + 32) {
            System.out.println("WARN:  Data offset has changed!");
        }
        dataOffset = writePosition - 32;
        for (BundleFile file : sortedFiles) {
            writePosition = file.getOffset(writePosition);
            writePosition += file.getCompressedSize();
        }
        int neededFooterBytes = 16;
        if (neededFooterBytes < 16) {
            writePosition += neededFooterBytes;
        }
        FileOutputStream out = new FileOutputStream(output);
        IOUtils.writeString("POTATO70", out);
        IOUtils.writeInt32LSBFirst(writePosition, out);
        IOUtils.writeInt32LSBFirst(otherSize, out);
        IOUtils.writeInt32LSBFirst(dataOffset, out);
        ((OutputStream)out).write(otherHeaderData);
        writePosition = 32;
        for (BundleFile file : bundleFiles) {
            writePosition += file.writeFileHeader(out);
        }
        for (BundleFile file : sortedFiles) {
            writePosition += file.writeCompressedData(out, writePosition);
        }
        if (neededFooterBytes < 16) {
            IOUtils.writeString(FOOTER_DATA.substring(0, neededFooterBytes), out);
        }
        ((OutputStream)out).close();
        System.out.println("Bundle successfully written to " + output + "!");
        if (overwriteBundle) {
            System.out.println("Replacing original bundle file...");
            boolean renamed = new File(input).renameTo(new File(String.valueOf(input) + ".bak"));
            if (renamed && !new File(input).exists()) {
                renamed = new File(output).renameTo(new File(input));
                if (renamed) {
                    System.out.println("Modified bundle installed successfully!");
                } else {
                    System.out.println("WARN:  Failed to move '" + output + "' to '" + input + "'!");
                    System.out.println("WARN:  The mod has not been installed (you can attempt a manual installation by moving '" + output + "' to '" + input + "')");
                }
            } else {
                System.out.println("WARN:  Failed to move '" + input + "' to '" + input + ".bak'! (perhaps you already have a file called '" + input + ".bak'?)");
                System.out.println("WARN:  The mod has not been installed (you can attempt a manual installation by moving '" + output + "' to '" + input + "')");
            }
        }
        Thread.sleep(5000L);
    }

    private static String bytesToString(byte[] bytes) {
        int series = 0;
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X ", b));
            if (++series == 64) {
                sb.append("\n");
                series = 0;
            }
            ++n2;
        }
        return sb.toString();
    }

    private static class BundleFile {
        private String filename;
        private byte[] hash;
        private int uncompressedSize;
        private int compressedSize;
        private int offset;
        private long modifyTime;
        private int otherBytes;
        private int compressionAlgo;
        private byte[] data;
        private byte[] compressedData;
        private int forceCompressionAlgo;

        public BundleFile(String name, byte[] hash, int uncompressed, int compressed, int dataBlockOffset, int offset, long modify, int otherBytes, int algo) {
            this.filename = name;
            this.hash = hash;
            this.uncompressedSize = uncompressed;
            this.compressedSize = compressed;
            this.offset = offset;
            this.modifyTime = modify;
            this.otherBytes = otherBytes;
            this.compressionAlgo = algo;
            this.forceCompressionAlgo = -1;
        }

        public String toString() {
            return "name=" + this.filename + ", size=" + this.uncompressedSize + ", storedSize=" + this.compressedSize + ", compressionAlgo=" + this.compressionAlgo + ", offset=" + this.offset + ", modified=" + Long.toHexString(this.modifyTime) + ", unknownValue=" + this.otherBytes + ", aligned=" + (this.offset % 4096 == 0) + ", hash:  " + BundleExplorer.bytesToString(this.hash);
        }

        public int getHeaderEntrySize() {
            return 320;
        }

        public void forceCompression(int forcedAlgo) {
            this.forceCompressionAlgo = forcedAlgo;
        }

        public int getCompressionAlgo() {
            return this.compressionAlgo;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getFilename() {
            return this.filename;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public int getUncompressedSize() {
            return this.uncompressedSize;
        }

        public int getCompressedSize() {
            return this.compressedSize;
        }

        public int getOffset(int minPos) {
            if (this.offset >= minPos) {
                return this.offset;
            }
            int firstValidPos = minPos / 4096 * 4096 + 4096;
            while (firstValidPos < minPos) {
                firstValidPos += 4096;
            }
            System.out.println("Computed new offset for file:  " + this.getFilename() + ", oldOffset=" + this.offset + ", newOffset=" + firstValidPos + ", aligned=" + (this.offset % 4096 == 0));
            this.offset = firstValidPos;
            return this.offset;
        }

        public long getModifyTime() {
            return this.modifyTime;
        }

        public int getOtherBytes() {
            return this.otherBytes;
        }

        public byte[] getCompressedData() {
            return this.compressedData;
        }

        public void setCompressionAlgo(int compressionAlgo) {
            this.compressionAlgo = compressionAlgo;
            if (compressionAlgo == 0) {
                this.compressedData = null;
                if (this.data != null) {
                    this.compressedSize = this.data.length;
                }
            }
        }

        public void setData(byte[] data) throws NoSuchAlgorithmException {
            if (this.data == null) {
                this.data = data;
                return;
            }
            this.compressionAlgo = 0;
            this.data = data;
            this.compressedData = data;
            this.uncompressedSize = data.length;
            this.compressedSize = data.length;
        }

        public int writeFileHeader(OutputStream out) throws IOException {
            IOUtils.writeFixedLengthString(this.getFilename(), out);
            out.write(this.getHash());
            IOUtils.writeInt32LSBFirst(0, out);
            IOUtils.writeInt32LSBFirst(this.getUncompressedSize(), out);
            IOUtils.writeInt32LSBFirst(this.getCompressedSize(), out);
            IOUtils.writeInt32LSBFirst(this.offset, out);
            IOUtils.writeInt64LSBFirst(this.getModifyTime(), out);
            out.write(new byte[16]);
            IOUtils.writeInt32LSBFirst(this.getOtherBytes(), out);
            IOUtils.writeInt32LSBFirst(this.forceCompressionAlgo != -1 ? this.forceCompressionAlgo : this.getCompressionAlgo(), out);
            return this.getHeaderEntrySize();
        }

        public int writeCompressedData(OutputStream out, int writePosition) throws IOException {
            int numWritten = 0;
            int paddingLength = this.getOffset(writePosition) - writePosition;
            if (paddingLength > 0) {
                int preliminaryPaddingLength = 16;
                if (preliminaryPaddingLength < 16) {
                    IOUtils.writeString(BundleExplorer.FOOTER_DATA.substring(0, preliminaryPaddingLength), out);
                    paddingLength -= preliminaryPaddingLength;
                    numWritten += preliminaryPaddingLength;
                }
                if (paddingLength > 0) {
                    out.write(new byte[paddingLength]);
                    numWritten += paddingLength;
                }
            }
            if (this.getCompressionAlgo() != 1 || this.getCompressedData() == null) {
                out.write(this.getData());
                numWritten += this.getData().length;
            } else {
                out.write(this.getCompressedData());
                numWritten += this.getCompressedData().length;
            }
            return numWritten;
        }
    }

    private static class BundleFileOffsetCompare
    implements Comparator<BundleFile> {
        private BundleFileOffsetCompare() {
        }

        @Override
        public int compare(BundleFile left, BundleFile right) {
            return Integer.valueOf(left.getOffset(0)).compareTo(right.getOffset(0));
        }
    }

    private static class IOUtils {
        static int allBytesRead = 0;
        private static final int UNSIGNED_BYTE = 255;
        private static final int DEFAULT_STRING_LENGTH = 256;

        private IOUtils() {
        }

        public static void readAndDiscard(InputStream in, int numBytes) throws IOException {
            int numRead = 0;
            while (numRead < numBytes && in.read() != -1) {
                ++numRead;
            }
            allBytesRead += numRead;
        }

        public static byte[] readBytes(InputStream in, int numBytes) throws IOException {
            int numRead = 0;
            byte[] result = new byte[numBytes];
            Arrays.fill(result, (byte)0);
            while (numRead < numBytes) {
                int addedBytes = in.read(result, numRead, result.length - numRead);
                if (addedBytes < 1) {
                    System.out.println("ERROR:  Failed to read bytes; lookingFor=" + numBytes + ", totalFound=" + numRead + ", allBytesRead=" + allBytesRead);
                    break;
                }
                numRead += addedBytes;
            }
            allBytesRead += numRead;
            return result;
        }

        public static int readInt32LSBFirst(InputStream in) throws IOException {
            byte[] components = IOUtils.readBytes(in, 4);
            return 0xFF & components[0] | (0xFF & components[1]) << 8 | (0xFF & components[2]) << 16 | (0xFF & components[3]) << 24;
        }

        public static long readInt64LSBFirst(InputStream in) throws IOException {
            byte[] components = IOUtils.readBytes(in, 8);
            return (long)(0xFF & components[0] | (0xFF & components[1]) << 8 | (0xFF & components[2]) << 16 | (0xFF & components[3]) << 24) | (long)(0xFF & components[4]) << 32 | (long)(0xFF & components[5]) << 40 | (long)(0xFF & components[6]) << 48 | (long)(0xFF & components[7]) << 56;
        }

        public static String readFixedLengthString(InputStream in) throws IOException {
            return IOUtils.readFixedLengthString(in, 256);
        }

        public static String readFixedLengthString(InputStream in, int stringLength) throws IOException {
            byte[] ascii = IOUtils.readBytes(in, stringLength);
            StringBuffer buffer = new StringBuffer();
            byte[] byArray = ascii;
            int n = ascii.length;
            int n2 = 0;
            while (n2 < n) {
                byte next = byArray[n2];
                if (next == 0) break;
                buffer.append((char)next);
                ++n2;
            }
            return buffer.toString();
        }

        public static void writeInt32LSBFirst(int number, OutputStream out) throws IOException {
            out.write(number & 0xFF);
            out.write(number >> 8 & 0xFF);
            out.write(number >> 16 & 0xFF);
            out.write(number >> 24 & 0xFF);
        }

        public static void writeInt64LSBFirst(long number, OutputStream out) throws IOException {
            out.write((int)(number & 0xFFL));
            out.write((int)(number >> 8 & 0xFFL));
            out.write((int)(number >> 16 & 0xFFL));
            out.write((int)(number >> 24 & 0xFFL));
            out.write((int)(number >> 32 & 0xFFL));
            out.write((int)(number >> 40 & 0xFFL));
            out.write((int)(number >> 48 & 0xFFL));
            out.write((int)(number >> 56 & 0xFFL));
        }

        public static void writeString(String text, OutputStream out) throws IOException {
            out.write(text.getBytes());
        }

        public static void writeFixedLengthString(String text, OutputStream out) throws IOException {
            IOUtils.writeFixedLengthString(text, out, 256);
        }

        public static void writeFixedLengthString(String text, OutputStream out, int stringLength) throws IOException {
            byte[] buffer;
            byte[] data = text.getBytes();
            if (data.length >= (buffer = new byte[stringLength]).length) {
                System.out.println("WARN:  Payload data exceeds maximum size of a fixed-length string, it will be truncated; text=" + text);
            }
            int numToCopy = data.length < buffer.length ? data.length : buffer.length - 1;
            System.arraycopy(data, 0, buffer, 0, numToCopy);
            out.write(buffer);
        }
    }
}

