# -*- coding: mbcs -*-
typelib_path = u'C:\\Windows\\SysWOW64\\msscript.ocx'
_lcid = 0 # change this if required
from ctypes import *
import comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0
from comtypes import GUID
from ctypes import HRESULT
from comtypes import BSTR
from comtypes import helpstring
from comtypes import COMMETHOD
from comtypes import dispid
from comtypes import IUnknown
from comtypes.automation import VARIANT
from comtypes import CoClass
from ctypes.wintypes import VARIANT_BOOL
from comtypes.automation import IDispatch
from comtypes.automation import _midlSAFEARRAY
from comtypes import DISPMETHOD, DISPPROPERTY, helpstring
STRING = c_char_p


class IScriptError(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Provides access to scripting error information'
    _iid_ = GUID('{70841C78-067D-11D0-95D8-00A02463AB28}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']
IScriptError._methods_ = [
    COMMETHOD([dispid(201), helpstring(u'Error number'), 'propget'], HRESULT, 'Number',
              ( ['retval', 'out'], POINTER(c_int), 'plNumber' )),
    COMMETHOD([dispid(202), helpstring(u'Source of the error'), 'propget'], HRESULT, 'Source',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrSource' )),
    COMMETHOD([dispid(203), helpstring(u'Friendly description of error'), 'propget'], HRESULT, 'Description',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrDescription' )),
    COMMETHOD([dispid(204), helpstring(u'File in which help for the error can be found'), 'propget'], HRESULT, 'HelpFile',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrHelpFile' )),
    COMMETHOD([dispid(205), helpstring(u'Context ID for the topic with information on the error'), 'propget'], HRESULT, 'HelpContext',
              ( ['retval', 'out'], POINTER(c_int), 'plHelpContext' )),
    COMMETHOD([dispid(-517), helpstring(u'Line of source code on which the error occurred'), 'propget'], HRESULT, 'Text',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrText' )),
    COMMETHOD([dispid(206), helpstring(u'Source code line number where the error occurred'), 'propget'], HRESULT, 'Line',
              ( ['retval', 'out'], POINTER(c_int), 'plLine' )),
    COMMETHOD([dispid(-529), helpstring(u'Source code column position where the error occurred'), 'propget'], HRESULT, 'Column',
              ( ['retval', 'out'], POINTER(c_int), 'plColumn' )),
    COMMETHOD([dispid(208), helpstring(u'Clear the script error')], HRESULT, 'Clear'),
]
################################################################
## code template for IScriptError implementation
##class IScriptError_Impl(object):
##    @property
##    def Description(self):
##        u'Friendly description of error'
##        #return pbstrDescription
##
##    @property
##    def Column(self):
##        u'Source code column position where the error occurred'
##        #return plColumn
##
##    @property
##    def Text(self):
##        u'Line of source code on which the error occurred'
##        #return pbstrText
##
##    def Clear(self):
##        u'Clear the script error'
##        #return 
##
##    @property
##    def Number(self):
##        u'Error number'
##        #return plNumber
##
##    @property
##    def Source(self):
##        u'Source of the error'
##        #return pbstrSource
##
##    @property
##    def HelpContext(self):
##        u'Context ID for the topic with information on the error'
##        #return plHelpContext
##
##    @property
##    def HelpFile(self):
##        u'File in which help for the error can be found'
##        #return pbstrHelpFile
##
##    @property
##    def Line(self):
##        u'Source code line number where the error occurred'
##        #return plLine
##

class IScriptModuleCollection(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Collection of modules'
    _iid_ = GUID('{70841C6F-067D-11D0-95D8-00A02463AB28}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']
class IScriptModule(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Context in which functions can be defined and expressions can be evaluated'
    _iid_ = GUID('{70841C70-067D-11D0-95D8-00A02463AB28}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']
IScriptModuleCollection._methods_ = [
    COMMETHOD([dispid(-4), 'hidden', 'propget'], HRESULT, '_NewEnum',
              ( ['retval', 'out'], POINTER(POINTER(IUnknown)), 'ppenumContexts' )),
    COMMETHOD([dispid(0), helpstring(u'Get a module indexed by position or module name'), 'propget'], HRESULT, 'Item',
              ( ['in'], VARIANT, 'Index' ),
              ( ['retval', 'out'], POINTER(POINTER(IScriptModule)), 'ppmod' )),
    COMMETHOD([dispid(1), helpstring(u'Number of modules'), 'propget'], HRESULT, 'Count',
              ( ['retval', 'out'], POINTER(c_int), 'plCount' )),
    COMMETHOD([dispid(2), helpstring(u'Add a new module')], HRESULT, 'Add',
              ( ['in'], BSTR, 'Name' ),
              ( ['in', 'optional'], POINTER(VARIANT), 'Object' ),
              ( ['retval', 'out'], POINTER(POINTER(IScriptModule)), 'ppmod' )),
]
################################################################
## code template for IScriptModuleCollection implementation
##class IScriptModuleCollection_Impl(object):
##    @property
##    def Count(self):
##        u'Number of modules'
##        #return plCount
##
##    @property
##    def Item(self, Index):
##        u'Get a module indexed by position or module name'
##        #return ppmod
##
##    def Add(self, Name, Object):
##        u'Add a new module'
##        #return ppmod
##
##    @property
##    def _NewEnum(self):
##        '-no docstring-'
##        #return ppenumContexts
##

class Error(CoClass):
    u'Provides access to scripting error information'
    _reg_clsid_ = GUID('{0E59F1DE-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
Error._com_interfaces_ = [IScriptError]

NoTimeout = -1 # Constant c_int
class IScriptProcedure(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Describes a procedure'
    _iid_ = GUID('{70841C73-067D-11D0-95D8-00A02463AB28}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']
IScriptProcedure._methods_ = [
    COMMETHOD([dispid(0), helpstring(u'Name of the procedure'), 'propget'], HRESULT, 'Name',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrName' )),
    COMMETHOD([dispid(100), helpstring(u'Number of arguments that are expected'), 'propget'], HRESULT, 'NumArgs',
              ( ['retval', 'out'], POINTER(c_int), 'pcArgs' )),
    COMMETHOD([dispid(101), helpstring(u'True if procedure returns a value'), 'propget'], HRESULT, 'HasReturnValue',
              ( ['retval', 'out'], POINTER(VARIANT_BOOL), 'pfHasReturnValue' )),
]
################################################################
## code template for IScriptProcedure implementation
##class IScriptProcedure_Impl(object):
##    @property
##    def NumArgs(self):
##        u'Number of arguments that are expected'
##        #return pcArgs
##
##    @property
##    def HasReturnValue(self):
##        u'True if procedure returns a value'
##        #return pfHasReturnValue
##
##    @property
##    def Name(self):
##        u'Name of the procedure'
##        #return pbstrName
##

class IScriptControl(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Control to host scripting engines that understand the ActiveX Scripting interface'
    _iid_ = GUID('{0E59F1D3-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']

# values for enumeration 'ScriptControlStates'
Initialized = 0
Connected = 1
ScriptControlStates = c_int # enum
class IScriptProcedureCollection(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    u'Collection of procedures'
    _iid_ = GUID('{70841C71-067D-11D0-95D8-00A02463AB28}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'hidden']
IScriptControl._methods_ = [
    COMMETHOD([dispid(1500), helpstring(u'Language engine to use'), 'propget'], HRESULT, 'Language',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrLanguage' )),
    COMMETHOD([dispid(1500), helpstring(u'Language engine to use'), 'propput'], HRESULT, 'Language',
              ( ['in'], BSTR, 'pbstrLanguage' )),
    COMMETHOD([dispid(1501), helpstring(u'State of the control'), 'nonbrowsable', 'propget'], HRESULT, 'State',
              ( ['retval', 'out'], POINTER(ScriptControlStates), 'pssState' )),
    COMMETHOD([dispid(1501), helpstring(u'State of the control'), 'nonbrowsable', 'propput'], HRESULT, 'State',
              ( ['in'], ScriptControlStates, 'pssState' )),
    COMMETHOD([dispid(1502), helpstring(u'hWnd used as a parent for displaying UI'), 'nonbrowsable', 'propput'], HRESULT, 'SitehWnd',
              ( ['in'], c_int, 'phwnd' )),
    COMMETHOD([dispid(1502), helpstring(u'hWnd used as a parent for displaying UI'), 'nonbrowsable', 'propget'], HRESULT, 'SitehWnd',
              ( ['retval', 'out'], POINTER(c_int), 'phwnd' )),
    COMMETHOD([dispid(1503), helpstring(u'Length of time in milliseconds that a script can execute before being considered hung'), 'propget'], HRESULT, 'Timeout',
              ( ['retval', 'out'], POINTER(c_int), 'plMilleseconds' )),
    COMMETHOD([dispid(1503), helpstring(u'Length of time in milliseconds that a script can execute before being considered hung'), 'propput'], HRESULT, 'Timeout',
              ( ['in'], c_int, 'plMilleseconds' )),
    COMMETHOD([dispid(1504), helpstring(u'Enable or disable display of the UI'), 'propget'], HRESULT, 'AllowUI',
              ( ['retval', 'out'], POINTER(VARIANT_BOOL), 'pfAllowUI' )),
    COMMETHOD([dispid(1504), helpstring(u'Enable or disable display of the UI'), 'propput'], HRESULT, 'AllowUI',
              ( ['in'], VARIANT_BOOL, 'pfAllowUI' )),
    COMMETHOD([dispid(1505), helpstring(u'Force script to execute in safe mode and disallow potentially harmful actions'), 'propget'], HRESULT, 'UseSafeSubset',
              ( ['retval', 'out'], POINTER(VARIANT_BOOL), 'pfUseSafeSubset' )),
    COMMETHOD([dispid(1505), helpstring(u'Force script to execute in safe mode and disallow potentially harmful actions'), 'propput'], HRESULT, 'UseSafeSubset',
              ( ['in'], VARIANT_BOOL, 'pfUseSafeSubset' )),
    COMMETHOD([dispid(1506), helpstring(u'Collection of modules for the ScriptControl'), 'nonbrowsable', 'propget'], HRESULT, 'Modules',
              ( ['retval', 'out'], POINTER(POINTER(IScriptModuleCollection)), 'ppmods' )),
    COMMETHOD([dispid(1507), helpstring(u'The last error reported by the scripting engine'), 'nonbrowsable', 'propget'], HRESULT, 'Error',
              ( ['retval', 'out'], POINTER(POINTER(IScriptError)), 'ppse' )),
    COMMETHOD([dispid(1000), helpstring(u'Object exposed by the scripting engine that contains methods and properties defined in the code added to the global module'), 'propget'], HRESULT, 'CodeObject',
              ( ['retval', 'out'], POINTER(POINTER(IDispatch)), 'ppdispObject' )),
    COMMETHOD([dispid(1001), helpstring(u'Collection of procedures that are defined in the global module'), 'propget'], HRESULT, 'Procedures',
              ( ['retval', 'out'], POINTER(POINTER(IScriptProcedureCollection)), 'ppdispProcedures' )),
    COMMETHOD([dispid(-552), 'hidden'], HRESULT, '_AboutBox'),
    COMMETHOD([dispid(2500), helpstring(u'Add an object to the global namespace of the scripting engine')], HRESULT, 'AddObject',
              ( ['in'], BSTR, 'Name' ),
              ( ['in'], POINTER(IDispatch), 'Object' ),
              ( ['in', 'optional'], VARIANT_BOOL, 'AddMembers', False )),
    COMMETHOD([dispid(2501), helpstring(u'Reset the scripting engine to a newly created state')], HRESULT, 'Reset'),
    COMMETHOD([dispid(2000), helpstring(u'Add code to the global module')], HRESULT, 'AddCode',
              ( ['in'], BSTR, 'Code' )),
    COMMETHOD([dispid(2001), helpstring(u'Evaluate an expression within the context of the global module')], HRESULT, 'Eval',
              ( ['in'], BSTR, 'Expression' ),
              ( ['retval', 'out'], POINTER(VARIANT), 'pvarResult' )),
    COMMETHOD([dispid(2002), helpstring(u'Execute a statement within the context of the global module')], HRESULT, 'ExecuteStatement',
              ( ['in'], BSTR, 'Statement' )),
    COMMETHOD([dispid(2003), helpstring(u'Call a procedure defined in the global module')], HRESULT, 'Run',
              ( ['in'], BSTR, 'ProcedureName' ),
              ( ['in'], POINTER(_midlSAFEARRAY(VARIANT)), 'Parameters' ),
              ( ['retval', 'out'], POINTER(VARIANT), 'pvarResult' )),
]
################################################################
## code template for IScriptControl implementation
##class IScriptControl_Impl(object):
##    def _get(self):
##        u'hWnd used as a parent for displaying UI'
##        #return phwnd
##    def _set(self, phwnd):
##        u'hWnd used as a parent for displaying UI'
##    SitehWnd = property(_get, _set, doc = _set.__doc__)
##
##    def AddObject(self, Name, Object, AddMembers):
##        u'Add an object to the global namespace of the scripting engine'
##        #return 
##
##    def Reset(self):
##        u'Reset the scripting engine to a newly created state'
##        #return 
##
##    def Run(self, ProcedureName, Parameters):
##        u'Call a procedure defined in the global module'
##        #return pvarResult
##
##    def Eval(self, Expression):
##        u'Evaluate an expression within the context of the global module'
##        #return pvarResult
##
##    def _get(self):
##        u'Language engine to use'
##        #return pbstrLanguage
##    def _set(self, pbstrLanguage):
##        u'Language engine to use'
##    Language = property(_get, _set, doc = _set.__doc__)
##
##    def AddCode(self, Code):
##        u'Add code to the global module'
##        #return 
##
##    def _get(self):
##        u'Enable or disable display of the UI'
##        #return pfAllowUI
##    def _set(self, pfAllowUI):
##        u'Enable or disable display of the UI'
##    AllowUI = property(_get, _set, doc = _set.__doc__)
##
##    @property
##    def Modules(self):
##        u'Collection of modules for the ScriptControl'
##        #return ppmods
##
##    def ExecuteStatement(self, Statement):
##        u'Execute a statement within the context of the global module'
##        #return 
##
##    def _get(self):
##        u'Force script to execute in safe mode and disallow potentially harmful actions'
##        #return pfUseSafeSubset
##    def _set(self, pfUseSafeSubset):
##        u'Force script to execute in safe mode and disallow potentially harmful actions'
##    UseSafeSubset = property(_get, _set, doc = _set.__doc__)
##
##    def _get(self):
##        u'State of the control'
##        #return pssState
##    def _set(self, pssState):
##        u'State of the control'
##    State = property(_get, _set, doc = _set.__doc__)
##
##    @property
##    def CodeObject(self):
##        u'Object exposed by the scripting engine that contains methods and properties defined in the code added to the global module'
##        #return ppdispObject
##
##    def _get(self):
##        u'Length of time in milliseconds that a script can execute before being considered hung'
##        #return plMilleseconds
##    def _set(self, plMilleseconds):
##        u'Length of time in milliseconds that a script can execute before being considered hung'
##    Timeout = property(_get, _set, doc = _set.__doc__)
##
##    @property
##    def Error(self):
##        u'The last error reported by the scripting engine'
##        #return ppse
##
##    def _AboutBox(self):
##        '-no docstring-'
##        #return 
##
##    @property
##    def Procedures(self):
##        u'Collection of procedures that are defined in the global module'
##        #return ppdispProcedures
##

class DScriptControlSource(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    _case_insensitive_ = True
    _iid_ = GUID('{8B167D60-8605-11D0-ABCB-00A0C90FFFC0}')
    _idlflags_ = ['hidden']
    _methods_ = []
DScriptControlSource._disp_methods_ = [
    DISPMETHOD([dispid(3000), helpstring(u'Event fired when any error occurs in the scripting engine')], None, 'Error'),
    DISPMETHOD([dispid(3001), helpstring(u'Event fired when a script is aborted because of a timeout')], None, 'Timeout'),
]
class ScriptControl(CoClass):
    u'Control to host scripting engines that understand the ActiveX Scripting interface'
    _reg_clsid_ = GUID('{0E59F1D5-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['control']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
ScriptControl._com_interfaces_ = [IScriptControl]
ScriptControl._outgoing_interfaces_ = [DScriptControlSource]

GlobalModule = u'Global' # Constant STRING
class Library(object):
    u'Microsoft Script Control 1.0'
    name = u'MSScriptControl'
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)

class Procedure(CoClass):
    u'Describes a procedure'
    _reg_clsid_ = GUID('{0E59F1DA-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
Procedure._com_interfaces_ = [IScriptProcedure]

class Modules(CoClass):
    u'Collection of modules'
    _reg_clsid_ = GUID('{0E59F1DD-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
Modules._com_interfaces_ = [IScriptModuleCollection]

class Procedures(CoClass):
    u'Collection of procedures'
    _reg_clsid_ = GUID('{0E59F1DB-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
Procedures._com_interfaces_ = [IScriptProcedureCollection]

IScriptProcedureCollection._methods_ = [
    COMMETHOD([dispid(-4), 'hidden', 'propget'], HRESULT, '_NewEnum',
              ( ['retval', 'out'], POINTER(POINTER(IUnknown)), 'ppenumProcedures' )),
    COMMETHOD([dispid(0), helpstring(u'Get a procedure indexed by position or procedure name'), 'propget'], HRESULT, 'Item',
              ( ['in'], VARIANT, 'Index' ),
              ( ['retval', 'out'], POINTER(POINTER(IScriptProcedure)), 'ppdispProcedure' )),
    COMMETHOD([dispid(1), helpstring(u'Number of procedures'), 'propget'], HRESULT, 'Count',
              ( ['retval', 'out'], POINTER(c_int), 'plCount' )),
]
################################################################
## code template for IScriptProcedureCollection implementation
##class IScriptProcedureCollection_Impl(object):
##    @property
##    def Count(self):
##        u'Number of procedures'
##        #return plCount
##
##    @property
##    def Item(self, Index):
##        u'Get a procedure indexed by position or procedure name'
##        #return ppdispProcedure
##
##    @property
##    def _NewEnum(self):
##        '-no docstring-'
##        #return ppenumProcedures
##

IScriptModule._methods_ = [
    COMMETHOD([dispid(0), helpstring(u'Name of the module'), 'propget'], HRESULT, 'Name',
              ( ['retval', 'out'], POINTER(BSTR), 'pbstrName' )),
    COMMETHOD([dispid(1000), helpstring(u'Object exposed by the scripting engine that contains methods and properties defined in the code added to the module'), 'propget'], HRESULT, 'CodeObject',
              ( ['retval', 'out'], POINTER(POINTER(IDispatch)), 'ppdispObject' )),
    COMMETHOD([dispid(1001), helpstring(u'Collection of procedures that are defined in the module'), 'propget'], HRESULT, 'Procedures',
              ( ['retval', 'out'], POINTER(POINTER(IScriptProcedureCollection)), 'ppdispProcedures' )),
    COMMETHOD([dispid(2000), helpstring(u'Add code to the module')], HRESULT, 'AddCode',
              ( ['in'], BSTR, 'Code' )),
    COMMETHOD([dispid(2001), helpstring(u'Evaluate an expression within the context of the module')], HRESULT, 'Eval',
              ( ['in'], BSTR, 'Expression' ),
              ( ['retval', 'out'], POINTER(VARIANT), 'pvarResult' )),
    COMMETHOD([dispid(2002), helpstring(u'Execute a statement within the context of the module')], HRESULT, 'ExecuteStatement',
              ( ['in'], BSTR, 'Statement' )),
    COMMETHOD([dispid(2003), helpstring(u'Call a procedure defined in the module')], HRESULT, 'Run',
              ( ['in'], BSTR, 'ProcedureName' ),
              ( ['in'], POINTER(_midlSAFEARRAY(VARIANT)), 'Parameters' ),
              ( ['retval', 'out'], POINTER(VARIANT), 'pvarResult' )),
]
################################################################
## code template for IScriptModule implementation
##class IScriptModule_Impl(object):
##    def Run(self, ProcedureName, Parameters):
##        u'Call a procedure defined in the module'
##        #return pvarResult
##
##    @property
##    def Name(self):
##        u'Name of the module'
##        #return pbstrName
##
##    @property
##    def Procedures(self):
##        u'Collection of procedures that are defined in the module'
##        #return ppdispProcedures
##
##    @property
##    def CodeObject(self):
##        u'Object exposed by the scripting engine that contains methods and properties defined in the code added to the module'
##        #return ppdispObject
##
##    def Eval(self, Expression):
##        u'Evaluate an expression within the context of the module'
##        #return pvarResult
##
##    def AddCode(self, Code):
##        u'Add code to the module'
##        #return 
##
##    def ExecuteStatement(self, Statement):
##        u'Execute a statement within the context of the module'
##        #return 
##

class Module(CoClass):
    u'Context in which functions can be defined and expressions can be evaluated'
    _reg_clsid_ = GUID('{0E59F1DC-1FBE-11D0-8FF2-00A0D10038BC}')
    _idlflags_ = ['noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}', 1, 0)
Module._com_interfaces_ = [IScriptModule]

__all__ = [ 'ScriptControl', 'IScriptError', 'DScriptControlSource',
           'ScriptControlStates', 'IScriptControl',
           'IScriptModuleCollection', 'Modules',
           'IScriptProcedureCollection', 'Module', 'NoTimeout',
           'IScriptModule', 'Connected', 'Error', 'Initialized',
           'IScriptProcedure', 'Procedures', 'GlobalModule',
           'Procedure']
from comtypes import _check_version; _check_version('')
