/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileTopDown;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GtileAssembly
extends GtileTopDown {
    private final TextBlock textBlock;

    public GtileAssembly(Gtile tile1, Gtile tile2, LinkRendering linkRendering) {
        super(tile1, tile2);
        this.textBlock = this.getTextBlock(linkRendering.getDisplay());
    }

    @Override
    protected UTranslate supplementaryMove() {
        double height = 30.0 + this.textBlock.calculateDimension(this.stringBounder).getHeight();
        return new UTranslate(0.0, height);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    protected final TextBlock getTextBlock(Display display) {
        FontConfiguration fontConfiguration;
        if (Display.isNull(display)) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            fontConfiguration = style.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        } else {
            fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        }
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        GConnectionVerticalDown arrow = new GConnectionVerticalDown(this.getPos1(), this.tile1.getGPoint("SOUTH_HOOK"), this.getPos2(), this.tile2.getGPoint("NORTH_HOOK"), this.textBlock);
        return Collections.singletonList(arrow);
    }
}

