/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.ComplementInColors2;
import net.sourceforge.plantuml.project.lang.ComplementOpen;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SubjectDayAsDate
implements Subject {
    public Failable<Day> getMe(GanttDiagram project, RegexResult arg) {
        if (arg.get("BDAY", 0) != null) {
            return Failable.ok(this.resultB(arg));
        }
        if (arg.get("ECOUNT", 0) != null) {
            return Failable.ok(this.resultE(project, arg));
        }
        throw new IllegalStateException();
    }

    private Day resultB(RegexResult arg) {
        int day = Integer.parseInt(arg.get("BDAY", 0));
        int month = Integer.parseInt(arg.get("BMONTH", 0));
        int year = Integer.parseInt(arg.get("BYEAR", 0));
        return Day.create(year, month, day);
    }

    private Day resultE(GanttDiagram system, RegexResult arg) {
        int day = Integer.parseInt(arg.get("ECOUNT", 0));
        return system.getStartingDate().addDays(day);
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new Close(), new Open(), new InColor());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(this.toRegexB(), this.toRegexE());
    }

    private IRegex toRegexB() {
        return new RegexConcat(new RegexLeaf("BYEAR", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY", "([\\d]{1,2})"));
    }

    private IRegex toRegexE() {
        return new RegexConcat(new RegexLeaf("[dD]\\+"), new RegexLeaf("ECOUNT", "([\\d]+)"));
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            project.colorDay((Day)subject, color);
            return CommandExecutionResult.ok();
        }
    }

    class Open
    extends SentenceSimple {
        public Open() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.openDayAsDate((Day)subject);
            return CommandExecutionResult.ok();
        }
    }

    class Close
    extends SentenceSimple {
        public Close() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.closeDayAsDate((Day)subject);
            return CommandExecutionResult.ok();
        }
    }
}

