/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import h.ST_textlabel_t;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.sdot.YMirror;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import smetana.core.Macro;

public class SmetanaPath
implements UDrawable {
    private final Link link;
    private final ST_Agedge_s edge;
    private final YMirror ymirror;
    private final CucaDiagram diagram;
    private final TextBlock label;
    private final TextBlock headLabel;
    private final TextBlock tailLabel;
    private final Rose rose = new Rose();

    public SmetanaPath(Link link, ST_Agedge_s edge, YMirror ymirror, CucaDiagram diagram, TextBlock label, TextBlock tailLabel, TextBlock headLabel) {
        this.link = link;
        this.edge = edge;
        this.ymirror = ymirror;
        this.diagram = diagram;
        this.label = label;
        this.tailLabel = tailLabel;
        this.headLabel = headLabel;
    }

    private ColorParam getArrowColorParam() {
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.arrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.arrow;
        }
        throw new IllegalStateException();
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.link.isHidden()) {
            return;
        }
        HColor color = UseStyle.useBetaStyle() ? StyleSignature.of(SName.root, SName.element, this.diagram.getUmlDiagramType().getStyleName(), SName.arrow).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder()).value(PName.LineColor).asColor(this.diagram.getSkinParam().getThemeStyle(), this.diagram.getSkinParam().getIHtmlColorSet()) : this.rose.getHtmlColor(this.diagram.getSkinParam(), null, this.getArrowColorParam());
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            color = this.link.getSpecificColor();
        }
        DotPath dotPath = this.getDotPath(this.edge);
        if (this.ymirror != null && dotPath != null) {
            dotPath = this.ymirror.getMirrored(dotPath);
        }
        if (dotPath != null) {
            LinkType linkType = this.link.getType();
            UStroke stroke = linkType.getStroke3(this.diagram.getSkinParam().getThickness(LineParam.arrow, null));
            if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
                stroke = this.link.getColors().getSpecificLineStroke();
            }
            ug.apply(stroke).apply(color).draw(dotPath);
            this.printExtremityAtStart(ug.apply(color));
            this.printExtremityAtEnd(ug.apply(color));
        }
        if (this.getLabelRectangleTranslate("label") != null) {
            this.label.drawU(ug.apply(this.getLabelRectangleTranslate("label")));
        }
        if (this.getLabelRectangleTranslate("head_label") != null) {
            this.headLabel.drawU(ug.apply(this.getLabelRectangleTranslate("head_label")));
        }
        if (this.getLabelRectangleTranslate("tail_label") != null) {
            this.tailLabel.drawU(ug.apply(this.getLabelRectangleTranslate("tail_label")));
        }
    }

    private void printExtremityAtStart(UGraphic ug) {
        ExtremityFactory extremityFactory2 = this.link.getType().getDecor2().getExtremityFactoryComplete(this.diagram.getSkinParam().getBackgroundColor());
        if (extremityFactory2 == null) {
            return;
        }
        ST_splines splines = this.getSplines(this.edge);
        DotPath s = this.getDotPath(splines);
        Point2D p0 = s.getStartPoint();
        double startAngle = s.getStartAngle();
        if (this.ymirror != null) {
            p0 = this.ymirror.getMirrored(p0);
            startAngle = -startAngle + Math.PI;
        }
        try {
            UDrawable extremity2 = extremityFactory2.createUDrawable(p0, startAngle, null);
            if (extremity2 != null) {
                extremity2.drawU(ug);
            }
        }
        catch (UnsupportedOperationException e) {
            System.err.println("CANNOT DRAW printExtremityAtStart");
        }
    }

    private void printExtremityAtEnd(UGraphic ug) {
        ExtremityFactory extremityFactory1 = this.link.getType().getDecor1().getExtremityFactoryComplete(this.diagram.getSkinParam().getBackgroundColor());
        if (extremityFactory1 == null) {
            return;
        }
        ST_splines splines = this.getSplines(this.edge);
        DotPath s = this.getDotPath(splines);
        Point2D p0 = s.getEndPoint();
        double endAngle = s.getEndAngle();
        if (this.ymirror != null) {
            p0 = this.ymirror.getMirrored(p0);
            endAngle = -endAngle;
        }
        try {
            UDrawable extremity1 = extremityFactory1.createUDrawable(p0, endAngle, null);
            if (extremity1 != null) {
                extremity1.drawU(ug);
            }
        }
        catch (UnsupportedOperationException e) {
            System.err.println("CANNOT DRAW printExtremityAtEnd");
        }
    }

    private void printDebug(UGraphic ug) {
        ug = ug.apply(HColorUtils.BLUE).apply(HColorUtils.BLUE.bg());
        ST_splines splines = this.getSplines(this.edge);
        ST_bezier beziers = splines.list.get__(0);
        for (int i = 0; i < beziers.size; ++i) {
            Point2D pt = this.getPoint(splines, i);
            if (this.ymirror != null) {
                pt = this.ymirror.getMirrored(pt);
            }
            ug.apply(new UTranslate(pt).compose(new UTranslate(-1.0, -1.0))).draw(new UEllipse(3.0, 3.0));
        }
        if (this.getLabelRectangleTranslate("label") != null && this.getLabelURectangle() != null) {
            ug = ug.apply(HColorUtils.BLUE).apply(new HColorNone().bg());
            ug.apply(this.getLabelRectangleTranslate("label")).draw(this.getLabelURectangle());
        }
    }

    private URectangle getLabelURectangle() {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(this.edge).castTo(ST_Agedgeinfo_t.class);
        ST_textlabel_t label = data.label;
        if (label == null) {
            return null;
        }
        ST_pointf dimen = label.dimen;
        ST_pointf space = label.space;
        ST_pointf pos = label.pos;
        double x = pos.x;
        double y = pos.y;
        double width = dimen.x;
        double height = dimen.y;
        return new URectangle(width, height);
    }

    private UTranslate getLabelRectangleTranslate(String fieldName) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(this.edge);
        ST_textlabel_t label = null;
        if (fieldName.equals("label")) {
            label = data.label;
        } else if (fieldName.equals("head_label")) {
            label = data.head_label;
        } else if (fieldName.equals("tail_label")) {
            label = data.tail_label;
        }
        if (label == null) {
            return null;
        }
        ST_pointf dimen = label.dimen;
        ST_pointf space = label.space;
        ST_pointf pos = label.pos;
        double x = pos.x;
        double y = pos.y;
        double width = dimen.x;
        double height = dimen.y;
        if (this.ymirror == null) {
            return new UTranslate(x - width / 2.0, y - height / 2.0);
        }
        return this.ymirror.getMirrored(new UTranslate(x - width / 2.0, y + height / 2.0));
    }

    public DotPath getDotPath(ST_Agedge_s e) {
        ST_splines splines = this.getSplines(e);
        return this.getDotPath(splines);
    }

    private ST_splines getSplines(ST_Agedge_s e) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(e);
        ST_splines splines = data.spl;
        return splines;
    }

    private DotPath getDotPath(ST_splines splines) {
        if (splines == null) {
            System.err.println("ERROR, no splines for getDotPath");
            return null;
        }
        DotPath result = new DotPath();
        ST_bezier beziers = splines.list.get__(0);
        Point2D pt1 = this.getPoint(splines, 0);
        Point2D pt2 = this.getPoint(splines, 1);
        Point2D pt3 = this.getPoint(splines, 2);
        Point2D pt4 = this.getPoint(splines, 3);
        result = result.addCurve(pt1, pt2, pt3, pt4);
        int n = beziers.size;
        for (int i = 4; i < n; i += 3) {
            Point2D ppt2 = this.getPoint(splines, i);
            Point2D ppt3 = this.getPoint(splines, i + 1);
            Point2D ppt4 = this.getPoint(splines, i + 2);
            result = result.addCurve(ppt2, ppt3, ppt4);
        }
        return result;
    }

    private Point2D getPoint(ST_splines splines, int i) {
        ST_bezier beziers = splines.list.get__(0);
        ST_pointf pt = beziers.list.get__(i);
        return new Point2D.Double(pt.x, pt.y);
    }
}

