"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createArgsFromOptions = exports.addDefaultsToOptions = void 0;
var path = __importStar(require("path"));
/**
 * Adds default values for missing option properties.
 * @param options The options whos missing properties are extended with default values.
 * @returns The options object in which every property has a value.
 */
function addDefaultsToOptions(options) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    return {
        jarPath: (_a = options.jarPath) !== null && _a !== void 0 ? _a : path.join(__dirname, "../vendor/plantuml.jar"),
        outputFormat: (_b = options.outputFormat) !== null && _b !== void 0 ? _b : "svg",
        delimiter: (_c = options.delimiter) !== null && _c !== void 0 ? _c : "___PLANTUML_DIAGRAM_DELIMITER___",
        split: (_d = options.split) !== null && _d !== void 0 ? _d : true,
        includePath: (_e = options.includePath) !== null && _e !== void 0 ? _e : ".",
        pixelCutOffValue: (_f = options.pixelCutOffValue) !== null && _f !== void 0 ? _f : 0,
        noErrorImages: (_g = options.noErrorImages) !== null && _g !== void 0 ? _g : false,
        javaOptions: (_h = options.javaOptions) !== null && _h !== void 0 ? _h : [],
        plantUmlArgs: (_j = options.plantUmlArgs) !== null && _j !== void 0 ? _j : [],
    };
}
exports.addDefaultsToOptions = addDefaultsToOptions;
/**
 * Creates an array with command line arguments for the PlantUML JAVA process.
 * @param options The options from which the arguments are created.
 * @returns The command line arguments.
 */
function createArgsFromOptions(options) {
    var args = ["-Djava.awt.headless=true", "-Dplantuml.include.path=\"".concat(options.includePath, "\"")];
    if (options.pixelCutOffValue > 0) {
        args.push("-DPLANTUML_LIMIT_SIZE=".concat(options.pixelCutOffValue));
    }
    if (options.javaOptions.length > 0) {
        args = args.concat(options.javaOptions);
    }
    args.push("-jar");
    args.push(options.jarPath);
    args.push("-t" + options.outputFormat);
    args.push("-pipe");
    args.push("-pipedelimitor");
    args.push(options.delimiter);
    if (options.noErrorImages) {
        args.push("-pipeNoStderr");
    }
    if (options.plantUmlArgs.length > 0) {
        args = args.concat(options.plantUmlArgs);
    }
    return args;
}
exports.createArgsFromOptions = createArgsFromOptions;
