/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.bak;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sysolar.codehelper.javaee.bak.Column;
import org.sysolar.codehelper.javaee.bak.Table;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public class OutCode {
    static String outFilePath = "D:/workspace4e/test/bean/";
    private static String regExpCreateTable = "CREATE TABLE (\\w+) \\(([^;]+)\\);";
    private static String regExpCreateColumn = "(\\w+) (\\w+)(\\(\\d+,\\d+\\))*[^,]*,";
    private static String regExpDefaultValue = "DEFAULT (\\w+)";
    private static String regExpColumnComment = "COMMENT '([^']+)'";
    private static String regExpCreateFK = "ALTER TABLE (\\w+)[^;]+ REFERENCES (\\w+) [^;]+;";
    static Map<String, Table> tableMap = new HashMap<String, Table>(50);
    private static Map<String, List<String>> parentMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> childMap = new HashMap<String, List<String>>();

    public static void main(String[] args) {
        String structSqlfilePath = "D:/workspace4e/test/doc/KaixinMobile_struct.sql";
        String src = FileIO.readAsString(structSqlfilePath, "UTF-8");
        src = src.replaceAll("\\s+", " ");
        OutCode.extractTable(src);
        OutCode.extractReference(src);
        for (Table table : tableMap.values()) {
            table.setClassName(NameUtil.getJavaNameBigFirst(table.getTableName()));
            for (Column column : table.getColumnList()) {
                column.setPropertyName(NameUtil.getJavaNameSmallFirst(column.getColumnName()));
                OutCode.makeJavaType(column);
                if (!column.getColumnType().startsWith("DECIMAL")) continue;
                column.setPropertyType("Double");
            }
        }
        List<Column> consList = tableMap.get("SYS_MSG").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_TYPE_FRIEND").setDefaultValue("0").setColumnComment("\u6d88\u606f\u7c7b\u578b\uff1a\u6dfb\u52a0\u597d\u53cb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_TYPE_BIRTH").setDefaultValue("1").setColumnComment("\u6d88\u606f\u7c7b\u578b\uff1a\u751f\u65e5\u63d0\u9192"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_IS_READ_NO").setDefaultValue("0").setColumnComment("\u7528\u6237\u6d88\u606f\u8bfb\u53d6\u7c7b\u578b\uff1a\u672a\u8bfb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_IS_READ_YES").setDefaultValue("1").setColumnComment("\u7528\u6237\u6d88\u606f\u8bfb\u53d6\u7c7b\u578b\uff1a\u5df2\u8bfb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_NOT_DONE").setDefaultValue("0").setColumnComment("\u6d88\u606f\u72b6\u6001\uff1a\u672a\u5904\u7406"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_AGREED").setDefaultValue("1").setColumnComment("\u6d88\u606f\u72b6\u6001\uff1a\u540c\u610f"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_REFUSED").setDefaultValue("2").setColumnComment("\u6d88\u606f\u72b6\u6001\uff1a\u62d2\u7edd"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_IGNORED").setDefaultValue("3").setColumnComment("\u6d88\u606f\u72b6\u6001\uff1a\u5ffd\u7565"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_DELETED").setDefaultValue("4").setColumnComment("\u6d88\u606f\u72b6\u6001\uff1a\u7528\u6237\u5220\u9664"));
        consList = tableMap.get("USER_FILE").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("FILE_STATUS_DELETED_BY_ADMIN").setDefaultValue("-1").setColumnComment("\u6587\u4ef6\u72b6\u6001\uff1a\u88ab\u7ba1\u7406\u5458\u5220\u9664"));
        consList.add(new Column().setPropertyType("int").setPropertyName("FILE_STATUS_DELETED_BY_USER").setDefaultValue("0").setColumnComment("\u6587\u4ef6\u72b6\u6001\uff1a\u88ab\u7528\u6237\u5220\u9664"));
        consList.add(new Column().setPropertyType("int").setPropertyName("FILE_STATUS_OK").setDefaultValue("1").setColumnComment("\u6587\u4ef6\u72b6\u6001\uff1a\u6b63\u5e38"));
        consList.add(new Column().setPropertyType("int").setPropertyName("FILE_STATUS_CHECKING").setDefaultValue("10").setColumnComment("\u6587\u4ef6\u72b6\u6001\uff1a\u5f85\u5ba1\u6838"));
        consList = tableMap.get("ACT_CHECK").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_REG").setDefaultValue("0").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u65b0\u6ce8\u518c"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_UPDATE_USERNAME").setDefaultValue("1").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u4fee\u6539\u59d3\u540d"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_UPDATE_EMAIL").setDefaultValue("2").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u4fee\u6539\u90ae\u7bb1"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_UPDATE_PHONE").setDefaultValue("3").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u4fee\u6539\u624b\u673a\u53f7\u7801"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_STATUS_INVALID").setDefaultValue("0").setColumnComment("\u52a8\u4f5c\u72b6\u6001\uff1a\u65e0\u6548"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_STATUS_OK").setDefaultValue("1").setColumnComment("\u52a8\u4f5c\u72b6\u6001\uff1a\u6709\u6548"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_STATUS_NOT_CHECK").setDefaultValue("10").setColumnComment("\u52a8\u4f5c\u72b6\u6001\uff1a\u624b\u673a\u6ce8\u518c\u540e\u8fd8\u672a\u9a8c\u8bc1"));
        consList = tableMap.get("USER_ACT").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_UPDATE_PHOTO").setDefaultValue("0").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u4fee\u6539\u5934\u50cf"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_ADD_FRIEND").setDefaultValue("1").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u6dfb\u52a0\u597d\u53cb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_WRITE_BLOG").setDefaultValue("2").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u53d1\u8868\u65e5\u5fd7"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_UPLOAD_PHOTO").setDefaultValue("3").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u4e0a\u4f20\u7167\u7247"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_DO_POST").setDefaultValue("4").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u53d1\u8868\u8bc4\u8bba"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_DO_REPLY").setDefaultValue("5").setColumnComment("\u52a8\u4f5c\u7c7b\u578b\uff1a\u56de\u590d\u8bc4\u8bba"));
        consList = tableMap.get("USER_FRIEND").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("FOCUSED_TYPE_BLOCK").setDefaultValue("0").setColumnComment("\u5173\u6ce8\u7c7b\u578b\uff1a\u5c4f\u853d"));
        consList.add(new Column().setPropertyType("int").setPropertyName("FOCUSED_TYPE_NORMAL").setDefaultValue("1").setColumnComment("\u5173\u6ce8\u7c7b\u578b\uff1a\u6b63\u5e38\u5173\u6ce8"));
        consList.add(new Column().setPropertyType("int").setPropertyName("FOCUSED_TYPE_SPECIAL").setDefaultValue("2").setColumnComment("\u5173\u6ce8\u7c7b\u578b\uff1a\u7279\u522b\u5173\u6ce8"));
        consList = tableMap.get("FARM_TOOL").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("TOOL_TYPE_COMMON_FERTILIZER").setDefaultValue("0").setColumnComment("\u9053\u5177\u7c7b\u578b\uff1a\u666e\u901a\u5316\u80a5"));
        consList.add(new Column().setPropertyType("int").setPropertyName("TOOL_TYPE_HIGH_FERTILIZER").setDefaultValue("1").setColumnComment("\u9053\u5177\u7c7b\u578b\uff1a\u9ad8\u901f\u5316\u80a5"));
        consList.add(new Column().setPropertyType("int").setPropertyName("TOOL_TYPE_HARVEST_AUNT").setDefaultValue("2").setColumnComment("\u9053\u5177\u7c7b\u578b\uff1a\u6536\u83dc\u963f\u59e8"));
        consList.add(new Column().setPropertyType("int").setPropertyName("TOOL_TYPE_CLOAK").setDefaultValue("3").setColumnComment("\u9053\u5177\u7c7b\u578b\uff1a\u9690\u8eab\u8863"));
        consList = tableMap.get("STANDARD_ATTRIBUTE").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_UNKNOWN").setDefaultValue("0").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u672a\u786e\u5b9a"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_CONTACT_NAME").setDefaultValue("1").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u8054\u7cfb\u4eba\u59d3\u540d"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_MOBILE_PHONE").setDefaultValue("2").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u79fb\u52a8\u7535\u8bdd"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_TELEPHONE").setDefaultValue("3").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u56fa\u5b9a\u7535\u8bdd"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_FAX").setDefaultValue("4").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u4f20\u771f"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_GROUP").setDefaultValue("5").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u7fa4\u7ec4"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_QQ").setDefaultValue("6").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1aQQ"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_MSN").setDefaultValue("7").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1aMSN"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_EMAIL").setDefaultValue("8").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u90ae\u7bb1"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_ADDRESS").setDefaultValue("9").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u5730\u5740"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_BIRTHDAY").setDefaultValue("10").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u751f\u65e5"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ATTRIBUTE_TYPE_URL").setDefaultValue("11").setColumnComment("\u5c5e\u6027\u7c7b\u578b\uff1a\u7f51\u5740"));
        consList = tableMap.get("WALL_PAPER").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("PAPER_STATUS_CLOSED").setDefaultValue("0").setColumnComment("\u58c1\u7eb8\u72b6\u6001\uff1a\u88ab\u5173\u95ed"));
        consList.add(new Column().setPropertyType("int").setPropertyName("PAPER_STATUS_OK").setDefaultValue("1").setColumnComment("\u58c1\u7eb8\u72b6\u6001\uff1a\u6b63\u5e38"));
        consList.add(new Column().setPropertyType("int").setPropertyName("PAPER_STATUS_RECOMMEND").setDefaultValue("2").setColumnComment("\u58c1\u7eb8\u72b6\u6001\uff1a\u88ab\u63a8\u8350"));
        consList.add(new Column().setPropertyType("int").setPropertyName("PAPER_STATUS_NOT_CHECK").setDefaultValue("10").setColumnComment("\u58c1\u7eb8\u72b6\u6001\uff1a\u672a\u5ba1\u6838"));
        consList.add(new Column().setPropertyType("int").setPropertyName("PAPER_STATUS_NOT_PASS").setDefaultValue("11").setColumnComment("\u58c1\u7eb8\u72b6\u6001\uff1a\u672a\u901a\u8fc7\u5ba1\u6838"));
        consList = tableMap.get("THEME").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("THEME_STATUS_CLOSED").setDefaultValue("0").setColumnComment("\u4e3b\u9898\u72b6\u6001\uff1a\u88ab\u5173\u95ed"));
        consList.add(new Column().setPropertyType("int").setPropertyName("THEME_STATUS_OK").setDefaultValue("1").setColumnComment("\u4e3b\u9898\u72b6\u6001\uff1a\u6b63\u5e38"));
        consList.add(new Column().setPropertyType("int").setPropertyName("THEME_STATUS_RECOMMEND").setDefaultValue("2").setColumnComment("\u4e3b\u9898\u72b6\u6001\uff1a\u88ab\u63a8\u8350"));
        consList.add(new Column().setPropertyType("int").setPropertyName("THEME_STATUS_NOT_CHECK").setDefaultValue("10").setColumnComment("\u4e3b\u9898\u72b6\u6001\uff1a\u672a\u5ba1\u6838"));
        consList.add(new Column().setPropertyType("int").setPropertyName("THEME_STATUS_NOT_PASS").setDefaultValue("11").setColumnComment("\u4e3b\u9898\u72b6\u6001\uff1a\u672a\u901a\u8fc7\u5ba1\u6838"));
        consList = tableMap.get("APP").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("APP_STATUS_CLOSED").setDefaultValue("0").setColumnComment("\u7a0b\u5e8f\u72b6\u6001\uff1a\u88ab\u5173\u95ed"));
        consList.add(new Column().setPropertyType("int").setPropertyName("APP_STATUS_OK").setDefaultValue("1").setColumnComment("\u7a0b\u5e8f\u72b6\u6001\uff1a\u6b63\u5e38"));
        consList.add(new Column().setPropertyType("int").setPropertyName("APP_STATUS_RECOMMEND").setDefaultValue("2").setColumnComment("\u7a0b\u5e8f\u72b6\u6001\uff1a\u88ab\u63a8\u8350"));
        consList.add(new Column().setPropertyType("int").setPropertyName("APP_STATUS_NOT_CHECK").setDefaultValue("10").setColumnComment("\u7a0b\u5e8f\u72b6\u6001\uff1a\u672a\u5ba1\u6838"));
        consList.add(new Column().setPropertyType("int").setPropertyName("APP_STATUS_NOT_PASS").setDefaultValue("11").setColumnComment("\u7a0b\u5e8f\u72b6\u6001\uff1a\u672a\u901a\u8fc7\u5ba1\u6838"));
        consList = tableMap.get("SORT").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("DATA_TYPE_WALL_PAPER").setDefaultValue("1").setColumnComment("\u6570\u636e\u7c7b\u578b\uff1a\u88ab\u5173\u95ed"));
        consList.add(new Column().setPropertyType("int").setPropertyName("DATA_TYPE_THEME").setDefaultValue("2").setColumnComment("\u6570\u636e\u7c7b\u578b\uff1a\u6b63\u5e38"));
        consList.add(new Column().setPropertyType("int").setPropertyName("DATA_TYPE_APP").setDefaultValue("3").setColumnComment("\u6570\u636e\u7c7b\u578b\uff1a\u88ab\u63a8\u8350"));
        consList = tableMap.get("KAIXIN_USER").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("USER_IS_ACTIVE_NO").setDefaultValue("0").setColumnComment("\u662f\u5426\u6fc0\u6d3b\uff1a\u672a\u6fc0\u6d3b"));
        consList.add(new Column().setPropertyType("int").setPropertyName("USER_IS_ACTIVE_YES").setDefaultValue("1").setColumnComment("\u662f\u5426\u6fc0\u6d3b\uff1a\u5df2\u6fc0\u6d3b"));
        consList.add(new Column().setPropertyType("int").setPropertyName("USER_IS_ACTIVE_INVALID").setDefaultValue("10").setColumnComment("\u662f\u5426\u6fc0\u6d3b\uff1a\u8bb0\u5f55\u5df2\u65e0\u6548"));
        consList = tableMap.get("SLAVE_NEWS").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_BUY_SLAVE").setDefaultValue("1").setColumnComment("\u8d2d\u4e70\u5974\u96b6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_SALE_SLAVE").setDefaultValue("2").setColumnComment("\u51fa\u552e\u5974\u96b6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_APPEASE_SLAVE").setDefaultValue("3").setColumnComment("\u5b89\u629a\u5974\u96b6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_TRICK_SLAVE").setDefaultValue("4").setColumnComment("\u6574\u5974\u96b6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_RELEASE_SLAVE").setDefaultValue("5").setColumnComment("\u91ca\u653e\u5974\u96b6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_RANSOM_SELF").setDefaultValue("6").setColumnComment("\u8d4e\u8eab"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_KISS_OWNER").setDefaultValue("7").setColumnComment("\u8ba8\u597d\u4e3b\u4eba"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_REGISTER").setDefaultValue("8").setColumnComment("\u6ce8\u518c"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_LOGIN").setDefaultValue("10").setColumnComment("\u767b\u9646"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_ACCIDENT").setDefaultValue("11").setColumnComment("\u610f\u5916\u4e8b\u4ef6"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_BE_BUY").setDefaultValue("12").setColumnComment("\u88ab\u8d2d\u4e70"));
        consList.add(new Column().setPropertyType("int").setPropertyName("ACT_TYPE_SLAVE_PK").setDefaultValue("20").setColumnComment("\u5974\u96b6PK"));
        consList = tableMap.get("PET_USER_JEWELRY").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("USED_STATUS_NO").setDefaultValue("0").setColumnComment("\u672a\u4f7f\u7528"));
        consList.add(new Column().setPropertyType("int").setPropertyName("USED_STATUS_IN").setDefaultValue("1").setColumnComment("\u6b63\u5728\u4f7f\u7528"));
        consList = tableMap.get("PET_JEWELRY").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("JEWELRY_TYPE_BACKGROUND").setDefaultValue("0").setColumnComment("\u80cc\u666f"));
        consList.add(new Column().setPropertyType("int").setPropertyName("JEWELRY_TYPE_HOUSE").setDefaultValue("1").setColumnComment("\u5c0f\u7a9d"));
        consList.add(new Column().setPropertyType("int").setPropertyName("JEWELRY_TYPE_MAT").setDefaultValue("2").setColumnComment("\u57ab\u5b50"));
        consList = tableMap.get("USER_MSG").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_TYPE_SEND").setDefaultValue("0").setColumnComment("\u53d1\u9001"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_TYPE_RECEIVE").setDefaultValue("1").setColumnComment("\u63a5\u6536"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_NOT_READ").setDefaultValue("0").setColumnComment("\u672a\u8bfb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_READ").setDefaultValue("1").setColumnComment("\u5df2\u8bfb"));
        consList.add(new Column().setPropertyType("int").setPropertyName("MSG_STATUS_REMOVED").setDefaultValue("-1").setColumnComment("\u7528\u6237\u5220\u9664"));
        List<Column> colList = tableMap.get("KAIXIN_USER").getColumnList();
        colList.add(new Column().setPropertyType("Integer").setPropertyName("userLiveStatus").setColumnComment("\u7528\u6237\u5f53\u524d\u6240\u5728\u7684\u5e94\u7528").setKeyType(20));
        colList.add(new Column().setPropertyType("Map<String, Object>").setPropertyName("gameInfo").setColumnComment("\u6e38\u620f\u4fe1\u606f").setKeyType(20));
        colList.add(new Column().setPropertyType("Integer").setPropertyName("cnt").setColumnComment("\u7edf\u8ba1\u4fe1\u606f").setKeyType(20));
        colList = tableMap.get("VISITOR").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("USER_FRIEND").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("USER_PHOTO").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("USER_BLOG").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("USER_FILE").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("USER_SLAVE").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("SYS_MSG").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("FARM_USER_LAND").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(10));
        colList = tableMap.get("APP").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(20));
        colList.add(new Column().setPropertyType("String").setPropertyName("fee").setKeyType(20).setColumnComment("\u8ba1\u8d39\u4fe1\u606f"));
        colList = tableMap.get("APP_GRADE").getColumnList();
        colList.add(new Column().setPropertyType("Integer").setPropertyName("gradeTimes").setKeyType(20));
        colList = tableMap.get("WALL_PAPER").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(20));
        colList.add(new Column().setPropertyType("String").setPropertyName("fee").setKeyType(20).setColumnComment("\u8ba1\u8d39\u4fe1\u606f"));
        colList = tableMap.get("THEME").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("kaixinUser").setKeyType(20));
        colList.add(new Column().setPropertyType("String").setPropertyName("fee").setKeyType(20).setColumnComment("\u8ba1\u8d39\u4fe1\u606f"));
        colList = tableMap.get("FARM_ANNOUNCE").getColumnList();
        colList.add(new Column().setPropertyType("String").setPropertyName("startDate").setKeyType(20));
        colList.add(new Column().setPropertyType("String").setPropertyName("invalidDate").setKeyType(20));
        colList = tableMap.get("SORT").getColumnList();
        colList.add(new Column().setPropertyType("Integer").setPropertyName("cnt").setKeyType(20).setColumnComment("\u5206\u7c7b\u4e0b\u5305\u542b\u4e2a\u4f53\u6570\u91cf"));
        colList.add(new Column().setPropertyType("Integer").setPropertyName("downCnt").setKeyType(20).setColumnComment("\u5206\u7c7b\u4e0b\u5305\u542b\u4e2a\u4f53\u88ab\u4e0b\u8f7d\u7684\u6b21\u6570"));
        colList.add(new Column().setPropertyType("String").setPropertyName("fee").setKeyType(20).setColumnComment("\u8ba1\u8d39\u4fe1\u606f"));
        colList = tableMap.get("SLAVE_OWNER").getColumnList();
        colList.add(new Column().setPropertyType("Integer").setPropertyName("ownerMoney").setKeyType(20).setColumnComment("\u7528\u6237\u91d1\u94b1"));
        colList.add(new Column().setPropertyType("Integer").setPropertyName("ownerPrice").setKeyType(20).setColumnComment("\u7528\u6237\u8eab\u4ef7"));
        colList.add(new Column().setPropertyType("Integer").setPropertyName("ownerExp").setKeyType(20).setColumnComment("\u7528\u6237\u7ecf\u9a8c\u503c"));
        colList = tableMap.get("FARM_USER").getColumnList();
        colList.add(new Column().setPropertyType("int").setPropertyName("state").setKeyType(20).setColumnComment("Added by Paul, \u7528\u6765\u6807\u5fd7\u7528\u6237\u662f\u5426\u65b0\u7528\u6237"));
        colList = tableMap.get("PET_NEWS").getColumnList();
        colList.add(new Column().setPropertyType("PetOwner").setPropertyName("petOwner").setKeyType(10));
        colList.add(new Column().setPropertyType("String").setPropertyName("newsDate").setKeyType(20).setColumnComment("\u5c06\u65e5\u671f\u8f6c\u6362\u6210\u529f\u663e\u793a\u7684\u65e5\u671f\u5b57\u7b26\u4e32\uff0c\u6bd4\u59822\u5929\u524d\u30013\u5c0f\u65f6\u524d"));
        colList = tableMap.get("USER_MSG").getColumnList();
        colList.add(new Column().setPropertyType("KaixinUser").setPropertyName("contact").setKeyType(20));
        consList = tableMap.get("PET_NEWS").getConstantList();
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_REGISTER").setDefaultValue("0").setColumnComment("\u6ce8\u518c"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_LOGIN").setDefaultValue("1").setColumnComment("\u767b\u9646"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_BONE_RECEIVED_FROM_SYS").setDefaultValue("2").setColumnComment("\u7cfb\u7edf\u9001\u9aa8\u5934"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_GIVE_BONE_TO_FRIEND").setDefaultValue("10").setColumnComment("\u9001\u597d\u53cb\u9aa8\u5934"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_BUY_FOOD").setDefaultValue("11").setColumnComment("\u8d2d\u4e70\u72d7\u7cae"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_BUY_JEWELRY").setDefaultValue("12").setColumnComment("\u8d2d\u4e70\u9970\u54c1"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_FEED_FOOD").setDefaultValue("20").setColumnComment("\u5582\u98df"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_FEED_WATER").setDefaultValue("21").setColumnComment("\u5582\u6c34"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_PLAY_FRISBEE").setDefaultValue("22").setColumnComment("\u63a5\u98de\u76d8"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_PLAY_PAPER").setDefaultValue("23").setColumnComment("\u5377\u7eb8"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_PALY_LETTER").setDefaultValue("24").setColumnComment("\u53d6\u4fe1"));
        consList.add(new Column().setPropertyType("int").setPropertyName("NEWS_TYPE_PALY_BONE").setDefaultValue("25").setColumnComment("\u6361\u9aa8\u5934"));
        for (Table table : tableMap.values()) {
            Column column;
            List<String> parentList = parentMap.get(table.getTableName());
            int i = 0;
            while (parentList != null && i < parentList.size()) {
                Table parent = tableMap.get(parentList.get(i));
                column = new Column();
                column.setKeyType(10);
                column.setPropertyName(NameUtil.getJavaNameSmallFirst(parent.getTableName()));
                column.setPropertyType(parent.getClassName());
                table.getColumnList().add(column);
                table.getParentList().add(parent);
                ++i;
            }
            List<String> childList = childMap.get(table.getTableName());
            i = 0;
            while (childList != null && i < childList.size()) {
                Table child = tableMap.get(childList.get(i));
                column = new Column();
                column.setKeyType(11);
                column.setPropertyName(String.valueOf(NameUtil.getJavaNameSmallFirst(child.getTableName())) + "List");
                column.setPropertyType("List<" + child.getClassName() + ">");
                table.getColumnList().add(column);
                table.getChildList().add(child);
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder(1024);
        for (Table table : tableMap.values()) {
            sb.delete(0, sb.length());
            sb.append("package com.inc.kaixinmobile.domain;").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append("import java.util.*;").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append("public final class ").append(table.getClassName()).append(" {").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            sb.append(Constants.BLANK_4).append(" * \u5e38\u91cf\u5b9a\u4e49").append(Constants.LS);
            sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            for (Column col : table.getConstantList()) {
                sb.append(Constants.BLANK_4).append("public static final ").append(col.getPropertyType()).append(" ").append(col.getPropertyName()).append(" = ").append(col.getDefaultValue()).append("; // ").append(col.getColumnComment()).append(Constants.LS);
            }
            Integer basicFlag = null;
            Integer extendFlag = null;
            Integer parentFlag = null;
            Integer childFlag = null;
            sb.append(Constants.LS);
            for (Column column : table.getColumnList()) {
                if (basicFlag == null) {
                    basicFlag = 1;
                    sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
                    sb.append(Constants.BLANK_4).append(" * \u57fa\u672c\u5c5e\u6027\uff1a\u5bf9\u5e94\u4e8e\u6570\u636e\u5e93\u8868\u91cc\u7684\u5217").append(Constants.LS);
                    sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
                }
                if (column.getKeyType() != null && 20 == column.getKeyType()) {
                    if (extendFlag == null) {
                        extendFlag = 1;
                        sb.append(Constants.LS);
                        sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
                        sb.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u57fa\u672c\u7c7b\u578b").append(Constants.LS);
                        sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
                    }
                } else if (column.getKeyType() != null && 10 == column.getKeyType()) {
                    if (parentFlag == null) {
                        parentFlag = 1;
                        sb.append(Constants.LS);
                        sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
                        sb.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u7236\u8868\u5b9e\u4f53").append(Constants.LS);
                        sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
                    }
                } else if (column.getKeyType() != null && 11 == column.getKeyType() && childFlag == null) {
                    childFlag = 1;
                    sb.append(Constants.LS);
                    sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
                    sb.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u5b50\u8868\u5b9e\u4f53\u5217\u8868").append(Constants.LS);
                    sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
                }
                sb.append(Constants.BLANK_4).append("private ").append(column.getPropertyType()).append(" ").append(column.getPropertyName()).append(";");
                if (column.getColumnName() != null || column.getColumnComment() != null) {
                    sb.append(" //");
                }
                if (column.getColumnName() != null) {
                    sb.append(" ").append(column.getColumnName());
                }
                if (column.getColumnComment() != null) {
                    sb.append(" ").append(column.getColumnComment());
                }
                sb.append(Constants.LS);
            }
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            sb.append(Constants.BLANK_4).append(" * set get \u65b9\u6cd5").append(Constants.LS);
            sb.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            for (Column column : table.getColumnList()) {
                sb.append(Constants.LS);
                sb.append(Constants.BLANK_4).append("public void").append(" set").append(NameUtil.upperCaseFirstChar(column.getPropertyName())).append("(").append(column.getPropertyType()).append(" ").append(column.getPropertyName()).append(") {").append(Constants.LS);
                sb.append(Constants.BLANK_8).append("this.").append(column.getPropertyName()).append(" = ").append(column.getPropertyName()).append(";").append(Constants.LS);
                sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
                sb.append(Constants.LS);
                sb.append(Constants.BLANK_4).append("public ").append(column.getPropertyType()).append(" get").append(NameUtil.upperCaseFirstChar(column.getPropertyName())).append("() {").append(Constants.LS);
                sb.append(Constants.BLANK_8).append("return ").append(column.getPropertyName()).append(";").append(Constants.LS);
                sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
            }
            sb.append("}").append(Constants.LS);
            FileIO.writeToFile(String.valueOf(outFilePath) + table.getClassName() + ".java", sb.toString(), false, "UTF-8");
        }
        for (Table table : tableMap.values()) {
            Column pk = table.getPK();
            Column updatedDateColumn = null;
            for (Column col : table.getColumnList()) {
                if (col.getColumnName() == null || !col.getColumnName().equals("UPDATED_DATE")) continue;
                updatedDateColumn = col;
                break;
            }
            sb.delete(0, sb.length());
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>").append(Constants.LS);
            sb.append("<!DOCTYPE sqlMap PUBLIC \"-//ibatis.apache.org//DTD SQL Map 2.0//EN\"").append(" \"http://ibatis.apache.org/dtd/sql-map-2.dtd\" >").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append("<sqlMap namespace=\"").append(table.getClassName()).append("\">").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<typeAlias alias=\"").append(table.getClassName()).append("\" type=\"com.inc.kaixinmobile.domain.").append(table.getClassName()).append("\" />").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u7ed3\u679c\u96c6\u6620\u5c04 -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<resultMap id=\"result").append(table.getClassName()).append("\" class=\"").append(table.getClassName()).append("\">").append(Constants.LS);
            for (Column col : table.getColumnList()) {
                if (col.getKeyType() != null) continue;
                sb.append(Constants.BLANK_8).append("<result property=\"").append(col.getPropertyName()).append("\" column=\"").append(col.getColumnName()).append("\" />").append(Constants.LS);
            }
            sb.append(Constants.BLANK_4).append("</resultMap>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u63d2\u5165\u64cd\u4f5c -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<insert id=\"create\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("insert into ").append(table.getTableName()).append(" (");
            int i = 0;
            for (Column col : table.getColumnList()) {
                if (i == 0 || col.getKeyType() != null || col == updatedDateColumn) {
                    ++i;
                    continue;
                }
                if (i++ % 5 == 1) {
                    sb.append(Constants.LS).append(Constants.BLANK_12);
                }
                sb.append(col.getColumnName()).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(Constants.LS).append(Constants.BLANK_8).append(") values (");
            i = 0;
            for (Column col : table.getColumnList()) {
                if (i == 0 || col.getKeyType() != null || col == updatedDateColumn) {
                    ++i;
                    continue;
                }
                if (i++ % 5 == 1) {
                    sb.append(Constants.LS).append(Constants.BLANK_12);
                }
                if (col.getDefaultValue() != null) {
                    sb.append(col.getDefaultValue()).append(", ");
                    continue;
                }
                sb.append("#").append(col.getPropertyName()).append("#, ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_8).append(")").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("<selectKey resultClass=\"int\" keyProperty=\"").append(pk.getPropertyName()).append("\">").append(Constants.LS);
            sb.append(Constants.BLANK_12).append("select @@IDENTITY as ID").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("</selectKey>").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</insert>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u5220\u9664\u64cd\u4f5c\uff1a\u6839\u636eID\u5220\u9664\u8bb0\u5f55 -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<delete id=\"remove\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("delete from ").append(table.getTableName()).append(" where ").append(pk.getColumnName()).append(" = #").append(pk.getPropertyName()).append("#").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</delete>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u66f4\u65b0\u64cd\u4f5c\uff1a\u6839\u636eID\u66f4\u65b0\u5176\u5b83\u5217 -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<update id=\"update\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("update ").append(table.getTableName()).append(" set ").append(Constants.LS);
            if (updatedDateColumn != null) {
                sb.append(Constants.BLANK_12).append(updatedDateColumn.getColumnName()).append(" = getDate()").append(Constants.LS);
            }
            sb.append(Constants.BLANK_8).append("<dynamic>").append(Constants.LS);
            i = 0;
            for (Column col : table.getColumnList()) {
                if (col.getKeyType() != null || col == updatedDateColumn || col.getColumnName().endsWith("CREATED_DATE") || i++ == 0) continue;
                sb.append(Constants.BLANK_12).append("<isNotEmpty property = \"").append(col.getPropertyName()).append("\">").append(Constants.LS);
                sb.append(Constants.BLANK_16).append(",").append(col.getColumnName()).append(" = #").append(col.getPropertyName()).append("#").append(Constants.LS);
                sb.append(Constants.BLANK_12).append("</isNotEmpty>").append(Constants.LS);
            }
            sb.append(Constants.BLANK_8).append("</dynamic>").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("where ").append(pk.getColumnName()).append(" = #").append(pk.getPropertyName()).append("#").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</update>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u67e5\u8be2\u64cd\u4f5c\uff1a\u6839\u636eID\u83b7\u5f97\u8bb0\u5f55 -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<select id=\"findById\" resultMap=\"result").append(table.getClassName()).append("\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("select * from ").append(table.getTableName()).append(" where ").append(pk.getColumnName()).append(" = #").append(pk.getPropertyName()).append("#").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</select>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u67e5\u8be2\u64cd\u4f5c\uff1a\u7edf\u8ba1\u6570\u636e\u603b\u6761\u6570 -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<select id=\"totalCount\" resultClass=\"int\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("select count(").append(pk.getColumnName()).append(") from ").append(table.getTableName()).append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</select>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u67e5\u8be2\u64cd\u4f5c\uff1a(\u4e0d\u7ffb\u9875)\u83b7\u5f97\u6240\u6709\u6570\u636e -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<select id=\"findList\" resultMap=\"result").append(table.getClassName()).append("\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("select * from ").append(table.getTableName()).append(Constants.LS);
            if (table.getParentList().size() > 0) {
                sb.append(Constants.BLANK_8).append(" where ");
                int j = 0;
                for (Table table2 : table.getParentList()) {
                    if (j++ == 0) {
                        sb.append(table2.getPK().getColumnName()).append(" = #").append(table2.getPK().getPropertyName()).append("#").append(Constants.LS);
                        continue;
                    }
                    sb.append(Constants.BLANK_8).append("   and ").append(table2.getPK().getColumnName()).append(" = #").append(table2.getPK().getPropertyName()).append("#").append(Constants.LS);
                }
            }
            sb.append(Constants.BLANK_4).append("</select>").append(Constants.LS);
            sb.append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<!-- \u67e5\u8be2\u64cd\u4f5c\uff1a(\u7ffb\u9875)\u83b7\u5f97\u90e8\u5206\u6570\u636e -->").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("<select id=\"findPageList\" resultMap=\"result").append(table.getClassName()).append("\">").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("select * from (").append(Constants.LS);
            sb.append(Constants.BLANK_12).append("select row_number() over(order by ").append(pk.getColumnName()).append(" asc) as ROW_NUM, *").append(Constants.LS);
            sb.append(Constants.BLANK_12).append("  from ").append(table.getTableName()).append(Constants.LS);
            if (table.getParentList().size() > 0) {
                sb.append(Constants.BLANK_12).append(" where ");
                int j = 0;
                for (Table table3 : table.getParentList()) {
                    if (j++ == 0) {
                        sb.append(table3.getPK().getColumnName()).append(" = #").append(table3.getPK().getPropertyName()).append("#").append(Constants.LS);
                        continue;
                    }
                    sb.append(Constants.BLANK_12).append("   and ").append(table3.getPK().getColumnName()).append(" = #").append(table3.getPK().getPropertyName()).append("#").append(Constants.LS);
                }
            }
            sb.append(Constants.BLANK_8).append(") as T1").append(Constants.LS);
            sb.append(Constants.BLANK_8).append("where T1.ROW_NUM between #start# and #end#").append(Constants.LS);
            sb.append(Constants.BLANK_4).append("</select>").append(Constants.LS);
            sb.append("</sqlMap>");
            FileIO.writeToFile(String.valueOf(outFilePath) + table.getClassName() + ".xml", sb.toString(), false, "UTF-8");
        }
    }

    public static Map<String, Table> extractTable(String src) {
        Pattern p = Pattern.compile(regExpCreateTable, 2);
        Matcher m = p.matcher(src);
        while (m.find()) {
            Table table = new Table();
            table.setTableName(m.group(1));
            tableMap.put(table.getTableName(), table);
            Pattern pColumn = Pattern.compile(regExpCreateColumn, 2);
            Matcher mColumn = pColumn.matcher(m.group(2));
            while (mColumn.find()) {
                Column column = new Column();
                column.setColumnName(mColumn.group(1));
                column.setColumnType(mColumn.group(2));
                OutCode.makeJavaType(column);
                Pattern pDefaultValue = Pattern.compile(regExpDefaultValue, 2);
                Matcher mDefaultValue = pDefaultValue.matcher(mColumn.group());
                if (mDefaultValue.find()) {
                    column.setDefaultValue(mDefaultValue.group(1));
                } else if (mColumn.group().indexOf("NOT NULL") > 0 && column.getPropertyType().equals("Date")) {
                    column.setDefaultValue("getDate()");
                }
                Pattern pColumnComment = Pattern.compile(regExpColumnComment, 2);
                Matcher mColumnComment = pColumnComment.matcher(mColumn.group());
                if (mColumnComment.find()) {
                    column.setColumnComment(mColumnComment.group(1));
                }
                table.getColumnList().add(column);
            }
        }
        System.out.println(tableMap);
        return tableMap;
    }

    public static void extractReference(String src) {
        Pattern pReference = Pattern.compile(regExpCreateFK, 2);
        Matcher mReference = pReference.matcher(src);
        while (mReference.find()) {
            String tableName = mReference.group(1);
            String parentName = mReference.group(2);
            List<String> parentList = parentMap.get(tableName);
            if (parentList == null) {
                parentList = new ArrayList<String>(5);
                parentMap.put(tableName, parentList);
            }
            parentList.add(parentName);
            List<String> childList = childMap.get(parentName);
            if (childList == null) {
                childList = new ArrayList<String>(5);
                childMap.put(parentName, childList);
            }
            childList.add(tableName);
        }
        System.out.println(parentMap);
        System.out.println(childMap);
    }

    public static void makeJavaType(Column column) {
        String dataType = column.getColumnType();
        String javaType = null;
        if (dataType == null) {
            javaType = "NaN";
        } else if (dataType.indexOf("VARCHAR") != -1 || dataType.indexOf("TEXT") != -1 || dataType.indexOf("CHAR") != -1 || dataType.indexOf("CLOB") != -1) {
            javaType = "String";
        } else if (dataType.indexOf("INT") != -1 || dataType.indexOf("TINYINT") != -1 || dataType.indexOf("SMALLINT") != -1 || dataType.indexOf("MEDIUMINT") != -1) {
            javaType = "Integer";
        } else if (dataType.indexOf("NUMBER") != -1 || dataType.indexOf("NUMERIC") != -1 || dataType.indexOf("DECIMAL") != -1 || dataType.indexOf("INT") != -1 || dataType.indexOf("SERIAL") != -1) {
            javaType = dataType.indexOf(",2") != -1 ? "Double" : "Integer";
        } else if (dataType.indexOf("TIMESTAMP") != -1 || dataType.indexOf("DATE") != -1) {
            javaType = "Date";
        }
        column.setPropertyType(javaType);
    }
}

