/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.entity;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.sysolar.util.file.FileIO;

public final class Config {
    public static final int MAKE_TYPE_TEMP = 0;
    public static final int MAKE_TYPE_OFFICIAL = 1;
    public static final int DB_TYPE_MYSQL = 0;
    public static final int DIR_TYPE_SRC = 0;
    public static final int DIR_TYPE_ENTITY = 1;
    public static final int DIR_TYPE_SQL = 2;
    public static final int DIR_TYPE_CONSTANT = 3;
    public static final int DIR_TYPE_DAO = 4;
    public static final int DIR_TYPE_DAOIMPL = 5;
    public static final int DIR_TYPE_LOGIC = 6;
    public static final int DIR_TYPE_LOGICIMPL = 7;
    public static final int DIR_TYPE_ACTION = 8;
    public static final int DIR_TYPE_JS_ENTITY = 9;
    public static final int DIR_TYPE_JS_LOGIC = 10;
    private String appRoot;
    private String ddlFile;
    private int dbType;
    private String packageName;
    private int makeType;
    private String charset;
    private Map<String, Object> map = new HashMap<String, Object>();

    public File getDir(int dirType) {
        return this.getDir(dirType, false);
    }

    public File getDir(int dirType, boolean official) {
        File dir = null;
        File parent = new File(this.appRoot, "make/");
        switch (dirType) {
            case 0: {
                dir = parent;
                break;
            }
            case 1: {
                dir = new File(parent, "entity/");
                break;
            }
            case 2: {
                dir = new File(parent, "sql/");
                break;
            }
            case 3: {
                dir = new File(parent, "constant/");
                break;
            }
            case 4: {
                dir = new File(parent, "dao/");
                break;
            }
            case 5: {
                dir = new File(parent, "daoimpl/");
                break;
            }
            case 6: {
                dir = new File(parent, "logic/");
                break;
            }
            case 7: {
                dir = new File(parent, "logicimpl/");
                break;
            }
            case 8: {
                dir = new File(parent, "action/");
                break;
            }
            case 9: {
                dir = new File(parent, "js");
                break;
            }
            case 10: {
                dir = new File(parent, "js");
            }
        }
        parent = new File(this.appRoot, "src/" + this.getPackageName().replace('.', '/'));
        File jsDir = new File(this.appRoot, "WebRoot/js/");
        File temp = null;
        if (this.makeType == 1) {
            switch (dirType) {
                case 0: {
                    dir = new File(String.valueOf(this.getAppRoot()) + "src/");
                    break;
                }
                case 1: {
                    dir = new File(parent, "entity/");
                    break;
                }
                case 2: {
                    dir = new File(String.valueOf(this.appRoot) + "sql/");
                    break;
                }
                case 3: {
                    dir = new File(parent, "constant/");
                    break;
                }
                case 4: {
                    temp = new File(parent, "dao/");
                    if (temp.exists()) break;
                    dir = temp;
                    break;
                }
                case 5: {
                    temp = new File(parent, "daoimpl/");
                    if (temp.exists()) break;
                    dir = temp;
                    break;
                }
                case 6: {
                    temp = new File(parent, "logic/");
                    if (temp.exists() && !official) break;
                    dir = temp;
                    break;
                }
                case 7: {
                    temp = new File(parent, "logicimpl/");
                    if (temp.exists()) break;
                    dir = temp;
                    break;
                }
                case 8: {
                    temp = new File(parent, "action/");
                    if (temp.exists() && !official) break;
                    dir = temp;
                    break;
                }
                case 9: {
                    dir = new File(jsDir, "entity/");
                    break;
                }
                case 10: {
                    temp = new File(jsDir, "entity/");
                    int size = FileIO.listFiles(temp).length;
                    if (size > 1 && !official) break;
                    dir = temp;
                }
            }
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getAppRoot() {
        return this.appRoot;
    }

    public void setAppRoot(String appRoot) {
        this.appRoot = appRoot;
    }

    public String getDdlFile() {
        return this.ddlFile;
    }

    public void setDdlFile(String ddlFile) {
        this.ddlFile = ddlFile;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getMakeType() {
        return this.makeType;
    }

    public void setMakeType(int makeType) {
        this.makeType = makeType;
    }

    public void setValue(String key, Object value) {
        this.map.put(key, value);
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }
}

