/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.codehelper.javaee.entity.FieldConstant;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public final class MakeEntity {
    public static void doMake(List<Entity> entityList, Config config) {
        String packName = String.valueOf(config.getPackageName()) + ".entity";
        File dir = config.getDir(1);
        String charset = config.getCharset();
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            buffer.append("package ").append(packName).append(";").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import java.util.*;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import org.sysolar.sun.mvc.support.Json;").append(Constants.LS);
            buffer.append("import org.sysolar.sun.mvc.support.RequestWrapper;").append(Constants.LS);
            if (config.getValue("derby") != null) {
                buffer.append("import org.sysolar.sun.jdbc.support.NullType;").append(Constants.LS);
            }
            buffer.append(Constants.LS);
            buffer.append("/**").append(Constants.LS);
            buffer.append(" * ").append(entity.getTableName()).append(" : ").append(entity.getTableComment()).append(Constants.LS);
            buffer.append(" */").append(Constants.LS);
            buffer.append("public final class ").append(entity.getClassName()).append(" {").append(Constants.LS);
            MakeEntity.appendConstant(entity, buffer);
            MakeEntity.appendField(entity, buffer);
            MakeEntity.appendSetDefault(entity, buffer);
            MakeEntity.appendSetGetAdd(entity, buffer);
            MakeEntity.appendFillFromDB(entity, buffer);
            MakeEntity.appendFillFromRequest(entity, buffer);
            MakeEntity.appendFillFromJsonString(entity, buffer);
            MakeEntity.appendFillFromJsonMap(entity, buffer);
            MakeEntity.appendClone(entity, buffer);
            MakeEntity.appendToString(entity, buffer);
            MakeEntity.appendToArray(entity, buffer, config);
            buffer.append("}");
            File entityFile = new File(dir, String.valueOf(entity.getClassName()) + ".java");
            FileIO.writeToFile(entityFile, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
        }
    }

    private static void appendConstant(Entity entity, StringBuilder buffer) {
        for (Field field : entity.getFieldList()) {
            if (field.getConsList() == null) continue;
            buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u5e38\u91cf\u58f0\u660e").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            break;
        }
        if (entity.getConsList() != null) {
            for (FieldConstant cons : entity.getConsList()) {
                buffer.append(Constants.BLANK_4).append("public static final ").append(cons.getConsType()).append(" ").append(cons.getConsName()).append(" = ");
                if ("String".equals(cons.getConsType())) {
                    buffer.append("\"").append(cons.getConsValue()).append("\"");
                } else {
                    buffer.append(cons.getConsValue());
                }
                buffer.append(";");
                if (cons.getConsComment() != null) {
                    buffer.append(" // ").append(cons.getConsComment());
                }
                buffer.append(Constants.LS);
            }
            buffer.append(Constants.LS);
        }
        for (Field field : entity.getFieldList()) {
            if (field.getConsList() == null) continue;
            buffer.append(Constants.BLANK_4).append("// ").append(field.getComment()).append(Constants.LS);
            for (FieldConstant cons : field.getConsList()) {
                buffer.append(Constants.BLANK_4).append("public static final ");
                if (field.getFieldType().equals("Integer")) {
                    buffer.append("int");
                } else if (field.getFieldType().equals("Long")) {
                    buffer.append("long");
                } else {
                    buffer.append(field.getFieldType());
                }
                buffer.append(" ").append(cons.getConsName()).append(" = ");
                if ("String".equals(cons.getConsType())) {
                    buffer.append("\"").append(cons.getConsValue()).append("\"");
                } else {
                    buffer.append(cons.getConsValue());
                }
                buffer.append(";").append(Constants.LS);
            }
            buffer.append(Constants.LS);
        }
    }

    private static void appendField(Entity entity, StringBuilder buffer) {
        buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u57fa\u672c\u5c5e\u6027\uff1a\u4e0e\u5217\u5bf9\u5e94").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        for (Field field : entity.getFieldList()) {
            buffer.append(Constants.BLANK_4).append("private ").append(field.getFieldType()).append(" ").append(field.getFieldName()).append("; // ").append(field.getColumnName()).append(" ").append(field.getColumnType()).append(" ").append(field.getComment()).append(Constants.LS);
        }
        if (entity.getPropertyList() != null) {
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u57fa\u672c\u6269\u5c55").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            for (Field field : entity.getPropertyList()) {
                buffer.append(Constants.BLANK_4).append("private ").append(field.getFieldType()).append(" ").append(field.getFieldName()).append("; // ").append(field.getComment()).append(Constants.LS);
            }
        }
        if (entity.getParentList() != null) {
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u7236\u8868\u5b9e\u4f53").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            for (Entity e : entity.getParentList()) {
                buffer.append(Constants.BLANK_4).append("private ").append(e.getClassName()).append(" ").append(NameUtil.getJavaNameSmallFirst(e.getTableName())).append("; // ").append(e.getTableName()).append(" ").append(e.getTableComment()).append(Constants.LS);
            }
        }
        if (entity.getChildList() != null) {
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6269\u5c55\u5c5e\u6027\uff1a\u5b50\u8868\u5b9e\u4f53").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            for (Entity e : entity.getChildList()) {
                buffer.append(Constants.BLANK_4).append("private List<").append(e.getClassName()).append("> ").append(NameUtil.getJavaNameSmallFirst(e.getTableName())).append("List; // ").append(e.getTableName()).append(" ").append(e.getTableComment()).append(Constants.LS);
            }
        }
        buffer.append(Constants.LS);
    }

    private static void appendSetDefault(Entity entity, StringBuilder buffer) {
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u8bbe\u5b9a\u9ed8\u8ba4\u503c").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" setDefault() {").append(Constants.LS);
        for (Field field : entity.getFieldList()) {
            if (!field.getFieldType().equals("Date") || field.getNotNull() == null) continue;
            buffer.append(Constants.BLANK_8).append("Date date = new Date();").append(Constants.LS);
            break;
        }
        for (Field field : entity.getFieldList()) {
            if (field.getDefaultValue() != null) {
                buffer.append(Constants.BLANK_8).append("if(null == ").append(field.getFieldName()).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append(field.getFieldName()).append(" = ").append(field.getDefaultValue()).append(";").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
                continue;
            }
            if (!field.getFieldType().equals("Date") || field.getNotNull() == null) continue;
            buffer.append(Constants.BLANK_8).append("if(null == ").append(field.getFieldName()).append(") {").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append(field.getFieldName()).append(" = date;").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendSetGetAdd(Entity entity, StringBuilder buffer) {
        String className;
        buffer.append(Constants.BLANK_4).append("/*").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * set\u3001get\u3001add \u65b9\u6cd5").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS).append(Constants.LS);
        ArrayList<Field> fieldList = new ArrayList<Field>(30);
        fieldList.addAll(entity.getFieldAndPropertyList());
        if (entity.getParentList() != null) {
            for (Entity e : entity.getParentList()) {
                className = e.getClassName();
                fieldList.add(new Field().setFieldType(className).setFieldName(NameUtil.lowerCaseFirstChar(className)));
            }
        }
        if (entity.getChildList() != null) {
            for (Entity e : entity.getChildList()) {
                className = e.getClassName();
                String varName = NameUtil.lowerCaseFirstChar(e.getClassName());
                String listType = "List<" + className + ">";
                String listName = String.valueOf(varName) + "List";
                buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" add(").append(className).append(" ").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("if(null == ").append(listName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append(listName).append(" = new ArrayList<").append(className).append(">(30);").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append(listName).append(".add(").append(varName).append(");").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
                buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
                buffer.append(Constants.LS);
                buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" set").append(className).append("List").append("(").append(listType).append(" ").append(listName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("this.").append(listName).append(" = ").append(listName).append(";").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
                buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
                buffer.append(Constants.LS);
                buffer.append(Constants.BLANK_4).append("public ").append(listType).append(" get").append(className).append("List() {").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("return ").append(listName).append(";").append(Constants.LS);
                buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
                buffer.append(Constants.LS);
            }
        }
        for (Field field : fieldList) {
            buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" set").append(NameUtil.upperCaseFirstChar(field.getFieldName())).append("(").append(field.getFieldType()).append(" ").append(field.getFieldName()).append(") {").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("this.").append(field.getFieldName()).append(" = ").append(field.getFieldName()).append(";").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
        }
        for (Field field : fieldList) {
            buffer.append(Constants.BLANK_4).append("public ").append(field.getFieldType()).append(" get").append(NameUtil.upperCaseFirstChar(field.getFieldName())).append("() {").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return ").append(field.getFieldName()).append(";").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
        }
    }

    private static void appendFillFromDB(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        if (entity.getParentList() != null) {
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u7528\u67e5\u8be2\u7ed3\u679c Map \u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\uff0c\u5305\u542b\u5bf9\u7236\u8868\u5b9e\u4f53\u7684\u521b\u5efa\u3001\u8d4b\u503c\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public ").append(className).append(" fill(Map<String, Object> row");
            for (Entity parent : entity.getParentList()) {
                buffer.append(", boolean fill").append(parent.getClassName());
            }
            buffer.append(") {").append(Constants.LS);
            for (Entity parent : entity.getParentList()) {
                String parentClass = parent.getClassName();
                String parentEntity = NameUtil.lowerCaseFirstChar(parentClass);
                buffer.append(Constants.BLANK_8).append("if(fill").append(parentClass).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append(parentEntity).append(" = new ").append(parentClass).append("().fill(row);").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
            buffer.append(Constants.BLANK_8).append("return this.fill(row);").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
        }
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u7528\u67e5\u8be2\u7ed3\u679c Map \u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" fill(Map<String, Object> row) {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("Object obj = null;").append(Constants.LS);
        for (Field field : entity.getFieldAndPropertyList()) {
            if (field.getColumnName() == null) continue;
            buffer.append(Constants.BLANK_8).append("if(null != (obj = row.get(\"").append(field.getColumnName()).append("\"))) {").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append(field.getFieldName()).append(" = ");
            if (field.getFieldType().equals("Integer")) {
                buffer.append("((Number)obj).intValue();");
            } else if (field.getFieldType().equals("Long")) {
                buffer.append("((Number)obj).longValue();");
            } else if (field.getFieldType().equals("Double")) {
                buffer.append("((Number)obj).doubleValue();");
            } else if (field.getFieldType().equals("String")) {
                buffer.append("(String)obj;");
            } else if (field.getFieldType().equals("Date")) {
                buffer.append("(Date)obj;");
            }
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendFillFromRequest(Entity entity, StringBuilder buffer) {
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u7528 request \u53c2\u6570\u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" fill(RequestWrapper wrapper) throws Exception {").append(Constants.LS);
        for (Field field : entity.getFieldAndPropertyList()) {
            if (field.getColumnName() == null) continue;
            buffer.append(Constants.BLANK_8).append(field.getFieldName()).append(" = wrapper.get").append(field.getFieldType()).append("(\"");
            buffer.append(String.valueOf(field.getFieldName()) + "\");").append(Constants.LS);
        }
        buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendFillFromJsonString(Entity entity, StringBuilder buffer) {
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u7528 json \u683c\u5f0f\u5b57\u7b26\u4e32\u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" fillJson(String json) {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return this.fillJson(Json.toJavaMap(json));").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendFillFromJsonMap(Entity entity, StringBuilder buffer) {
        String varName;
        String className;
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u7528 json \u683c\u5f0f\u5b57\u7b26\u4e32\u8f6c\u6362\u540e\u7684 Map \u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@SuppressWarnings(\"unchecked\")").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" fillJson(Map<String, Object> json) {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("Object value = null;").append(Constants.LS);
        for (Field field : entity.getFieldAndPropertyList()) {
            String fieldName = field.getFieldName();
            String fieldType = field.getFieldType();
            buffer.append(Constants.BLANK_8).append("if(null != (value = json.get(\"").append(fieldName).append("\"))) {").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append(fieldName).append(" = ");
            if (fieldType.equals("Integer")) {
                buffer.append("Integer.valueOf((String)value);");
            } else if (fieldType.equals("Long")) {
                buffer.append("Long.valueOf((String)value);");
            } else if (fieldType.equals("Double")) {
                buffer.append("Double.valueOf((String)value);");
            } else if (fieldType.equals("String")) {
                buffer.append("(String)value;");
            } else if (fieldType.equals("Date")) {
                buffer.append("new Date(Long.valueOf((String)value));");
            } else {
                buffer.append("null;");
            }
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        if (entity.getParentList() != null) {
            for (Entity e : entity.getParentList()) {
                className = e.getClassName();
                varName = NameUtil.lowerCaseFirstChar(className);
                buffer.append(Constants.BLANK_8).append("if(null != (value = json.get(\"").append(varName).append("\"))) {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append(varName).append(" = new ").append(className).append("().fillJson((Map<String, Object>)value);").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        if (entity.getChildList() != null) {
            for (Entity e : entity.getChildList()) {
                className = e.getClassName();
                varName = String.valueOf(NameUtil.lowerCaseFirstChar(className)) + "List";
                buffer.append(Constants.BLANK_8).append("if(null != (value = json.get(\"").append(varName).append("\"))) {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("for(Object obj : (List<Object>)value) {").append(Constants.LS);
                buffer.append(Constants.BLANK_16).append("this.add(new ").append(className).append("().fillJson((Map<String, Object>)obj));").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("}").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        buffer.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendClone(Entity entity, StringBuilder buffer) {
        String className;
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u6df1\u5ea6\u514b\u9686\u5b9e\u4f53\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(entity.getClassName()).append(" clone() {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append(entity.getClassName()).append(" e = new ").append(entity.getClassName()).append("();").append(Constants.LS);
        for (Field field : entity.getFieldAndPropertyList()) {
            String fieldName = field.getFieldName();
            buffer.append(Constants.BLANK_8).append("e.").append(fieldName).append(" = this.").append(fieldName).append(";").append(Constants.LS);
        }
        if (entity.getParentList() != null) {
            for (Entity e : entity.getParentList()) {
                className = e.getClassName();
                String varName = NameUtil.lowerCaseFirstChar(className);
                buffer.append(Constants.BLANK_8).append("if(null != this.").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("e.").append(varName).append(" = this.").append(varName).append(".clone();").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        if (entity.getChildList() != null) {
            for (Entity e : entity.getChildList()) {
                className = e.getClassName();
                String vName = NameUtil.lowerCaseFirstChar(className);
                String varName = String.valueOf(vName) + "List";
                buffer.append(Constants.BLANK_8).append("if(null != this.").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("for(").append(className).append(" ").append(vName).append(" : this.").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_16).append("e.add(").append(vName).append(".clone());").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("}").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        buffer.append(Constants.BLANK_8).append("return e;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendToString(Entity entity, StringBuilder buffer) {
        String varName;
        String className;
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u8fd4\u56de json \u683c\u5f0f\u5b57\u7b26\u4e32\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public String toString(){").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("StringBuilder buffer = new StringBuilder(512)").append(".append(\"{\");").append(Constants.LS);
        for (Field field : entity.getFieldAndPropertyList()) {
            String fieldName = field.getFieldName();
            String fieldType = field.getFieldType();
            buffer.append(Constants.BLANK_8).append("if(null != ").append(fieldName).append("){").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append("buffer.append(\"").append(fieldName);
            if (fieldType.equals("Date")) {
                buffer.append(":\").append(").append(fieldName).append(".getTime()").append(").append(\",\");");
            } else if (fieldType.equals("String")) {
                buffer.append(":'\").append(").append(fieldName).append(").append(\"',\");");
            } else {
                buffer.append(":\").append(").append(fieldName).append(").append(\",\");");
            }
            buffer.append(Constants.LS).append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        if (entity.getParentList() != null) {
            for (Entity e : entity.getParentList()) {
                className = e.getClassName();
                varName = NameUtil.lowerCaseFirstChar(className);
                buffer.append(Constants.BLANK_8).append("if(null != ").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("buffer.append(\"").append(varName).append(":\").append(").append(varName).append(").append(\",\");").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        if (entity.getChildList() != null) {
            for (Entity e : entity.getChildList()) {
                className = e.getClassName();
                varName = String.valueOf(NameUtil.lowerCaseFirstChar(className)) + "List";
                buffer.append(Constants.BLANK_8).append("if(null != ").append(varName).append(") {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("buffer.append(\"").append(varName).append(":\").append(Json.encode(").append(varName).append(")).append(\",\");").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
        }
        buffer.append(Constants.BLANK_8).append("if(buffer.length() > 1) {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("    buffer.deleteCharAt(buffer.length() - 1);").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return buffer.append(\"}\").toString();").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
    }

    private static void appendToArray(Entity entity, StringBuilder buffer, Config config) {
        buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" * \u8fd4\u56de\u5b9e\u4f53 bean \u5168\u90e8\u5b57\u6bb5\u503c\u7ec4\u6210\u7684\u6570\u7ec4\uff08\u5373\u5305\u542bnull\u503c\uff09\uff0c").append("\u5b57\u6bb5\u503c\u987a\u5e8f\u540cinsert\u8bed\u53e5\u91cc\u7684\u53c2\u6570\u987a\u5e8f\u3002").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public Object[] toArray(){").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return new Object[]{");
        int i = 0;
        while (i < entity.getFieldList().size()) {
            Field field = entity.getFieldList().get(i);
            if (config.getValue("derby") != null && field.getKeyType() != null && field.getKeyType() == 1) {
                buffer.append(Constants.LS);
            } else {
                if (i != 0) {
                    buffer.append(Constants.BLANK_16);
                }
                String methodName = NameUtil.upperCaseFirstChar(field.getFieldName());
                if (config.getValue("derby") != null) {
                    buffer.append("null != this.get").append(methodName).append("() ? this.get").append(methodName).append("() : ");
                    String columnType = field.getColumnType();
                    if (columnType.equals("int") || columnType.equals("tinyint") || columnType.equals("mediumint")) {
                        buffer.append("NullType.INTEGER");
                    } else if (columnType.equals("bigint")) {
                        buffer.append("NullType.BIGINT");
                    } else if (columnType.indexOf("decimal") >= 0) {
                        buffer.append("NullType.DOUBLE");
                    } else if (columnType.indexOf("char") >= 0) {
                        buffer.append("NullType.VARCHAR");
                    } else if (columnType.equals("date") || columnType.equals("datetime")) {
                        field.setFieldType("DATE");
                    } else if (columnType.equals("timestamp")) {
                        buffer.append("NullType.TIMESTAMP");
                    }
                } else {
                    buffer.append("this.get").append(methodName).append("()");
                }
                if (i != entity.getFieldList().size() - 1) {
                    buffer.append(",").append(Constants.LS);
                }
            }
            ++i;
        }
        buffer.append("};").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }
}

