/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.codehelper.javaee.make.MakeAction;
import org.sysolar.codehelper.javaee.make.MakeConfig;
import org.sysolar.codehelper.javaee.make.MakeConstant;
import org.sysolar.codehelper.javaee.make.MakeDao;
import org.sysolar.codehelper.javaee.make.MakeEntity;
import org.sysolar.codehelper.javaee.make.MakeJsEntity;
import org.sysolar.codehelper.javaee.make.MakeJsLogic;
import org.sysolar.codehelper.javaee.make.MakeLogic;
import org.sysolar.codehelper.javaee.make.MakeSql;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public final class Maker {
    private final Map<String, Entity> entityMap = new HashMap<String, Entity>(50);
    private final Config config;

    public Maker(Config config) {
        this.config = config;
    }

    public void doParse() {
        String ddlFile = String.valueOf(this.config.getAppRoot()) + "doc/" + this.config.getDdlFile();
        String ddlSql = FileIO.readAsString(ddlFile, this.config.getCharset());
        ddlSql = ddlSql.replaceAll("\\s+", " ");
        ddlSql = ddlSql.toUpperCase();
        if (this.config.getDbType() == 0) {
            this.parseMysql(ddlSql);
        }
    }

    public void doMake() {
        ArrayList<Entity> entityList = new ArrayList<Entity>(this.entityMap.values());
        for (Entity entity : entityList) {
            if (entity.getChildStatus()) continue;
            entity.setChildList(null);
        }
        MakeEntity.doMake(entityList, this.config);
        MakeSql.doMake(entityList, this.config);
        MakeDao.doMake(entityList, this.config);
        MakeLogic.doMake(entityList, this.config);
        MakeConstant.doMake(entityList, this.config);
        if (this.config.getValue("derby") == null) {
            MakeAction.doMake(entityList, this.config);
            MakeConfig.doMake(entityList, this.config);
            MakeJsEntity.doMake(entityList, this.config);
            MakeJsLogic.doMake(entityList, this.config);
        }
    }

    public Entity getEntity(String tableName) {
        return this.entityMap.get(tableName.toUpperCase());
    }

    private void parseMysql(String ddlSql) {
        Pattern pTable = Pattern.compile("CREATE TABLE (\\w+) \\(([^;]+)\\);");
        Matcher mTable = pTable.matcher(ddlSql);
        while (mTable.find()) {
            Entity entity = new Entity();
            entity.setTableName(mTable.group(1));
            this.entityMap.put(entity.getTableName(), entity);
            String[] stringArray = mTable.group(2).split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                if ((column = column.trim()).startsWith("PRIMARY KEY")) {
                    String columnName = column.substring(13, column.length() - 1);
                    entity.getField(columnName).setKeyType(1);
                } else {
                    String[] cells = column.split(" ");
                    if (cells.length < 2) {
                        System.out.println(column);
                    } else {
                        Pattern pComment;
                        Matcher mComment;
                        Pattern pDefault;
                        Matcher mDefault;
                        Field field = new Field();
                        field.setColumnName(cells[0]);
                        field.setColumnType(cells[1].toLowerCase());
                        if (column.indexOf("NOT NULL") > 0) {
                            field.setNotNull(true);
                        }
                        if (column.indexOf("AUTO_INCREMENT") > 0) {
                            field.setKeyType(1);
                        }
                        if ((mDefault = (pDefault = Pattern.compile("DEFAULT (\\w+)")).matcher(column)).find()) {
                            field.setDefaultValue(mDefault.group(1));
                        }
                        if ((mComment = (pComment = Pattern.compile("COMMENT '([^']+)'")).matcher(column)).find()) {
                            field.setComment(mComment.group(1));
                        }
                        entity.addField(field);
                    }
                }
                ++n2;
            }
        }
        Pattern pTableComment = Pattern.compile("ALTER TABLE (\\w+) COMMENT '([^']+)'");
        Matcher mTableComment = pTableComment.matcher(ddlSql);
        while (mTableComment.find()) {
            this.entityMap.get(mTableComment.group(1)).setTableComment(mTableComment.group(2));
        }
        Pattern pFK = Pattern.compile("ALTER TABLE (\\w+)[^;]+ REFERENCES (\\w+) [^;]+;");
        Matcher mFK = pFK.matcher(ddlSql);
        while (mFK.find()) {
            Entity child = this.entityMap.get(mFK.group(1));
            Entity parent = this.entityMap.get(mFK.group(2));
            child.addParent(parent);
            parent.addChild(child);
        }
        for (Entity e : this.entityMap.values()) {
            e.setClassName(NameUtil.getJavaNameBigFirst(e.getTableName()));
            for (Field field : e.getFieldList()) {
                field.setFieldName(NameUtil.getJavaNameSmallFirst(field.getColumnName()));
                String columnType = field.getColumnType();
                if (columnType.equals("int") || columnType.equals("tinyint") || columnType.equals("mediumint")) {
                    field.setFieldType("Integer");
                    continue;
                }
                if (columnType.equals("bigint")) {
                    field.setFieldType("Long");
                    continue;
                }
                if (columnType.indexOf("decimal") >= 0) {
                    field.setFieldType("Double");
                    continue;
                }
                if (columnType.indexOf("char") >= 0) {
                    field.setFieldType("String");
                    continue;
                }
                if (!columnType.equals("date") && !columnType.equals("datetime") && !columnType.equals("timestamp")) continue;
                field.setFieldType("Date");
            }
            System.out.println(e);
        }
    }
}

