/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.fileupload.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.fileupload.core.FileUploadBase;
import org.sysolar.fileupload.core.UploadChecker;
import org.sysolar.fileupload.ex.ContentTypeException;
import org.sysolar.fileupload.ex.FileExtendException;
import org.sysolar.fileupload.ex.FileSizeException;
import org.sysolar.fileupload.ex.NullFileException;
import org.sysolar.util.array.ByteArray;

public final class SingleFileUpload
extends FileUploadBase {
    private static final Log log = LogFactory.getLog(SingleFileUpload.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public SingleFileUpload(HttpServletRequest request) {
        super(request);
    }

    public File parseRequest(String saveDir, String destFileName, UploadChecker checker) throws ContentTypeException, NullFileException, FileSizeException, FileExtendException {
        File file;
        block37: {
            if (DEBUG) {
                log.debug((Object)("contentType=" + this.request.getContentType() + "; contentLength=" + this.request.getContentLength()));
            }
            if (!super.isMultipartContent()) {
                throw new ContentTypeException("Invalid Content-Type:" + this.request.getContentType());
            }
            file = null;
            ServletInputStream in = null;
            BufferedOutputStream out = null;
            try {
                try {
                    super.setBoundary();
                    byte[] buffer = new byte[4096];
                    int len = -1;
                    String data = null;
                    int pos = -1;
                    String fileName = null;
                    String fieldName = null;
                    String fieldValue = null;
                    in = this.request.getInputStream();
                    int status = 0;
                    while ((len = in.readLine(buffer, 0, buffer.length)) != -1 && !ByteArray.startWith(buffer, this.lastBoundary)) {
                        switch (status) {
                            case 0: {
                                if (!ByteArray.startWith(buffer, this.dataBoundary)) break;
                                status = 1;
                                break;
                            }
                            case 1: {
                                data = this.request.getCharacterEncoding() != null ? new String(buffer, 0, len, this.request.getCharacterEncoding()) : new String(buffer, 0, len);
                                pos = data.indexOf("filename=\"");
                                if (pos != -1) {
                                    fileName = data.substring(pos + 10, data.lastIndexOf(34));
                                    if (fileName.equals("")) {
                                        throw new NullFileException();
                                    }
                                    String[] tmpArr = fileName.split("\\.");
                                    String fileExtend = tmpArr[tmpArr.length - 1];
                                    if (checker != null) {
                                        if (!checker.isFileSizeValid(this.request.getContentLength())) {
                                            StringBuilder sb = new StringBuilder(100);
                                            sb.append(fileName).append("(").append(this.request.getContentLength() / 1024).append("K) is too big !");
                                            throw new FileSizeException(sb.toString(), fileName);
                                        }
                                        if (!checker.isFileExtendValid(fileExtend)) {
                                            throw new FileExtendException(String.valueOf(fileName) + " is an unvalid file \uff01", fileName);
                                        }
                                    }
                                    if (!(file = new File(saveDir, destFileName = destFileName == null ? fileName : String.valueOf(destFileName) + "." + fileExtend.toLowerCase())).getParentFile().exists()) {
                                        file.getParentFile().mkdirs();
                                    }
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    out = new BufferedOutputStream(new FileOutputStream(file));
                                    len = in.readLine(buffer, 0, buffer.length);
                                    status = 3;
                                } else {
                                    pos = data.indexOf("name=\"");
                                    fieldName = data.substring(pos + 6, data.lastIndexOf(34));
                                    status = 2;
                                }
                                len = in.readLine(buffer, 0, buffer.length);
                                break;
                            }
                            case 3: {
                                if (ByteArray.startWith(buffer, this.dataBoundary)) {
                                    status = 1;
                                    break;
                                }
                                out.write(buffer, 0, len);
                                break;
                            }
                            case 2: {
                                if (ByteArray.startWith(buffer, this.dataBoundary)) {
                                    status = 1;
                                    break;
                                }
                                fieldValue = this.request.getCharacterEncoding() == null ? new String(buffer, 0, len) : new String(buffer, 0, len, this.request.getCharacterEncoding());
                                this.setAttribute(fieldName, fieldValue.trim());
                            }
                        }
                    }
                }
                catch (NullFileException ex) {
                    throw ex;
                }
                catch (FileSizeException ex) {
                    log.error((Object)ex.getMessage());
                    throw ex;
                }
                catch (FileExtendException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                            out = null;
                        }
                        catch (IOException iOException) {}
                    }
                    break block37;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                        out = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                    out = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (DEBUG) {
            log.debug((Object)("file=" + file.getAbsolutePath()));
        }
        return file;
    }

    public String parseRequest(String charset, UploadChecker checker) throws ContentTypeException, NullFileException, FileSizeException, FileExtendException {
        if (DEBUG) {
            log.debug((Object)("contentType=" + this.request.getContentType() + "; contentLength=" + this.request.getContentLength()));
        }
        if (!super.isMultipartContent()) {
            throw new ContentTypeException("Invalid Content-Type:" + this.request.getContentType());
        }
        ServletInputStream in = null;
        StringBuilder body = null;
        if (charset == null) {
            charset = "GBK";
        }
        try {
            super.setBoundary();
            byte[] buffer = new byte[4096];
            int len = -1;
            String data = null;
            int pos = -1;
            String fileName = null;
            String fieldName = null;
            String fieldValue = null;
            in = this.request.getInputStream();
            int status = 0;
            while ((len = in.readLine(buffer, 0, buffer.length)) != -1 && !ByteArray.startWith(buffer, this.lastBoundary)) {
                switch (status) {
                    case 0: {
                        if (!ByteArray.startWith(buffer, this.dataBoundary)) break;
                        status = 1;
                        break;
                    }
                    case 1: {
                        data = this.request.getCharacterEncoding() != null ? new String(buffer, 0, len, this.request.getCharacterEncoding()) : new String(buffer, 0, len);
                        pos = data.indexOf("filename=\"");
                        if (pos != -1) {
                            fileName = data.substring(pos + 10, data.lastIndexOf(34));
                            if (fileName.equals("")) {
                                throw new NullFileException();
                            }
                            String[] tmpArr = fileName.split("\\.");
                            String fileExtend = tmpArr[tmpArr.length - 1];
                            if (checker != null) {
                                if (!checker.isFileSizeValid(this.request.getContentLength())) {
                                    StringBuilder sb = new StringBuilder(100);
                                    sb.append(fileName).append("(").append(this.request.getContentLength() / 1024).append("K) is too big !");
                                    throw new FileSizeException(sb.toString(), fileName);
                                }
                                if (!checker.isFileExtendValid(fileExtend)) {
                                    throw new FileExtendException(String.valueOf(fileName) + " is an unvalid file \uff01", fileName);
                                }
                            }
                            body = new StringBuilder(1024);
                            len = in.readLine(buffer, 0, buffer.length);
                            status = 3;
                        } else {
                            pos = data.indexOf("name=\"");
                            fieldName = data.substring(pos + 6, data.lastIndexOf(34));
                            status = 2;
                        }
                        len = in.readLine(buffer, 0, buffer.length);
                        break;
                    }
                    case 3: {
                        if (ByteArray.startWith(buffer, this.dataBoundary)) {
                            status = 1;
                            break;
                        }
                        body.append(new String(buffer, 0, len, charset));
                        break;
                    }
                    case 2: {
                        if (ByteArray.startWith(buffer, this.dataBoundary)) {
                            status = 1;
                            break;
                        }
                        fieldValue = this.request.getCharacterEncoding() == null ? new String(buffer, 0, len) : new String(buffer, 0, len, this.request.getCharacterEncoding());
                        this.setAttribute(fieldName, fieldValue.trim());
                    }
                }
            }
        }
        catch (NullFileException ex) {
            throw ex;
        }
        catch (FileSizeException ex) {
            log.error((Object)ex.getMessage());
            throw ex;
        }
        catch (FileExtendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (DEBUG) {
            log.debug((Object)body);
        }
        return body.toString();
    }
}

