/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.entity;

public class DBColumn {
    private String name = "";
    private String dataType = "NaN";
    private int length = 0;
    private int precision = 0;
    private String defaultValue = "";
    private String keyType = "-";
    private String fKeyTableName = "";
    private boolean autoIncrement = false;
    private String comment = "";
    private String javaType = "NaN";

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.makeJavaType();
    }

    public String getJavaType() {
        if (this.javaType == null) {
            this.makeJavaType();
        }
        return this.javaType;
    }

    public void makeJavaType() {
        if (this.dataType == null) {
            this.javaType = "NaN";
            return;
        }
        if (this.dataType.indexOf("VARCHAR") != -1 || this.dataType.indexOf("TEXT") != -1 || this.dataType.indexOf("CHAR") != -1 || this.dataType.indexOf("CLOB") != -1) {
            this.javaType = "String";
            return;
        }
        if (this.dataType.indexOf("TINYINT") != -1 || this.dataType.indexOf("SMALLINT") != -1 || this.dataType.indexOf("MEDIUMINT") != -1) {
            this.javaType = "Integer";
            return;
        }
        if (this.dataType.indexOf("NUMBER") != -1 || this.dataType.indexOf("NUMERIC") != -1 || this.dataType.indexOf("DECIMAL") != -1 || this.dataType.indexOf("INT") != -1 || this.dataType.indexOf("SERIAL") != -1) {
            this.javaType = this.dataType.indexOf(",") != -1 ? "Double" : "Long";
            return;
        }
        if (this.dataType.indexOf("TIMESTAMP") != -1 || this.dataType.indexOf("DATE") != -1) {
            this.javaType = "Date";
        }
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString(String index) {
        StringBuilder strCol = new StringBuilder(100);
        strCol.append(" ---------- -------------------- -------- --------------- ------------- --------- -------------- -------------------- ------------- ----------------\n");
        strCol.append(" " + String.format("%-10s", index) + "|" + String.format("%-20s", this.name) + "|" + String.format("%-8s", this.javaType) + "|" + String.format("%-15s", this.dataType) + "|" + String.format("%-13s", this.length) + "|" + String.format("%-9s", this.precision) + "|" + String.format("%-14s", this.keyType) + "|" + String.format("%-20s", this.fKeyTableName) + "|" + String.format("%-13s", this.autoIncrement ? "T" : "") + "|" + String.format("%-13s", this.comment) + "\n");
        return strCol.toString();
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String getFKeyTableName() {
        return this.fKeyTableName;
    }

    public void setFKeyTableName(String keyTableName) {
        this.fKeyTableName = keyTableName;
    }
}

