/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.make;

import java.util.List;
import org.sysolar.mars.config.MarsContext;
import org.sysolar.mars.entity.DBColumn;
import org.sysolar.mars.entity.DBTable;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;

public class MakeDao {
    public static String createDAO(DBTable table, String packageName, MarsContext cts) {
        String className = NameUtil.getJavaNameBigFirst(table.getTableName());
        String classObj = NameUtil.getJavaNameSmallFirst(table.getTableName());
        StringBuilder sbCreateDAO = new StringBuilder(5000);
        sbCreateDAO.append("package " + packageName + ".dao;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("import java.sql.SQLException;").append(Constants.LS);
        sbCreateDAO.append("import java.util.List;").append(Constants.LS);
        sbCreateDAO.append("import " + packageName + ".entity." + className + ";").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("public interface " + className + "Dao {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * create: \u63d2\u5165\u65b0\u6570\u636e\u3002\u8fd4\u56de\u6570\u636eID\uff0c\u6216\u8005 null\u3002").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * ").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @param clickFrom \u5305\u542b\u6570\u636e\u7684\u5b9e\u4f53 Bean").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @param returnId \u662f\u5426\u8fd4\u56de\u65b0\u6570\u636eID\uff0ctrue-\u8fd4\u56de\uff0cfalse-\u4e0d\u8fd4\u56de").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @return").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @throws SQLException").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public Long create(").append(className).append(" ").append(classObj).append(", boolean returnId) throws SQLException;").append(Constants.LS);
        MakeDao.appendComments(sbCreateDAO, cts.getAuthor(), "delete", String.valueOf(classObj) + "Id");
        sbCreateDAO.append(Constants.BLANK_4).append("public boolean remove(Long " + classObj + "Id) throws SQLException;").append(Constants.LS);
        MakeDao.appendComments(sbCreateDAO, cts.getAuthor(), "fetch", String.valueOf(classObj) + "Id");
        sbCreateDAO.append(Constants.BLANK_4).append("public " + className + " fetch(Long " + classObj + "Id) throws SQLException;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * export: \u5bfc\u51fa\u6570\u636e\u3002").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" *").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @param offset \u504f\u79fb\u91cf\uff0c\u7b2c\u4e00\u6761\u6570\u636e\u7684\u504f\u79fb\u91cf\u4e3a0").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @param limit \u8bb0\u5f55\u6761\u6570").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @return").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @throws SQLException").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" */").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws SQLException;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("}");
        sbCreateDAO.append(Constants.LS);
        return sbCreateDAO.toString();
    }

    private static void appendComments(StringBuilder sbCreateDAO, String author, String method, String params) {
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("/**").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * " + method).append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * ").append(Constants.LS);
        if (params != null) {
            sbCreateDAO.append(Constants.BLANK_4).append(" * @param " + params).append(Constants.LS);
        }
        sbCreateDAO.append(Constants.BLANK_4).append(" * @return ").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * ").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" * @author " + author).append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append(" */").append(Constants.LS);
    }

    public static String createDAOImpl(DBTable table, String packageName, MarsContext cts) {
        String className = NameUtil.getJavaNameBigFirst(table.getTableName());
        String classObj = NameUtil.getJavaNameSmallFirst(table.getTableName());
        StringBuilder sbCreateDAO = new StringBuilder(5000);
        sbCreateDAO.append("package " + packageName + ".daoimpl;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("import java.sql.SQLException;").append(Constants.LS);
        sbCreateDAO.append("import java.util.ArrayList;").append(Constants.LS);
        sbCreateDAO.append("import java.util.List;").append(Constants.LS);
        sbCreateDAO.append("import java.util.Map;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("import org.sysolar.sun.config.AppContext;").append(Constants.LS);
        sbCreateDAO.append("import org.sysolar.sun.jdbc.core.JdbcOperations;").append(Constants.LS);
        sbCreateDAO.append("import " + packageName + ".entity." + className + ";").append(Constants.LS);
        sbCreateDAO.append("import " + packageName + ".constant.Sql;").append(Constants.LS);
        sbCreateDAO.append("import " + packageName + ".dao." + className + "Dao;").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append("public final class " + className + "DaoImpl implements " + className + "Dao {").append(Constants.LS);
        sbCreateDAO.append("private static JdbcOperations dao = AppContext.getJdbcOperations(" + className + "DaoImpl.class);").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public Long create(").append(className).append(" ").append(classObj).append(", boolean returnId) throws SQLException {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("dao.update(Sql.").append(className).append("Sql.create, ").append(MakeDao.makeObjGetMethod(classObj, table.getColList())).append(");").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("if(returnId) {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_12).append("return dao.queryForLong(Sql.GenericSql.fetchLastInsertId);").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("return null;").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public boolean remove(Long " + classObj + "Id) throws SQLException{").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("return dao.update(Sql." + className + "Sql.remove, " + classObj + "Id) > 0;").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public " + className + " fetch(Long " + classObj + "Id) throws SQLException{").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("for(Map<String, Object> row : dao.queryForList(Sql." + className + "Sql.fetch, " + classObj + "Id)) {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_12).append("return new " + className + "().fill(row);").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("return null;").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws SQLException {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("List<").append(className).append("> list = new ArrayList<").append(className).append(">(limit);").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("for(Map<String, Object> row : dao.queryForList(Sql.").append(className).append("Sql.export, offset, limit)) {").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_12).append("list.add(new ").append(className).append("().fill(row));").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("}").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_8).append("return list;").append(Constants.LS);
        sbCreateDAO.append(Constants.BLANK_4).append("}").append(Constants.LS);
        sbCreateDAO.append("}");
        sbCreateDAO.append(Constants.LS);
        return sbCreateDAO.toString();
    }

    private static String makeObjGetMethod(String classObj, List<DBColumn> colList) {
        StringBuilder objGetMethod = new StringBuilder(200);
        if (colList.size() > 0) {
            for (DBColumn col : colList) {
                String fieldNameForMethod = NameUtil.getJavaNameBigFirst(col.getName());
                objGetMethod.append(String.valueOf(classObj) + ".get" + fieldNameForMethod + "(),");
            }
            objGetMethod.deleteCharAt(objGetMethod.length() - 1);
        }
        return objGetMethod.toString();
    }
}

