/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sysolar.sun.cache.Cache;

public final class CacheMap<K, V>
extends Cache
implements Map<K, V> {
    private Map<K, V> map = null;

    public CacheMap(int cacheInterval) {
        this(cacheInterval, null);
    }

    public CacheMap(int cacheInterval, Integer cacheSize) {
        this.cacheInterval = cacheInterval;
        if (cacheSize != null) {
            this.cacheSize = cacheSize;
            this.map = new HashMap(cacheSize);
        } else {
            this.map = new HashMap(100);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.cacheBeginTime = System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() - this.cacheBeginTime >= (long)this.cacheInterval || this.cacheSize != null && this.map.size() > this.cacheSize;
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.map.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

