/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.config;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.sysolar.sun.jdbc.core.JdbcOperations;
import org.sysolar.sun.jdbc.core.JdbcOperationsDerbyImpl;
import org.sysolar.sun.jdbc.core.JdbcOperationsMysqlImpl;
import org.sysolar.sun.jdbc.core.JdbcOperationsOracleImpl;
import org.sysolar.sun.jdbc.support.DatabaseTypes;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.util.Constants;

public final class AppContext {
    private static Log log = LogFactory.getLog(AppContext.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final String CONFIG_FILE_NAME = "sysolar.config.xml";
    private static String appRootPath;
    private static Map<String, String> valueMap;
    private static Map<String, String> actionClassMap;
    private static Map<String, BaseAction> actionMap;
    private static DatabaseTypes databaseType;
    private static String dataSourceName;
    private static String characterEncoding;

    static {
        valueMap = new HashMap<String, String>(50);
        actionClassMap = new HashMap<String, String>(50);
        actionMap = new HashMap<String, BaseAction>(50);
    }

    public static JdbcOperations getJdbcOperations(Class<?> theClass) {
        return AppContext.getJdbcOperations(theClass.getName());
    }

    public static File getAppRoot() {
        String path = null;
        try {
            path = ClassLoader.getSystemResource("").toURI().getPath();
        }
        catch (URISyntaxException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)path);
        File dir = new File(path);
        if (path.contains("bin")) {
            return dir.getParentFile();
        }
        if (path.contains("WEB-INF")) {
            return dir.getParentFile().getParentFile().getParentFile();
        }
        if (path.contains("lib")) {
            return dir.getParentFile();
        }
        return dir;
    }

    public static JdbcOperations getJdbcOperations(String logName) {
        switch (databaseType) {
            case ORACLE: {
                return new JdbcOperationsOracleImpl(logName);
            }
            case MYSQL: {
                return new JdbcOperationsMysqlImpl(logName);
            }
            case DERBY: {
                return new JdbcOperationsDerbyImpl(logName);
            }
        }
        return null;
    }

    public static DatabaseTypes getDatabaseType() {
        return databaseType;
    }

    public static BaseAction getAction(String path) {
        return actionMap.get(path);
    }

    public static String getCharacterEncoding() {
        return characterEncoding;
    }

    public static String getDataSourceName() {
        return dataSourceName;
    }

    public static String getAppRootPath() {
        return appRootPath;
    }

    public static String getValue(String key) {
        return valueMap.get(key);
    }

    public static Integer getInt(String key) {
        String value = valueMap.get(key);
        return value == null ? null : Integer.valueOf(value);
    }

    public static void configure(String appPath) {
        appRootPath = appPath;
        if (DEBUG) {
            log.debug((Object)("appRootPath=" + appRootPath));
        }
        StringBuilder configFile = new StringBuilder(100);
        configFile.append(appRootPath).append("WEB-INF").append(Constants.FS).append("classes").append(Constants.FS).append(CONFIG_FILE_NAME).toString();
        if (DEBUG) {
            log.debug((Object)("configFile=" + configFile));
        }
        AppContext.doMainConfigure(configFile.toString());
        AppContext.doFinalConfigure();
    }

    public static void doWebAppConfig() {
    }

    public static void doLocalAppConfig() {
        File configFile = new File(new File(AppContext.getAppRoot(), "config"), CONFIG_FILE_NAME);
        AppContext.doMainConfigure(configFile.getAbsolutePath());
    }

    private static void doMainConfigure(String configFile) {
        try {
            File coyouJFConfigFile = new File(configFile);
            Document doc = new SAXReader().read(coyouJFConfigFile);
            Iterator i1 = doc.getRootElement().elementIterator();
            while (i1.hasNext()) {
                Element e3;
                Iterator i2;
                Element e2 = (Element)i1.next();
                if ("action-mappings".equals(e2.getName())) {
                    i2 = e2.elementIterator();
                    while (i2.hasNext()) {
                        e3 = (Element)i2.next();
                        actionClassMap.put(e3.attributeValue("path"), e3.attributeValue("class"));
                    }
                    log.debug(actionClassMap);
                    continue;
                }
                if ("character-encoding".equals(e2.getName())) {
                    i2 = e2.elementIterator();
                    while (i2.hasNext()) {
                        e3 = (Element)i2.next();
                        if (!"post".equals(e3.getName())) continue;
                        characterEncoding = e3.getText();
                    }
                    log.debug((Object)("characterEncoding=" + characterEncoding));
                    continue;
                }
                if ("database".equals(e2.getName())) {
                    i2 = e2.elementIterator();
                    while (i2.hasNext()) {
                        e3 = (Element)i2.next();
                        if ("data-source-name".equals(e3.getName())) {
                            dataSourceName = e3.getText();
                            continue;
                        }
                        if (!"database-type".equals(e3.getName())) continue;
                        String type = e3.getText();
                        databaseType = type.equalsIgnoreCase("oracle") ? DatabaseTypes.ORACLE : (type.equalsIgnoreCase("mysql") ? DatabaseTypes.MYSQL : (type.equalsIgnoreCase("derby") ? DatabaseTypes.DERBY : null));
                    }
                    log.debug((Object)("databaseType=" + (Object)((Object)databaseType)));
                    log.debug((Object)("dataSourceName=" + dataSourceName));
                    continue;
                }
                if (!"values".equals(e2.getName())) continue;
                i2 = e2.elementIterator();
                while (i2.hasNext()) {
                    e3 = (Element)i2.next();
                    valueMap.put(e3.attributeValue("key"), e3.getText());
                }
                log.debug(valueMap);
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
    }

    private static void doFinalConfigure() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (Map.Entry<String, String> entry : actionClassMap.entrySet()) {
            try {
                actionMap.put(entry.getKey(), (BaseAction)loader.loadClass(entry.getValue()).newInstance());
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
        }
        log.debug(actionMap);
    }

    public static void main(String[] args) {
        System.out.println(AppContext.getAppRoot());
    }
}

