/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.DataSourceFactory;
import org.sysolar.sun.jdbc.core.JdbcOperationsAbstract;
import org.sysolar.sun.jdbc.support.DBHelper;

public class JdbcOperationsDerbyImpl
extends JdbcOperationsAbstract {
    private DataSource dataSource = DataSourceFactory.getDataSource(AppContext.getDataSourceName());

    public JdbcOperationsDerbyImpl(String logName) {
        super(logName);
    }

    @Override
    public List<Map<String, Object>> callForList(Connection conn, String procName, Object ... params) throws SQLException {
        return null;
    }

    @Override
    public List<Map<String, Object>> callForList(String procName, Object ... params) throws SQLException {
        return this.callForList(null, procName, params);
    }

    @Override
    public int update(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            int n = super.update(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public void update(String sql, List<Object[]> params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            super.update(conn, sql, params);
        }
        catch (Throwable throwable) {
            DBHelper.close(conn);
            throw throwable;
        }
        DBHelper.close(conn);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            List<Map<String, Object>> list = super.queryForList(conn, sql, params);
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public String queryForString(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            String string = super.queryForString(conn, sql, params);
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public int queryForInt(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            int n = super.queryForInt(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public long queryForLong(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            long l = super.queryForNumber(conn, sql, params).longValue();
            return l;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public Object queryForObject(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            Object object = super.queryForObject(conn, sql, params);
            return object;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DBHelper.close(conn);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

