/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.core;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.DataSourceFactory;

public final class Transactions {
    private static ThreadLocal<Connection> threadLocalData = new ThreadLocal();
    private static final DataSource dataSource;
    private static final Log log;
    private static final boolean bDebug;
    private static int connCount;

    static {
        connCount = 0;
        dataSource = DataSourceFactory.getDataSource(AppContext.getDataSourceName());
        log = LogFactory.getLog(Transactions.class);
        bDebug = log.isDebugEnabled();
    }

    public static Connection getConnection() throws SQLException {
        return Transactions.getConnection(true);
    }

    private static Connection getConnection(boolean validate) throws SQLException {
        Connection conn = threadLocalData.get();
        if (validate && conn == null) {
            conn = dataSource.getConnection();
            conn.setAutoCommit(true);
            threadLocalData.set(conn);
            ++connCount;
            if (bDebug) {
                log.debug((Object)("open=" + conn + ", connCount=" + connCount));
            }
        }
        return conn;
    }

    public static void beginTransaction() throws SQLException {
        Transactions.getConnection(true).setAutoCommit(false);
    }

    public static void commit() throws SQLException {
        Connection conn = Transactions.getConnection(false);
        if (conn != null) {
            conn.commit();
        }
    }

    public static void rollback() throws SQLException {
        Connection conn = Transactions.getConnection(false);
        if (conn != null) {
            conn.rollback();
        }
    }

    public static void close() throws SQLException {
        Connection conn = Transactions.getConnection(false);
        if (conn != null) {
            try {
                String connName = conn.toString();
                conn.close();
                --connCount;
                if (bDebug) {
                    log.debug((Object)("drop=" + connName + ", connCount=" + connCount));
                }
            }
            finally {
                threadLocalData.set(null);
            }
        }
    }

    public static int getConnectionCount() {
        return connCount;
    }
}

