/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.support;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DBHelper {
    private static final Log log = LogFactory.getLog(DBHelper.class);

    public static void close(Connection conn) {
        DBHelper.close(conn, null, null);
    }

    public static void close(Connection conn, Statement stmt) {
        DBHelper.close(conn, stmt, null);
    }

    public static void close(Statement stmt) {
        DBHelper.close(null, stmt, null);
    }

    public static void close(Statement stmt, ResultSet rs) {
        DBHelper.close(null, stmt, rs);
    }

    public static void close(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        if (conn != null) {
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
    }

    public static void closeDerby() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("XJ015")) {
                log.info((Object)"Database shut down normally");
            }
            log.info((Object)"Database did not shut down normally");
        }
    }
}

