/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.mvc.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.Transactions;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.RequestWrapper;

public final class ActionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ActionServlet.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public void init() throws ServletException {
        AppContext.configure(this.getServletContext().getRealPath("/"));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestWrapper wrapper = new RequestWrapper((ServletRequest)request);
        HttpSession session = request.getSession();
        String target = null;
        BaseAction action = null;
        ActionForward forward = null;
        try {
            target = request.getServletPath();
            action = AppContext.getAction(target);
            forward = action.doAction(request, response, session, wrapper);
            if (DEBUG) {
                log.debug((Object)this.buildString(request, target, wrapper, forward));
            }
            switch (forward.getRespType()) {
                case 1: {
                    response.setBufferSize(forward.getResp().length());
                    response.setCharacterEncoding(AppContext.getCharacterEncoding());
                    response.getWriter().print(forward.getResp());
                    break;
                }
                case 3: {
                    response.sendRedirect(forward.getResp());
                    break;
                }
                case 2: {
                    this.getServletContext().getRequestDispatcher(forward.getResp()).forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)this.buildString(request, target, wrapper, forward), t);
            throw new ServletException(t);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(AppContext.getCharacterEncoding());
        this.doGet(request, response);
    }

    private String buildString(HttpServletRequest request, String target, RequestWrapper wrapper, ActionForward forward) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("sid=").append(request.getSession());
        sb.append(", ip=").append(request.getRemoteAddr());
        sb.append(", connCount=").append(Transactions.getConnectionCount());
        sb.append(", servletPath=").append(request.getServletPath());
        sb.append(", target=").append(target);
        sb.append(", params=").append(wrapper.toString());
        sb.append(", forward=").append(forward);
        return sb.toString();
    }
}

