/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.mvc.support;

import java.util.List;

public final class PagerBak<T> {
    private int pageNum;
    private int pageSize;
    private int beginIndex;
    private int endIndex;
    private int offset;
    private List<T> list;
    private int totalNum;
    private Integer limit;
    private int totalPageNum;
    private boolean isFirstPage;
    private boolean isFinalPage;

    public PagerBak(int pageNum, int pageSize) {
        this(pageNum, pageSize, null);
    }

    public PagerBak(int pageNum, int pageSize, Integer limit) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.limit = limit;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.endIndex = this.beginIndex + pageSize - 1;
        this.offset = (pageNum - 1) * pageSize;
    }

    public PagerBak<T> fill(int totalNum, List<T> list) {
        this.totalNum = totalNum;
        this.list = list;
        this.calculate();
        return this;
    }

    private void calculate() {
        int iTemp;
        if (this.totalNum == 0) {
            this.totalPageNum = 0;
            this.isFirstPage = true;
            this.isFinalPage = true;
            return;
        }
        if (this.limit != null && this.totalNum > this.limit) {
            this.totalNum = this.limit;
        }
        int n = this.totalPageNum = (iTemp = this.totalNum % this.pageSize) == 0 ? this.totalNum / this.pageSize : this.totalNum / this.pageSize + 1;
        if (this.pageNum == 1) {
            this.isFirstPage = true;
        }
        if (this.pageNum == this.totalPageNum) {
            this.isFinalPage = true;
        }
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public void setTotalNum(int totalNum) {
        this.totalNum = totalNum;
    }

    public int getTotalPageNum() {
        return this.totalPageNum;
    }

    public void setTotalPageNum(int totalPageNum) {
        this.totalPageNum = totalPageNum;
    }

    public boolean getIsFinalPage() {
        return this.isFinalPage;
    }

    public void setIsFinalPage(boolean isFinalPage) {
        this.isFinalPage = isFinalPage;
    }

    public boolean getIsFirstPage() {
        return this.isFirstPage;
    }

    public void setIsFirstPage(boolean isFirstPage) {
        this.isFirstPage = isFirstPage;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

