/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Task {
    protected static final Log log = LogFactory.getLog(Task.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected long lastStartTime = System.currentTimeMillis();
    protected Integer point = null;
    protected int cycle = 0;

    public abstract void execute() throws Exception;

    public abstract void work() throws Exception;

    public boolean isCycle() {
        if (this.cycle == 0) {
            return true;
        }
        int currentTime = (int)(System.currentTimeMillis() / 60000L);
        return currentTime - (int)(this.lastStartTime / 60000L) >= this.cycle;
    }

    public boolean isPoint() {
        if (this.point == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        Integer hourOfDay = now.get(11);
        Integer minOfHour = now.get(12);
        return hourOfDay.equals(this.point) && minOfHour == 0;
    }

    public boolean isStart() {
        return this.isCycle() && this.isPoint();
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    public void setLastStartTime(long lastStartTime) {
        this.lastStartTime = lastStartTime;
    }

    public boolean isLast() {
        return true;
    }
}

