/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.threadpool.Task;

public class TaskQueue {
    private List<Task> queue = new LinkedList<Task>();
    private static final Log log = LogFactory.getLog(TaskQueue.class);
    private boolean isWait = false;

    public synchronized Task getTask() {
        while (this.queue.size() == 0 || this.isWait) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                log.error((Object)ie.getMessage(), (Throwable)ie);
                return null;
            }
        }
        return this.queue.remove(0);
    }

    public synchronized void putTask(Task task) {
        this.queue.add(task);
        this.notifyAll();
    }

    public int getTaskNum() {
        return this.queue.size();
    }

    public void setWait(boolean isWait) {
        this.isWait = isWait;
    }

    public boolean isWait() {
        return this.isWait;
    }

    public void removeAllTask() {
        this.queue.clear();
    }
}

