/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.sysolar.threadpool.Task;
import org.sysolar.threadpool.TaskQueue;
import org.sysolar.threadpool.WorkerThread;

public class ThreadPool {
    private List<Thread> threads = new LinkedList<Thread>();
    private TaskQueue queue;
    private Date beginTime = null;

    public ThreadPool(int threadNum) {
        this.queue = new TaskQueue();
        int i = 0;
        while (i < threadNum) {
            this.addWorkerThread();
            ++i;
        }
        this.beginTime = new Date();
    }

    public ThreadPool(int threadNum, TaskQueue queue) {
        this.queue = queue;
        int i = 0;
        while (i < threadNum) {
            this.addWorkerThread();
            ++i;
        }
    }

    public synchronized void addWorkerThread() {
        WorkerThread t = new WorkerThread(this.queue);
        this.threads.add(t);
        t.start();
    }

    public synchronized void removeWorkerThread() {
        if (this.threads.size() > 0) {
            WorkerThread t = (WorkerThread)this.threads.remove(0);
            t.shutdown();
        }
    }

    public synchronized void removeAllThread() {
        while (this.threads.size() > 0) {
            WorkerThread t = (WorkerThread)this.threads.remove(0);
            t.shutdown();
        }
    }

    public synchronized String currentStatus() {
        StringBuilder sb = new StringBuilder("Thread count = ");
        sb.append(this.threads.size());
        for (WorkerThread workerThread : this.threads) {
            sb.append(String.valueOf(workerThread.getName()) + ": " + (workerThread.isIdle() ? "idle" : "busy"));
        }
        return sb.toString();
    }

    public synchronized void putTask(Task task) {
        this.queue.putTask(task);
    }

    public int getTaskNum() {
        return this.queue.getTaskNum();
    }

    public int getThreadNum() {
        return this.threads.size();
    }

    public void waitThreads() {
        this.queue.setWait(true);
    }

    public void unWaitThreads() {
        this.queue.setWait(false);
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void poolValue(int limitTaskNum) {
        while (this.getTaskNum() >= limitTaskNum) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void poolValue() {
        this.poolValue(this.getThreadNum());
    }

    public void removeAllTask() {
        this.queue.removeAllTask();
    }
}

