/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.util.Constants;

public final class FileIO {
    private static final Log log = LogFactory.getLog(FileIO.class);

    public static File createFile(String path) throws IOException {
        File file = new File(path);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static File createFile(String root, String fileName) throws IOException {
        return FileIO.createFile(new File(root), fileName);
    }

    public static File createFile(File root, String fileName) throws IOException {
        File file;
        if (!root.exists()) {
            root.mkdirs();
        }
        if (!(file = new File(root, fileName)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static File createDir(String root, String dirName) throws IOException {
        return FileIO.createDir(new File(root), dirName);
    }

    public static File createDir(File root, String dirName) throws IOException {
        File file;
        if (!root.exists()) {
            root.mkdirs();
        }
        if (!(file = new File(root, dirName)).exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File createTodyDir(String root) throws IOException {
        return FileIO.createDir(root, new SimpleDateFormat("yyyyMMdd").format(new Date()));
    }

    public static int getFileSize(File file) {
        int size;
        block6: {
            if (!file.exists()) {
                return -1;
            }
            size = -1;
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    size = in.available();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    FileIO.close(in);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileIO.close(in);
                throw throwable;
            }
            FileIO.close(in);
        }
        return size;
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File[] listDirs(File pathname) {
        if (!pathname.exists() || !pathname.isDirectory()) {
            System.err.println(pathname + " is not a directory.");
            return new File[0];
        }
        return pathname.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.isHidden();
            }
        });
    }

    public static File[] listDirs(String pathname) {
        return FileIO.listDirs(new File(pathname));
    }

    public static File[] listFiles(File pathname) {
        if (!pathname.exists() || !pathname.isDirectory()) {
            System.err.println(pathname + " is not a directory.");
            return new File[0];
        }
        return pathname.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && !file.isHidden();
            }
        });
    }

    public static File[] listFiles(String pathname) {
        return FileIO.listFiles(new File(pathname));
    }

    public static List<File> listDirsSubdirs(File pathname) {
        if (!pathname.exists() || !pathname.isDirectory()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> dirsSubdirs = new ArrayList<File>(50);
        ArrayList<File> curLoop = new ArrayList<File>(20);
        ArrayList<File> nextLoop = new ArrayList<File>(20);
        curLoop.addAll(Arrays.asList(FileIO.listDirs(pathname)));
        while (!curLoop.isEmpty()) {
            for (File dir : curLoop) {
                nextLoop.addAll(Arrays.asList(FileIO.listDirs(dir)));
            }
            dirsSubdirs.addAll(curLoop);
            curLoop.clear();
            curLoop.addAll(nextLoop);
            nextLoop.clear();
        }
        Collections.sort(dirsSubdirs);
        return dirsSubdirs;
    }

    public static List<File> listDirsSubdirs(String pathname) {
        return FileIO.listDirsSubdirs(new File(pathname));
    }

    public static List<File> listFilesInDirSubdirs(File pathname) {
        if (!pathname.exists() || !pathname.isDirectory()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> files = new ArrayList<File>(200);
        ArrayList<File> dirsSubdirs = new ArrayList<File>(50);
        dirsSubdirs.add(pathname);
        dirsSubdirs.addAll(FileIO.listDirsSubdirs(pathname));
        for (File dir : dirsSubdirs) {
            files.addAll(Arrays.asList(FileIO.listFiles(dir)));
        }
        Collections.sort(files);
        return files;
    }

    public static List<File> listFilesInDirSubdirs(String dirPath) {
        return FileIO.listFilesInDirSubdirs(new File(dirPath));
    }

    public static boolean changeFileEnc(String filePath, String oldEnc, String newEnc) {
        return FileIO.changeFileEnc(new File(filePath), oldEnc, newEnc);
    }

    public static boolean changeFileEnc(File file, String oldEnc, String newEnc) {
        return FileIO.writeToFile(file, FileIO.readAsString(file, oldEnc), false, newEnc);
    }

    public static boolean changeFileEncFromDir(String dir, String oldEnc, String newEnc) {
        return FileIO.changeFileEncFromDir(new File(dir), oldEnc, newEnc);
    }

    public static boolean changeFileEncFromDir(File dir, String oldEnc, String newEnc) {
        for (File file : FileIO.listFilesInDirSubdirs(dir)) {
            if (FileIO.changeFileEnc(file, oldEnc, newEnc)) continue;
            return false;
        }
        return true;
    }

    public static byte[] read(String filePath) {
        return FileIO.read(new File(filePath));
    }

    public static byte[] read(File file) {
        byte[] resultBuffer;
        block15: {
            if (!file.exists()) {
                return null;
            }
            resultBuffer = null;
            byte[] tempBuffer = null;
            byte[] lastBuffer = null;
            long size = file.length();
            tempBuffer = size < 8192L ? new byte[(int)size] : new byte[8192];
            BufferedInputStream in = null;
            try {
                try {
                    int len;
                    in = new BufferedInputStream(new FileInputStream(file));
                    while (-1 != (len = in.read(tempBuffer))) {
                        if (resultBuffer == null) {
                            resultBuffer = new byte[len];
                            System.arraycopy(tempBuffer, 0, resultBuffer, 0, len);
                            continue;
                        }
                        lastBuffer = resultBuffer;
                        resultBuffer = new byte[resultBuffer.length + len];
                        System.arraycopy(lastBuffer, 0, resultBuffer, 0, lastBuffer.length);
                        System.arraycopy(tempBuffer, 0, resultBuffer, lastBuffer.length, len);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resultBuffer;
    }

    public static String readAsString(String filePath, String ... enc) {
        return FileIO.readAsString(new File(filePath), enc);
    }

    public static String readAsString(File file, String ... enc) {
        StringBuilder buffer;
        block15: {
            buffer = new StringBuilder(1000);
            BufferedReader in = null;
            try {
                try {
                    in = enc != null && enc.length > 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), enc[0])) : new BufferedReader(new FileReader(file));
                    String oneLine = null;
                    while ((oneLine = in.readLine()) != null) {
                        buffer.append(oneLine).append(Constants.LS);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buffer.toString();
    }

    public static List<String> readAsList(String filePath, String ... enc) {
        return FileIO.readAsList(new File(filePath), enc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> readAsList(File file, String ... enc) {
        ArrayList<String> contentList = new ArrayList<String>();
        BufferedReader in = null;
        try {
            try {
                in = enc != null && enc.length > 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), enc[0])) : new BufferedReader(new FileReader(file));
                String oneLine = null;
                while ((oneLine = in.readLine()) != null) {
                    contentList.add(oneLine);
                }
                return contentList;
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (in == null) return contentList;
                try {
                    in.close();
                    return contentList;
                }
                catch (IOException iOException) {}
                return contentList;
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (in == null) return contentList;
                try {
                    in.close();
                    return contentList;
                }
                catch (IOException iOException) {}
                return contentList;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Map<String, String> readToMap(String path, String enc) {
        HashMap<String, String> map;
        block6: {
            BufferedReader in = null;
            map = new HashMap<String, String>();
            String msg = null;
            try {
                try {
                    FileInputStream is = new FileInputStream(path);
                    in = new BufferedReader(new InputStreamReader((InputStream)is, enc));
                    String[] entry = null;
                    while ((msg = in.readLine()) != null) {
                        if ("".equals(msg.trim())) continue;
                        entry = msg.split("[:=]", 2);
                        map.put(entry[0], entry[1]);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    FileIO.close(in);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileIO.close(in);
                throw throwable;
            }
            FileIO.close(in);
        }
        return map;
    }

    public static boolean writeToFile(String filePath, String content, boolean append, String enc) {
        return FileIO.writeToFile(new File(filePath), content, append, enc);
    }

    public static boolean writeToFile(File file, String content, boolean append, String enc) {
        boolean result;
        block8: {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(">>> make directories..." + parent.getAbsolutePath()));
                }
                parent.mkdirs();
            }
            result = true;
            BufferedWriter out = null;
            try {
                try {
                    out = enc != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), enc)) : new BufferedWriter(new FileWriter(file, append));
                    out.write(content);
                    out.flush();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("save success..." + file.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    result = false;
                    FileIO.close(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileIO.close(out);
                throw throwable;
            }
            FileIO.close(out);
        }
        return result;
    }

    public static boolean writeToFile(String path, Map<String, String> map, String enc) {
        StringBuilder content = new StringBuilder(1024);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            content.append(entry.getKey()).append(":").append(entry.getValue()).append(Constants.LS);
        }
        return FileIO.writeToFile(path, content.toString(), true, enc);
    }

    public static boolean write(String destFile, Collection<?> c, boolean append, String enc) {
        return FileIO.write(new File(destFile), c, append, enc);
    }

    public static boolean write(File destFile, Collection<?> c, boolean append, String enc) {
        File parent = destFile.getParentFile();
        if (!parent.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(">>> make directories..." + parent.getAbsolutePath()));
            }
            parent.mkdirs();
        }
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile, append), enc));
                for (Object obj : c) {
                    out.write(obj.toString());
                    out.newLine();
                }
                out.flush();
                if (log.isInfoEnabled()) {
                    log.info((Object)("save success..." + destFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                FileIO.close(out);
                return false;
            }
        }
        catch (Throwable throwable) {
            FileIO.close(out);
            throw throwable;
        }
        FileIO.close(out);
        return true;
    }

    public static void main(String[] args) throws Exception {
        FileIO.read("E:\\temp\\temp.gif");
    }
}

