/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.util.file.FileIsDirIsHiddenFilter;

public final class FileManager {
    private static final Log log = LogFactory.getLog(FileManager.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public static File[] listDirs(File dir, Boolean isHidden) {
        return FileManager.listChildren(dir, true, isHidden);
    }

    public static File[] listFiles(File dir, Boolean isHidden) {
        return FileManager.listChildren(dir, false, isHidden);
    }

    private static File[] listChildren(File dir, boolean isDir, Boolean isHidden) {
        if (DEBUG) {
            log.debug((Object)("dir=" + dir + "; isDir=" + isDir + "; isHidden=" + isHidden));
        }
        if (dir == null || !dir.isDirectory()) {
            log.error((Object)(dir + "is not a directory !"));
            return null;
        }
        File[] dirArray = dir.listFiles(new FileIsDirIsHiddenFilter(isDir, isHidden));
        if (DEBUG) {
            File[] fileArray = dirArray;
            int n = dirArray.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                log.debug((Object)d);
                ++n2;
            }
        }
        return dirArray;
    }

    public static List<File> listDescendDirs(File dir, Boolean isHidden) {
        return FileManager.listDescendants(dir, true, isHidden);
    }

    public static List<File> listDescendFiles(File dir, Boolean isHidden) {
        return FileManager.listDescendants(dir, false, isHidden);
    }

    private static List<File> listDescendants(File dir, boolean isDir, Boolean isHidden) {
        if (dir == null || !dir.isDirectory()) {
            log.error((Object)(dir + "is not a directory !"));
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(100);
        FileManager.listDescendants(dir, new FileIsDirIsHiddenFilter(isDir, isHidden), fileList);
        if (DEBUG) {
            for (File f : fileList) {
                log.debug((Object)f);
            }
        }
        return fileList;
    }

    private static void listDescendants(File dir, FileFilter filter, List<File> fileList) {
        File[] fileArray = dir.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (filter.accept(fileArray[i])) {
                fileList.add(fileArray[i]);
            }
            if (fileArray[i].isDirectory()) {
                FileManager.listDescendants(fileArray[i], filter, fileList);
            }
            ++i;
        }
    }

    public static boolean copyDir(File srcDir, File destDir) {
        if (srcDir == null || !srcDir.exists() || !srcDir.isDirectory()) {
            log.error((Object)("srcDir(" + srcDir + ") is invalid !"));
            return false;
        }
        if (srcDir.equals(destDir)) {
            log.error((Object)("srcDir(" + srcDir + ") is the same as destDir(" + destDir + ") !"));
            return false;
        }
        List<File> fileList = FileManager.listDescendFiles(srcDir, null);
        File path = null;
        for (File file : fileList) {
            if (FileManager.copyFile(file, path = new File(file.getParent().replace(srcDir.getAbsolutePath(), destDir.getAbsolutePath())))) continue;
            return false;
        }
        return true;
    }

    public static boolean copyFile(File srcFile, File destDir) {
        int len;
        byte[] buffer;
        FilterOutputStream out;
        BufferedInputStream in;
        File destFile;
        block31: {
            block32: {
                if (srcFile == null || !srcFile.isFile()) {
                    log.error((Object)("srcFile(" + srcFile + ") is invalid !"));
                    return false;
                }
                destFile = null;
                in = null;
                out = null;
                buffer = new byte[1024];
                len = -1;
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                if (!srcFile.getParentFile().equals(destDir)) break block31;
                log.error((Object)("srcFile(" + srcFile + ") is also in destDir(" + destDir + ") !"));
                if (in == null) break block32;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        try {
            try {
                destFile = new File(destDir, srcFile.getName());
                in = new BufferedInputStream(new FileInputStream(srcFile));
                out = new BufferedOutputStream(new FileOutputStream(destFile));
                while ((len = in.read(buffer)) != -1) {
                    ((BufferedOutputStream)out).write(buffer, 0, len);
                }
                ((BufferedOutputStream)out).flush();
            }
            catch (Exception ex) {
                log.error((Object)("error: srcFile=" + srcFile + " --> destFile=" + destFile), (Throwable)ex);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (DEBUG) {
            log.debug((Object)("succeeded: srcFile=" + srcFile + " --> destFile=" + destFile));
        }
        return true;
    }

    public static boolean clearDirs(File srcDir, Boolean isHidden) {
        if (srcDir == null || !srcDir.exists() || !srcDir.isDirectory()) {
            log.error((Object)("srcDir(" + srcDir + ") is invalid !"));
            return false;
        }
        File[] fileArray = FileManager.listDirs(srcDir, isHidden);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File d = fileArray[n2];
            for (File f : FileManager.listDescendFiles(d, null)) {
                if (!f.delete()) {
                    log.error((Object)("Failed in deteting file(" + f + ") !"));
                    return false;
                }
                if (!DEBUG) continue;
                log.debug((Object)("Succeeded in deteting file(" + f + ") !"));
            }
            List<File> subDirList = FileManager.listDescendDirs(d, null);
            Collections.sort(subDirList);
            int i = subDirList.size() - 1;
            while (i >= 0) {
                if (!subDirList.get(i).delete()) {
                    log.error((Object)("Failed in deteting dir(" + subDirList.get(i) + ") !"));
                    return false;
                }
                if (DEBUG) {
                    log.debug((Object)("Succeeded in deteting dir(" + subDirList.get(i) + ") !"));
                }
                --i;
            }
            if (!d.delete()) {
                log.error((Object)("Failed in deteting dir(" + d + ") !"));
                return false;
            }
            if (DEBUG) {
                log.debug((Object)("Succeeded in deteting dir(" + d + ") !"));
            }
            ++n2;
        }
        if (DEBUG) {
            log.debug((Object)("succeeded: srcDir=" + srcDir + "; isHidden=" + isHidden));
        }
        return true;
    }

    public static boolean clearFiles(File srcDir, Boolean isHidden) {
        if (srcDir == null || !srcDir.exists() || !srcDir.isDirectory()) {
            log.error((Object)("srcDir(" + srcDir + ") is invalid !"));
            return false;
        }
        File[] fileArray = FileManager.listFiles(srcDir, isHidden);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.delete()) {
                log.error((Object)("Failed in deteting file(" + f + ") !"));
                return false;
            }
            if (DEBUG) {
                log.debug((Object)("Succeeded in deteting file(" + f + ") !"));
            }
            ++n2;
        }
        if (DEBUG) {
            log.debug((Object)("succeeded: dir=" + srcDir + "; isHidden=" + isHidden));
        }
        return true;
    }

    public static boolean deleteDir(File srcDir) {
        if (srcDir == null) {
            log.error((Object)("srcDir(" + srcDir + ") is null !"));
            return false;
        }
        if (!srcDir.exists()) {
            log.error((Object)("srcDir(" + srcDir + ") does not exist !"));
            return true;
        }
        if (!srcDir.isDirectory()) {
            log.error((Object)("srcDir(" + srcDir + ") is not a directory !"));
            return true;
        }
        if (!(FileManager.clearFiles(srcDir, null) && FileManager.clearDirs(srcDir, null) && srcDir.delete())) {
            return false;
        }
        if (DEBUG) {
            log.debug((Object)("succeeded: dir=" + srcDir));
        }
        return true;
    }

    public static void main(String[] args) {
        File file = new File("E:\\FileUpload");
        FileManager.deleteDir(file);
        System.out.println(Arrays.asList("E:/temp/\u754c\u9762/1".split(":")));
        System.out.println("E:/temp/\u754c\u9762/1".replace("E:/temp", "E:/FileUpload"));
    }
}

