/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NativeLibraryBundle {
    private static File rootDir;
    private static final String LOCK_SUFFIX = ".lck";
    private static Set dirsCreatedByThisJVM;
    private File lockFile;
    private FileLockWrapper lock;
    private String dirName;
    private Map pathMap = new HashMap();

    public static NativeLibraryBundle createTemporaryCopy(File file) throws IOException {
        return new NativeLibraryBundle(file);
    }

    public void addNamesToMap(Map map) {
        Iterator iterator = this.pathMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.containsKey(string)) continue;
            map.put(string, this.pathMap.get(string));
        }
    }

    protected void finalize() {
        if (NativeLibraryBundle.deleteRecursively(new File(rootDir, this.dirName))) {
            this.lock.release();
            this.lockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLibraryBundle(File file) throws IOException {
        Object object = dirsCreatedByThisJVM;
        synchronized (object) {
            this.lockFile = File.createTempFile("tmp", LOCK_SUFFIX, rootDir);
            String string = this.lockFile.getName();
            this.dirName = string.substring(0, string.lastIndexOf(LOCK_SUFFIX));
            dirsCreatedByThisJVM.add(this.dirName);
        }
        this.lock = FileLockWrapper.lockFile(this.lockFile);
        object = new File(rootDir, this.dirName);
        ((File)object).mkdir();
        this.copyFiles(file, (File)object, null);
    }

    private void copyFiles(File file, File file2, String string) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            Object object2;
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                object2 = new File(file2, file3.getName());
                ((File)object2).mkdir();
                object = string != null ? string + File.separator + file3.getName() : file3.getName();
                this.copyFiles(file3, (File)object2, (String)object);
                continue;
            }
            if (!file3.isFile() || !file3.getName().endsWith(Config.getInstance().getLibrarySufix())) continue;
            object2 = new FileInputStream(file3).getChannel();
            object = new File(file2, file3.getName());
            FileChannel fileChannel = new FileOutputStream((File)object).getChannel();
            ((FileChannel)object2).transferTo(0L, ((FileChannel)object2).size(), fileChannel);
            fileChannel.force(true);
            ((AbstractInterruptibleChannel)object2).close();
            fileChannel.close();
            String string2 = ((File)object).getName();
            if (string != null) {
                string2 = string + File.separator + string2;
            }
            this.pathMap.put(string2, ((File)object).getAbsolutePath());
        }
    }

    private static void deleteOldDirs() {
        File[] fileArray = rootDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (dirsCreatedByThisJVM.contains(file.getName())) continue;
            File file2 = new File(rootDir, file.getName() + LOCK_SUFFIX);
            try {
                boolean bl;
                FileLockWrapper fileLockWrapper = FileLockWrapper.tryLockFile(file2);
                if (fileLockWrapper == null || !(bl = NativeLibraryBundle.deleteRecursively(file))) continue;
                fileLockWrapper.release();
                file2.delete();
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static boolean deleteRecursively(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                NativeLibraryBundle.deleteRecursively(file2);
                continue;
            }
            file2.delete();
        }
        return file.delete();
    }

    static {
        dirsCreatedByThisJVM = Collections.synchronizedSet(new HashSet());
        String string = System.getProperty("java.io.tmpdir") + File.separator + ".java_jnlp_applet_nativelib_cache." + System.getProperty("user.name");
        rootDir = new File(string);
        if (!rootDir.exists()) {
            rootDir.mkdir();
        }
        Thread thread = new Thread(){

            public void run() {
                NativeLibraryBundle.deleteOldDirs();
            }
        };
        thread.setName("Native Library Cache Cleaner Thread");
        thread.start();
    }

    static class FileLockWrapper {
        private FileOutputStream str;
        private FileChannel chan;
        private FileLock lock;

        private FileLockWrapper(FileOutputStream fileOutputStream, FileChannel fileChannel, FileLock fileLock) {
            this.str = fileOutputStream;
            this.chan = fileChannel;
            this.lock = fileLock;
        }

        public void release() {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            try {
                this.chan.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }

        public static FileLockWrapper lockFile(File file) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.lock();
            if (fileLock == null) {
                fileChannel.close();
                return null;
            }
            return new FileLockWrapper(fileOutputStream, fileChannel, fileLock);
        }

        public static FileLockWrapper tryLockFile(File file) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) {
                fileChannel.close();
                return null;
            }
            return new FileLockWrapper(fileOutputStream, fileChannel, fileLock);
        }
    }
}

