/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.flowengine.runtime;

import java.util.ArrayList;
import java.util.Stack;
import zr.zrpower.common.util.Log;

public class Evaluator {
    Log log = new Log();
    public String Expression;
    private String[] Word;
    private ValStack Val;
    private SignStack Sign;
    private WordAnalysis wordAnalysis;
    private FunctionLib functionLib;
    public Variable Var;
    public FunctionList Func;

    public double Function(double[] param) {
        return 0.0;
    }

    public Evaluator(String expression) {
        this.log.SetLogForClass("Evaluator");
        this.log.SetLogFile("Evaluator.log");
        this.Val = new ValStack();
        this.Sign = new SignStack();
        this.Var = new Variable(50);
        this.Func = new FunctionList(20);
        this.functionLib = new FunctionLib();
        this.wordAnalysis = new WordAnalysis();
        this.functionLib.AssignFunctionLib(this.Func);
        this.Expression = expression;
    }

    public Evaluator() {
        this("");
    }

    private void InitExpression() {
        try {
            this.Word = this.wordAnalysis.Analysis(this.Expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean IsFunc(String word) {
        return this.Func.IndexOf(word.toUpperCase()) != -1;
    }

    private boolean IsNum(String word) {
        try {
            Double.valueOf(word);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean IsVar(String word) {
        return this.Var.IndexOf(word) != -1;
    }

    private boolean IsSign(String word) {
        String[] sign = this.wordAnalysis.Seperator;
        if (word.trim().equals("")) {
            return false;
        }
        for (int i = 0; i < sign.length; ++i) {
            if (!word.equals(sign[i])) continue;
            return true;
        }
        return false;
    }

    private boolean IsOtherWord(String word) {
        return !this.IsNum(word) && !this.IsVar(word) && !this.IsFunc(word) && !this.IsSign(word);
    }

    private int Priority(String sign) {
        if (sign.equals("(")) {
            return Short.MAX_VALUE;
        }
        if (sign.equals(")")) {
            return -32767;
        }
        if (sign.equals("*") || sign.equals("/")) {
            return 8;
        }
        if (sign.equals("+") || sign.equals("-")) {
            return 4;
        }
        if (sign.equals(",")) {
            return 2;
        }
        if (this.IsFunc(sign)) {
            return 16;
        }
        return 0;
    }

    public String[] GetVariables() {
        ArrayList<String> wordList = new ArrayList<String>();
        WordAnalysis wordAnalysis = new WordAnalysis();
        String[] words = wordAnalysis.Analysis(this.Expression);
        for (int i = 0; i < words.length; ++i) {
            if (!Character.isLetter(words[i].charAt(0)) || this.IsFunc(words[i]) || wordList.contains(words[i])) continue;
            wordList.add(words[i]);
        }
        String[] vars = new String[wordList.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = String.valueOf(wordList.get(i));
        }
        return vars;
    }

    private double Compute(String sign, double a, double b) {
        double ret = 0.0;
        char signFlag = sign.charAt(0);
        switch (signFlag) {
            case '+': {
                ret = a + b;
                break;
            }
            case '-': {
                ret = a - b;
                break;
            }
            case '*': {
                ret = a * b;
                break;
            }
            case '/': {
                ret = a / b;
                break;
            }
            default: {
                if (!this.IsFunc(sign)) break;
                double[] parameter = new double[this.Func.ParameterCount(sign)];
                for (int i = parameter.length - 1; i >= 0; --i) {
                    parameter[i] = this.Val.Pop();
                }
                IAccount func = this.Func.getFunc(sign);
                ret = func.Account(parameter);
            }
        }
        return ret;
    }

    public double Calculate() throws Exception {
        this.InitExpression();
        for (int cur = 0; cur < this.Word.length; ++cur) {
            if (this.IsNum(this.Word[cur])) {
                this.Val.Push(Double.parseDouble(this.Word[cur]));
                continue;
            }
            if (this.Word[cur].equals("(")) {
                this.Sign.Push(this.Word[cur]);
                continue;
            }
            if (this.Word[cur].equals(",")) continue;
            if (this.IsFunc(this.Word[cur])) {
                this.Sign.Push(this.Word[cur]);
                continue;
            }
            if (this.IsVar(this.Word[cur])) {
                this.Val.Push(this.Var.getValue(this.Word[cur]));
                continue;
            }
            if (this.IsSign(this.Word[cur])) {
                while (this.Priority(this.Sign.Peek()) >= this.Priority(this.Word[cur])) {
                    if (this.Sign.Peek().equals("(")) {
                        if (!this.Word[cur].equals(")")) break;
                        this.Sign.Pop();
                        break;
                    }
                    if (this.IsFunc(this.Sign.Peek())) {
                        this.Val.Push(this.Compute(this.Sign.Peek(), 0.0, 0.0));
                    } else {
                        double b = this.Val.Pop();
                        double a = this.Val.Pop();
                        this.Val.Push(this.Compute(this.Sign.Peek(), a, b));
                    }
                    this.Sign.Pop();
                }
                if (this.Word[cur].equals(")") || this.Word[cur].equals(",")) continue;
                this.Sign.Push(this.Word[cur]);
                continue;
            }
            throw new Exception("\u8868\u8fbe\u5f0f\u5305\u542b\u975e\u6cd5\u5b57\u7b26: " + this.Word[cur]);
        }
        while (this.Sign.Count() > 0) {
            String curSign = this.Sign.Pop();
            if (curSign.equals("(") || curSign.equals(",")) continue;
            if (this.IsFunc(curSign)) {
                this.Val.Push(this.Compute(curSign, 0.0, 0.0));
                continue;
            }
            if (!this.IsSign(curSign)) continue;
            double b = this.Val.Pop();
            double a = this.Val.Pop();
            this.Val.Push(this.Compute(curSign, a, b));
        }
        return this.Val.Pop();
    }

    public class FunctionLib {
        public void AssignFunctionLib(FunctionList list) {
            try {
                list.Add("POW", 2, new POW());
                list.Add("EXP", 1, new EXP());
                list.Add("SQRT", 1, new SQRT());
                list.Add("LOG", 2, new LOG());
                list.Add("ABS", 1, new ABS());
                list.Add("MAX", 2, new MAX());
                list.Add("MIN", 2, new MIN());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class MIN
    implements IAccount {
        MIN() {
        }

        public double Account(double[] p) {
            return Math.min(p[0], p[1]);
        }
    }

    class MAX
    implements IAccount {
        MAX() {
        }

        public double Account(double[] p) {
            return Math.max(p[0], p[1]);
        }
    }

    class ABS
    implements IAccount {
        ABS() {
        }

        public double Account(double[] p) {
            return Math.abs(p[0]);
        }
    }

    class LOG
    implements IAccount {
        LOG() {
        }

        public double Account(double[] p) {
            return Math.log(p[0]);
        }
    }

    class SQRT
    implements IAccount {
        SQRT() {
        }

        public double Account(double[] p) {
            return Math.sqrt(p[0]);
        }
    }

    class EXP
    implements IAccount {
        EXP() {
        }

        public double Account(double[] p) {
            return Math.exp(p[0]);
        }
    }

    class POW
    implements IAccount {
        POW() {
        }

        public double Account(double[] p) {
            return Math.pow(p[0], p[1]);
        }
    }

    static interface IAccount {
        public double Account(double[] var1);
    }

    public class FunctionList {
        private IAccount[] Func;
        private String[] FuncName;
        private int[] ParamCount;
        private int _Count;

        public int Count() {
            return this._Count;
        }

        public int Length() {
            return this.FuncName.length;
        }

        public FunctionList(int size) {
            this.Func = new IAccount[size];
            this.FuncName = new String[size];
            this.ParamCount = new int[size];
            for (int i = 0; i < this.FuncName.length; ++i) {
                this.Func[i] = null;
                this.FuncName[i] = "";
                this.ParamCount[i] = 0;
            }
            this._Count = 0;
        }

        public int IndexOf(String funcName) {
            if (funcName == null || funcName.equals("")) {
                return -1;
            }
            for (int i = 0; i < this._Count; ++i) {
                if (!this.FuncName[i].equals(funcName)) continue;
                return i;
            }
            return -1;
        }

        public void Add(String funcName, int paramCount, IAccount func) {
            int index = this.IndexOf(funcName);
            if (index == -1) {
                if (this._Count < this.Length()) {
                    this.FuncName[this._Count] = funcName;
                    this.Func[this._Count] = func;
                    this.ParamCount[this._Count] = paramCount;
                    ++this._Count;
                }
            } else {
                this.Func[index] = func;
                this.ParamCount[index] = paramCount;
            }
        }

        public IAccount getFunc(String func) {
            int index = this.IndexOf(func);
            if (index == -1) {
                return null;
            }
            return this.Func[index];
        }

        public int ParameterCount(String func) {
            int index = this.IndexOf(func);
            if (index == -1) {
                return -1;
            }
            return this.ParamCount[index];
        }
    }

    public class Variable {
        private String[] Key;
        private double[] Value;
        private int index;

        public Variable(int size) {
            this.Key = new String[size];
            this.Value = new double[size];
            for (int i = 0; i < this.Key.length; ++i) {
                this.Key[i] = "";
                this.Value[i] = 0.0;
            }
            this.index = 0;
        }

        public int IndexOf(String key) {
            if (key == null || key.equals("")) {
                return -1;
            }
            for (int i = 0; i < this.index; ++i) {
                if (!this.Key[i].equals(key)) continue;
                return i;
            }
            return -1;
        }

        public int Count() {
            return this.index;
        }

        public int Length() {
            return this.Key.length;
        }

        public double getValue(String key) {
            int idx = this.IndexOf(key);
            if (idx == -1) {
                return 0.0;
            }
            return this.Value[idx];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(String key, double value) throws Exception {
            int idx = this.IndexOf(key);
            if (idx == -1) {
                if (this.index >= this.Length()) throw new Exception("\u65b0\u589e\u53d8\u91cf\u51fa\u9519, \u53d8\u91cf\u6570\u7ec4\u5df2\u6ee1");
                this.Key[this.index] = key;
                this.Value[this.index] = value;
                ++this.index;
                return;
            } else {
                this.Value[idx] = value;
            }
        }
    }

    public class WordAnalysis {
        public String[] Seperator = new String[]{"+", "-", "*", "/", ",", "(", ")", "ABC"};

        public boolean IsSeperator(String s) {
            for (int i = 0; i < this.Seperator.length; ++i) {
                if (!s.equals(this.Seperator[i])) continue;
                return true;
            }
            return false;
        }

        public String[] Analysis(String str) {
            if (str == null || str.equals("")) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            String cur = "";
            for (int i = 0; i < str.length(); ++i) {
                String t = String.valueOf(str.charAt(i));
                if (t.equals(" ") || t.equals("\t") || t.equals("\n")) {
                    if (cur.equals("")) continue;
                    list.add(cur);
                    cur = "";
                    continue;
                }
                if (this.IsSeperator(t)) {
                    if (!cur.equals("")) {
                        list.add(cur);
                        cur = "";
                    }
                    list.add(t);
                    continue;
                }
                if (!this.IsSeperator((cur = cur + t).trim())) continue;
                list.add(cur);
                cur = "";
            }
            if (!cur.equals("")) {
                list.add(cur);
            }
            String[] ret = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = String.valueOf(list.get(i));
            }
            return ret;
        }
    }

    public class SignStack {
        private Stack stack = new Stack();

        public String Pop() {
            if (this.stack.size() == 0) {
                return "";
            }
            return String.valueOf(this.stack.pop());
        }

        public void Push(String val) {
            this.stack.push(val.toUpperCase());
        }

        public String Peek() {
            if (this.stack.size() == 0) {
                return "";
            }
            return (String)this.stack.peek();
        }

        public int Count() {
            return this.stack.size();
        }

        public void Clear() {
            this.stack.clear();
        }
    }

    public class ValStack {
        private Stack stack = new Stack();

        public double Pop() {
            if (this.stack.size() == 0) {
                return 0.0;
            }
            return Double.parseDouble(String.valueOf(this.stack.pop()));
        }

        public void Push(double val) {
            Double d = new Double(val);
            this.stack.push(d);
        }

        public double Peek() {
            if (this.stack.size() == 0) {
                return 0.0;
            }
            return Double.parseDouble(String.valueOf(this.stack.peek()));
        }

        public int Count() {
            return this.stack.size();
        }

        public void Clear() {
            this.stack.clear();
        }
    }
}

