/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting;

import java.util.ArrayList;
import java.util.Collection;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ScriptSessionFilter;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AllScriptSessionFilter;
import org.directwebremoting.extend.AndScriptSessionFilter;
import org.directwebremoting.extend.IdScriptSessionFilter;
import org.directwebremoting.extend.PageScriptSessionFilter;
import org.directwebremoting.extend.TaskDispatcher;
import org.directwebremoting.extend.TaskDispatcherFactory;
import org.directwebremoting.io.JavascriptObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser {
    public static void withAllSessions(Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(ServerContextFactory.get());
        taskDispatcher.dispatchTask(new AllScriptSessionFilter(), task);
    }

    public static void withAllSessions(ServerContext serverContext, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(new AllScriptSessionFilter(), task);
    }

    public static void withAllSessionsFiltered(ScriptSessionFilter filter, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(ServerContextFactory.get());
        taskDispatcher.dispatchTask(filter, task);
    }

    public static void withAllSessionsFiltered(ServerContext serverContext, ScriptSessionFilter filter, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(filter, task);
    }

    public static void withCurrentPage(Runnable task) {
        WebContext webContext = WebContextFactory.get();
        String page = webContext.getCurrentPage();
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(webContext);
        taskDispatcher.dispatchTask(new PageScriptSessionFilter(webContext, page), task);
    }

    public static void withPage(String page, Runnable task) {
        ServerContext serverContext = ServerContextFactory.get();
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(new PageScriptSessionFilter(serverContext, page), task);
    }

    public static void withPage(ServerContext serverContext, String page, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(new PageScriptSessionFilter(serverContext, page), task);
    }

    public static void withCurrentPageFiltered(ScriptSessionFilter filter, Runnable task) {
        WebContext webContext = WebContextFactory.get();
        String page = webContext.getCurrentPage();
        PageScriptSessionFilter pageFilter = new PageScriptSessionFilter(webContext, page);
        AndScriptSessionFilter realFilter = new AndScriptSessionFilter(pageFilter, filter);
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(webContext);
        taskDispatcher.dispatchTask(realFilter, task);
    }

    public static void withPageFiltered(String page, ScriptSessionFilter filter, Runnable task) {
        ServerContext serverContext = ServerContextFactory.get();
        PageScriptSessionFilter pageFilter = new PageScriptSessionFilter(serverContext, page);
        AndScriptSessionFilter realFilter = new AndScriptSessionFilter(pageFilter, filter);
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(realFilter, task);
    }

    public static void withPageFiltered(ServerContext serverContext, String page, ScriptSessionFilter filter, Runnable task) {
        PageScriptSessionFilter pageFilter = new PageScriptSessionFilter(serverContext, page);
        AndScriptSessionFilter realFilter = new AndScriptSessionFilter(pageFilter, filter);
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(realFilter, task);
    }

    public static void withSession(String sessionId, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(ServerContextFactory.get());
        taskDispatcher.dispatchTask(new IdScriptSessionFilter(sessionId), task);
    }

    public static void withSession(ServerContext serverContext, String sessionId, Runnable task) {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
        taskDispatcher.dispatchTask(new IdScriptSessionFilter(sessionId), task);
    }

    public static void close(Object proxy) {
        if (proxy instanceof JavascriptObject) {
            JavascriptObject dproxy = (JavascriptObject)proxy;
            dproxy.close();
        }
    }

    public static Collection<ScriptSession> getTargetSessions() {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get();
        Collection<ScriptSession> sessions = taskDispatcher.getTargetSessions();
        if (sessions != null) {
            return sessions;
        }
        WebContext webContext = WebContextFactory.get();
        if (webContext != null) {
            sessions = new ArrayList<ScriptSession>();
            sessions.add(webContext.getScriptSession());
            return sessions;
        }
        throw new IllegalStateException("No current UI to manipulate. See org.directwebremoting.Browser to set one.");
    }
}

