/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.util.DebuggingPrintWriter;

public abstract class BaseScriptConduit
extends ScriptConduit
implements Alarm {
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    private boolean debug = false;
    protected String accessLogLevel = null;
    protected ConverterManager converterManager = null;
    protected final HttpServletResponse response;
    protected PrintWriter out;
    protected final String instanceId;
    protected final String batchId;
    protected final Sleeper sleeper;
    private static final Log log = LogFactory.getLog(BaseScriptConduit.class);

    public BaseScriptConduit(Sleeper sleeper, HttpServletResponse response, String instanceId, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(1, true);
        this.response = response;
        this.instanceId = instanceId;
        this.batchId = batchId;
        this.converterManager = converterManager;
        this.jsonOutput = jsonOutput;
        this.sleeper = sleeper;
        response.setContentType(this.getOutboundMimeType());
        this.out = response.getWriter();
        if (this.debugScriptOutput || AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
            DebuggingPrintWriter dpw = new DebuggingPrintWriter("", this.out);
            dpw.setPrefix("out(" + this.hashCode() + "): ");
            this.out = dpw;
        }
        this.beginStream();
    }

    protected abstract String getOutboundMimeType();

    protected abstract void beginStream();

    protected abstract void endStream();

    public void close(int timetoNextPoll) throws IOException {
        try {
            ScriptBuffer script = EnginePrivate.getRemoteHandleCallbackScript(this.batchId, "0", timetoNextPoll);
            this.addScript(script);
        }
        catch (Exception ex) {
            ScriptBuffer script = EnginePrivate.getRemoteHandleExceptionScript(this.batchId, "0", ex);
            try {
                this.addScript(script);
            }
            catch (ConversionException ex1) {
                log.warn((Object)"This can't happen:", (Throwable)ex1);
            }
            log.warn((Object)("--Erroring: batchId[" + this.batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
        }
        this.endStream();
    }

    public void cancel() {
    }

    protected boolean flush() {
        this.out.flush();
        if (this.out.checkError()) {
            log.debug((Object)"Error writing to stream");
            this.sleeper.wakeUp();
            return false;
        }
        try {
            this.response.flushBuffer();
            return true;
        }
        catch (IOException ex) {
            log.debug((Object)("Error calling response.flushBuffer:" + ex));
            this.sleeper.wakeUp();
            return false;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }
}

