/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.directwebremoting.guice.util.MethodInterceptorWrapper;

public class OutermostCallInterceptor
implements MethodInterceptor {
    private final MethodInterceptor interceptor;
    private final ThreadLocal<Integer> count = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static MethodInterceptorWrapper outermostCallWrapper() {
        return new MethodInterceptorWrapper(){

            public MethodInterceptor wrap(MethodInterceptor methodInterceptor) {
                return OutermostCallInterceptor.outermostCall(methodInterceptor);
            }
        };
    }

    public static MethodInterceptor outermostCall(MethodInterceptor interceptor) {
        return new OutermostCallInterceptor(interceptor);
    }

    @Inject
    void injectInterceptor(Injector injector) {
        injector.injectMembers((Object)this.interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        int savedCount = this.count.get();
        this.count.set(savedCount + 1);
        try {
            if (this.count.get() > 1) {
                Object object = invocation.proceed();
                return object;
            }
            Object object = this.interceptor.invoke(invocation);
            return object;
        }
        finally {
            this.count.set(savedCount);
        }
    }

    private OutermostCallInterceptor(MethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }
}

