/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.Module;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

public class DefaultRemoter
implements Remoter {
    private boolean debug = false;
    protected ModuleManager moduleManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    protected String overridePath = null;
    protected String accessLogLevel = null;
    protected boolean useAbsolutePath = false;
    protected boolean allowImpossibleTests = false;
    protected int maxCallCount = 20;
    private static final Log log = LogFactory.getLog(DefaultRemoter.class);

    public String generateInterfaceJavaScript(String scriptName, String indent, String assignVariable, String contextServletPath) throws SecurityException {
        MethodDeclaration[] methods;
        StringBuilder buffer = new StringBuilder();
        buffer.append(indent + assignVariable + " = {};\n").append(indent + assignVariable + "._path = '" + this.getPathToDwrServlet(contextServletPath) + "';\n");
        Module module = this.moduleManager.getModule(scriptName, false);
        for (MethodDeclaration method : methods = module.getMethods()) {
            int j;
            String methodName = method.getName();
            try {
                this.accessControl.assertGeneralDisplayable(scriptName, method);
            }
            catch (SecurityException ex) {
                if (!this.allowImpossibleTests) continue;
            }
            if (JavascriptUtil.isReservedWord(methodName)) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            buffer.append("\n");
            buffer.append(indent + "/**\n");
            for (j = 0; j < paramTypes.length; ++j) {
                if (LocalUtil.isServletClass(paramTypes[j])) continue;
                buffer.append(indent + " * @param {");
                buffer.append(paramTypes[j]);
                buffer.append("} p");
                buffer.append(j);
                buffer.append(" a param\n");
            }
            buffer.append(indent + " * @param {function|Object} callback callback function or options object\n");
            buffer.append(indent + " */\n");
            buffer.append(indent + assignVariable + "." + methodName + " = function(");
            for (j = 0; j < paramTypes.length; ++j) {
                if (LocalUtil.isServletClass(paramTypes[j])) continue;
                buffer.append("p");
                buffer.append(j);
                buffer.append(", ");
            }
            buffer.append("callback) {\n");
            buffer.append(indent + "  return ");
            buffer.append(EnginePrivate.getExecuteFunctionName());
            buffer.append("(");
            buffer.append(assignVariable);
            buffer.append("._path, '");
            buffer.append(scriptName);
            buffer.append("', '");
            buffer.append(methodName);
            buffer.append("', arguments);\n");
            buffer.append(indent + "};\n");
        }
        return buffer.toString();
    }

    public String generateDtoJavaScript(String jsClassName, String indent, String assignVariable) throws SecurityException {
        NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
        if (namedConv != null) {
            String name;
            StringBuilder buf = new StringBuilder();
            buf.append(indent + assignVariable + " = function() {\n");
            Map<String, Property> properties = namedConv.getPropertyMapFromClass(namedConv.getInstanceType(), true, true);
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                name = entry.getKey();
                Property property = entry.getValue();
                Class<?> propType = property.getPropertyType();
                buf.append(indent + "  this.");
                buf.append(name);
                buf.append(" = ");
                if (propType.isArray()) {
                    buf.append("[]");
                } else if (propType == Boolean.TYPE) {
                    buf.append("false");
                } else if (propType.isPrimitive()) {
                    buf.append("0");
                } else {
                    buf.append("null");
                }
                buf.append(";\n");
            }
            buf.append(indent + "}\n");
            buf.append(indent);
            buf.append(assignVariable);
            buf.append(".$dwrClassName = '");
            buf.append(jsClassName);
            buf.append("';\n");
            buf.append(indent + assignVariable);
            buf.append(".$dwrClassMembers = {};\n");
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                name = entry.getKey();
                buf.append(indent);
                buf.append(assignVariable);
                buf.append(".$dwrClassMembers.");
                buf.append(name);
                buf.append(" = {};\n");
            }
            buf.append(indent);
            buf.append(assignVariable);
            buf.append(".createFromMap = dwr.engine._createFromMap;\n");
            return buf.toString();
        }
        log.warn((Object)("Failed to create class definition for JS class " + jsClassName + " because it was not found."));
        return null;
    }

    public String generateDtoInheritanceJavaScript(String indent, String classExpression, String superClassExpression, String delegateFunction) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent + classExpression);
        buf.append(".prototype = " + delegateFunction + "(");
        buf.append(superClassExpression);
        buf.append(".prototype);\n");
        buf.append(indent + classExpression);
        buf.append(".prototype.constructor = ");
        buf.append(classExpression);
        buf.append(";\n");
        return buf.toString();
    }

    public String getPathToDwrServlet(String contextServletPath) {
        String actualPath = contextServletPath;
        if (this.overridePath != null) {
            actualPath = this.overridePath;
        }
        if (this.useAbsolutePath) {
            HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
            StringBuffer absolutePath = new StringBuffer(48);
            String scheme = request.getScheme();
            int port = request.getServerPort();
            absolutePath.append(scheme);
            absolutePath.append("://");
            absolutePath.append(request.getServerName());
            if (port > 0 && ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443)) {
                absolutePath.append(':');
                absolutePath.append(port);
            }
            absolutePath.append(request.getContextPath());
            absolutePath.append(request.getServletPath());
            actualPath = absolutePath.toString();
        }
        return actualPath;
    }

    public Replies execute(Calls calls) {
        Replies replies = new Replies(calls);
        int callCount = calls.getCallCount();
        if (callCount > this.maxCallCount) {
            log.error((Object)"Call count for batch exceeds maxCallCount. Add an init-param of maxCallCount to increase this limit");
            throw new SecurityException("Call count for batch is too high");
        }
        for (Call call : calls) {
            Reply reply = this.execute(call);
            replies.addReply(reply);
        }
        return replies;
    }

    public Reply execute(Call call) {
        try {
            Module module = this.moduleManager.getModule(call.getScriptName(), true);
            MethodDeclaration method = call.getMethodDeclaration();
            if (method == null || call.getException() != null) {
                return new Reply(call.getCallId(), null, call.getException());
            }
            this.accessControl.assertGeneralExecutionIsPossible(call.getScriptName(), method);
            if (AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Exec: ").append(call.getScriptName()).append(".").append(call.getMethodDeclaration().toString());
                buffer.append(", ");
                buffer.append("id=");
                buffer.append(call.getCallId());
                Loggers.ACCESS.info((Object)buffer.toString());
            }
            Object reply = module.executeMethod(method, call.getParameters());
            return new Reply(call.getCallId(), reply);
        }
        catch (SecurityException ex) {
            this.writeExceptionToAccessLog(ex);
            if (this.debug) {
                return new Reply(call.getCallId(), null, ex);
            }
            return new Reply(call.getCallId(), null, new SecurityException());
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowIfContinuation(ex);
            this.writeExceptionToAccessLog(ex.getTargetException());
            return new Reply(call.getCallId(), null, ex.getTargetException());
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            this.writeExceptionToAccessLog(ex);
            return new Reply(call.getCallId(), null, ex);
        }
    }

    private void writeExceptionToAccessLog(Throwable ex) {
        AccessLogLevel accessLogLevelEnum = AccessLogLevel.getValue(this.accessLogLevel, this.debug);
        if (accessLogLevelEnum.hierarchy() <= 1 && ex instanceof Exception) {
            Loggers.ACCESS.info((Object)"Method execution failed: ", ex);
        } else if (accessLogLevelEnum.hierarchy() <= 2 && ex instanceof RuntimeException) {
            Loggers.ACCESS.info((Object)"Method execution failed: ", ex);
        } else if (accessLogLevelEnum.hierarchy() <= 3 && ex instanceof Error) {
            Loggers.ACCESS.info((Object)"Method execution failed: ", ex);
        }
    }

    public void setUseAbsolutePath(boolean useAbsolutePath) {
        this.useAbsolutePath = useAbsolutePath;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setMaxCallCount(int maxCallCount) {
        this.maxCallCount = maxCallCount;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

