/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.JsonParser;
import org.directwebremoting.json.parse.JsonParserFactory;
import org.directwebremoting.json.parse.impl.IgnoreJsonDecoder;
import org.directwebremoting.json.parse.impl.ReflectionJsonDecoder;
import org.directwebremoting.json.parse.impl.SimpleJsonDecoder;
import org.directwebremoting.json.serialize.JsonSerializer;
import org.directwebremoting.json.serialize.JsonSerializerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    public static String getErrors(String input) {
        return JsonUtil.getErrors(new StringReader(input));
    }

    public static String getErrors(Reader reader) {
        try {
            JsonParser parser = JsonParserFactory.get();
            parser.parse(reader, new IgnoreJsonDecoder());
            return null;
        }
        catch (JsonParseException ex) {
            return ex.toString();
        }
    }

    public static Map<String, Object> toSimpleObject(String input) throws JsonParseException {
        return JsonUtil.toSimpleObject(new StringReader(input));
    }

    public static Map<String, Object> toSimpleObject(Reader reader) throws JsonParseException {
        JsonParser parser = JsonParserFactory.get();
        return (Map)parser.parse(reader, new SimpleJsonDecoder());
    }

    public static List<Object> toSimpleArray(String input) throws JsonParseException {
        return JsonUtil.toSimpleArray(new StringReader(input));
    }

    public static List<Object> toSimpleArray(Reader reader) throws JsonParseException {
        JsonParser parser = JsonParserFactory.get();
        return (List)parser.parse(reader, new SimpleJsonDecoder());
    }

    public static <T> T toReflectedTypes(Class<T> marshallInto, String input) throws JsonParseException {
        return JsonUtil.toReflectedTypes(marshallInto, new StringReader(input));
    }

    public static <T> T toReflectedTypes(Class<T> marshallInto, Reader reader) throws JsonParseException {
        JsonParser parser = JsonParserFactory.get();
        return (T)parser.parse(reader, new ReflectionJsonDecoder(marshallInto));
    }

    public static void toJson(Object data, Writer out) throws IOException {
        JsonSerializer serializer = JsonSerializerFactory.get();
        serializer.toJson(data, out);
    }

    public static String toJson(Object data) throws IOException {
        StringWriter out = new StringWriter();
        JsonUtil.toJson(data, out);
        return out.toString();
    }
}

