/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.jetty;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.ThreadWaitSleeper;
import org.directwebremoting.util.Continuation;

public class JettyContinuationSleeper
implements Sleeper {
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIAL);
    private ThreadWaitSleeper proxy = null;
    private final Continuation continuation;
    private Runnable onAwakening;
    private final HttpServletRequest request;
    protected static final String ATTRIBUTE_CONDUIT = "org.directwebremoting.server.jetty.notifyConduit";
    private static final Log log = LogFactory.getLog(JettyContinuationSleeper.class);

    public JettyContinuationSleeper(HttpServletRequest request) {
        this.continuation = new Continuation(request);
        this.request = request;
    }

    public static boolean isRestart(HttpServletRequest request) {
        return JettyContinuationSleeper.getSleeper(request) != null;
    }

    public static void restart(HttpServletRequest request) {
        JettyContinuationSleeper sleeper = JettyContinuationSleeper.getSleeper(request);
        if (sleeper == null) {
            throw new IllegalStateException("No JettyContinuationSleeper in HttpServletRequest");
        }
        request.removeAttribute(ATTRIBUTE_CONDUIT);
        sleeper.onAwakening.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(Runnable awakening) {
        if (awakening == null) {
            throw new NullPointerException("Null value for awakening");
        }
        if (this.state.compareAndSet(State.INITIAL, State.ABOUT_TO_SLEEP)) {
            try {
                this.continuation.suspend();
            }
            catch (Exception ex) {
                Continuation.rethrowIfContinuation(ex);
                log.warn((Object)"Exception", (Throwable)ex);
                this.proxy = new ThreadWaitSleeper();
                this.state.set(State.BLOCKED);
                this.proxy.goToSleep(awakening);
            }
            finally {
                if (!this.state.compareAndSet(State.BLOCKED, State.FINAL)) {
                    this.onAwakening = awakening;
                    this.saveSleeperOnRequest();
                    this.state.set(State.SLEEPING);
                }
            }
        } else if (this.state.compareAndSet(State.PRE_AWAKENED, State.FINAL)) {
            awakening.run();
        } else {
            throw new IllegalStateException("Attempt to goToSleep in state " + (Object)((Object)this.state.get()));
        }
    }

    public void wakeUp() {
        boolean retry;
        block11: do {
            retry = false;
            switch (this.state.get()) {
                case INITIAL: {
                    this.state.compareAndSet(State.INITIAL, State.PRE_AWAKENED);
                    retry = true;
                    break;
                }
                case PRE_AWAKENED: {
                    break;
                }
                case ABOUT_TO_SLEEP: {
                    try {
                        do {
                            TimeUnit.MILLISECONDS.sleep(1L);
                        } while (this.state.get() == State.ABOUT_TO_SLEEP);
                        retry = true;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    continue block11;
                }
                case SLEEPING: {
                    if (this.state.compareAndSet(State.SLEEPING, State.RESUMING)) {
                        try {
                            this.continuation.resume();
                        }
                        catch (Exception ex) {
                            log.error((Object)"Broken reflection", (Throwable)ex);
                        }
                        continue block11;
                    }
                    retry = true;
                    break;
                }
                case BLOCKED: {
                    this.proxy.wakeUp();
                    break;
                }
            }
        } while (retry);
    }

    private void resume() {
        if (!this.state.compareAndSet(State.RESUMING, State.FINAL)) {
            throw new IllegalStateException("Attempt to resume from state " + (Object)((Object)this.state.get()));
        }
        this.request.removeAttribute(ATTRIBUTE_CONDUIT);
        this.onAwakening.run();
    }

    private void saveSleeperOnRequest() {
        this.request.setAttribute(ATTRIBUTE_CONDUIT, (Object)this);
    }

    private static JettyContinuationSleeper getSleeper(HttpServletRequest request) {
        return (JettyContinuationSleeper)request.getAttribute(ATTRIBUTE_CONDUIT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        PRE_AWAKENED,
        ABOUT_TO_SLEEP,
        SLEEPING,
        BLOCKED,
        RESUMING,
        FINAL;

    }
}

