/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorHandler
implements Handler {
    protected boolean debug = false;
    private static final Log log = LogFactory.getLog(MonitorHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.debug) {
            log.warn((Object)"Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            throw new SecurityException("Access to debug pages is denied.");
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><head><title>DWR - System Monitor</title></head><body>");
        WebContext webContext = WebContextFactory.get();
        out.print("<h1>DWR - System Monitor</h1>");
        out.print("<h2>Global Settings:</h2>");
        String contextPath = webContext.getContextPath();
        out.print("<p>ContextPath: " + contextPath + "</p>");
        out.print("<p>Current Page: " + webContext.getCurrentPage() + "</p>");
        Container container = webContext.getContainer();
        TreeMap<String, Object> beans = new TreeMap<String, Object>();
        TreeMap<String, String> settings = new TreeMap<String, String>();
        TreeMap<String, String> urls = new TreeMap<String, String>();
        for (String name : container.getBeanNames()) {
            Object bean = container.getBean(name);
            if (name.startsWith("url:")) {
                urls.put(name.substring(4), bean.getClass().getName());
                continue;
            }
            if (bean instanceof String) {
                settings.put(name, bean.toString());
                continue;
            }
            beans.put(name, bean);
        }
        IdManager ids = new IdManager();
        for (Map.Entry urlEntry : urls.entrySet()) {
            Iterator it = settings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry settingEntry = it.next();
                if (!((String)urlEntry.getKey()).equals(settingEntry.getValue())) continue;
                it.remove();
                urls.put((String)urlEntry.getKey(), (String)urlEntry.getValue() + " (" + (String)settingEntry.getKey() + ")");
            }
        }
        out.print("<h2>Beans:</h2>");
        for (Map.Entry entry : beans.entrySet()) {
            String name = (String)entry.getKey();
            Object object = entry.getValue();
            this.digWhatever(out, ids, name, object);
        }
        out.print("<h2>Settings:</h2>");
        for (Map.Entry entry : settings.entrySet()) {
            out.print("<p>" + (String)entry.getKey() + ": \"" + (String)entry.getValue() + "\"</p>");
        }
        out.print("<h2>URLs:</h2>");
        String prefix = contextPath + webContext.getHttpServletRequest().getServletPath();
        for (Map.Entry entry : urls.entrySet()) {
            out.print("<p><a href='" + prefix + (String)entry.getKey() + "'>" + (String)entry.getKey() + "</a>: " + (String)entry.getValue() + "</p>");
        }
        webContext.getContextPath();
        out.print("</body></html>");
    }

    private void digWhatever(PrintWriter out, IdManager ids, String name, Object object) {
        if (object == null || object instanceof Number || object instanceof Boolean) {
            this.digSimple(out, name, object);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            boolean simple = true;
            for (Object child : collection) {
                if (child instanceof Number || child instanceof Boolean || child instanceof String) continue;
                simple = false;
            }
            if (simple) {
                this.digSimple(out, name, object);
            } else {
                this.digCollection(out, ids, name, collection);
            }
        } else if (object instanceof Map) {
            this.digMap(out, ids, name, (Map)object);
        } else if (object.getClass().getName().startsWith("java") || object.getClass().getName().startsWith("com.sun")) {
            this.digSimple(out, name, object);
        } else if (object instanceof String) {
            this.digString(out, name, (String)object);
        } else {
            this.digObject(out, ids, name, object);
        }
    }

    private void digSimple(PrintWriter out, String name, Object object) {
        out.print("<div class='section'>");
        out.print("<div class='title'>" + name + ": " + object.toString() + "</div>");
        out.print("</div>");
    }

    private void digString(PrintWriter out, String name, String object) {
        out.print("<div class='section'>");
        out.print("<div class='title'>" + name + ": \"" + object + "\"</div>");
        out.print("</div>");
    }

    private void digCollection(PrintWriter out, IdManager ids, String name, Collection<?> collection) {
        out.print("<div class='section'>");
        String id = ids.getIfExists(collection);
        if (id != null) {
            out.print("<div class='title'>" + name + ": <a href='#id" + id + "'>Map</a></div>");
        } else {
            id = ids.allocate(collection);
            out.print("<div class='title'><a name='id" + id + "'>" + name + "</a>: Map</div>");
            out.print("<ul>");
            int i = 0;
            for (Object entry : collection) {
                this.digWhatever(out, ids, "" + i, entry.toString());
                ++i;
            }
            out.print("</ul>");
        }
    }

    private void digMap(PrintWriter out, IdManager ids, String name, Map<?, ?> map) {
        out.print("<div class='section'>");
        String id = ids.getIfExists(map);
        if (id != null) {
            out.print("<div class='title'>" + name + ": <a href='#id" + id + "'>Map</a></div>");
        } else {
            id = ids.allocate(map);
            out.print("<div class='title'><a name='id" + id + "'>" + name + "</a>: Map</div>");
            out.print("<ul>");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object value = entry.getValue();
                this.digWhatever(out, ids, entry.getValue().toString(), value);
            }
            out.print("</ul>");
        }
    }

    private void digException(PrintWriter out, String name, Throwable ex) {
        out.print("<div class='section'>");
        out.print("<div class='title'>" + name + ": " + ex.getClass().getSimpleName() + "(" + ex.getMessage() + ")</div>");
        out.print("</div>");
    }

    private void digObject(PrintWriter out, IdManager ids, String name, Object object) {
        Class<?> type = object.getClass();
        if (object instanceof Log) {
            return;
        }
        out.print("<div class='section'>");
        String id = ids.getIfExists(object);
        if (id != null) {
            out.print("<div class='title'>" + name + ": <a href='#id" + id + "'>" + type.getSimpleName() + "</a></div>");
        } else {
            id = ids.allocate(object);
            out.print("<div class='title'><a name='id" + id + "'>" + name + "</a>: " + type.getName() + "</div>");
            out.print("<ul>");
            for (Field field : LocalUtil.getAllFields(type)) {
                try {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object value = field.get(object);
                    this.digWhatever(out, ids, field.getName(), value);
                }
                catch (Exception ex) {
                    this.digException(out, field.getName(), ex);
                }
            }
            out.print("</ul>");
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected static class IdManager {
        private int nextId;
        private Map<Object, String> allocated = new HashMap<Object, String>();

        protected IdManager() {
        }

        public String getIfExists(Object object) {
            return this.allocated.get(object);
        }

        protected String allocate(Object object) {
            if (this.allocated.containsKey(object)) {
                throw new IllegalStateException("object already exists");
            }
            String id = "id" + this.nextId;
            ++this.nextId;
            this.allocated.put(object, id);
            return id;
        }
    }
}

