/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeServletConfig
implements ServletConfig {
    private final String name;
    private final ServletContext servletContext;
    private final Map<String, String> initParameters;

    public FakeServletConfig(String name, ServletContext servletContext) {
        this(name, servletContext, null);
    }

    public FakeServletConfig(String name, ServletContext servletContext, Map<String, String> initParameters) {
        this.name = name;
        this.servletContext = servletContext;
        this.initParameters = initParameters != null ? initParameters : new HashMap();
    }

    public FakeServletConfig(ServletConfig servletConfig) {
        this.name = servletConfig.getServletName();
        this.servletContext = servletConfig.getServletContext();
        this.initParameters = new HashMap<String, String>();
        for (String key : LocalUtil.iterableizer(servletConfig.getInitParameterNames(), String.class)) {
            String value = servletConfig.getInitParameter(key);
            this.initParameters.put(key, value);
        }
    }

    public String getServletName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String paramName) {
        String obj = this.initParameters.get(paramName);
        if (obj instanceof String) {
            return obj;
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }
}

