/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.common.db;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import zr.zrpower.common.db.dbColumn;
import zr.zrpower.common.db.dbRow;
import zr.zrpower.common.db.dbSet;
import zr.zrpower.common.db.dbType;
import zr.zrpower.common.util.StringWork;

public abstract class dbEntity
implements Serializable {
    protected dbRow dbrow = new dbRow();
    protected boolean bHTML = false;

    protected void initialize() {
    }

    protected String getString(String mValue) {
        if (this.bHTML) {
            if (mValue != null) {
                if (!mValue.equals("")) {
                    return this.replace(mValue);
                }
                return "&nbsp;";
            }
            return "&nbsp;";
        }
        return mValue;
    }

    public void fullData(dbRow dr) {
        StringWork sw = new StringWork();
        String[] strColumnName = dr.getAllColumnName();
        String[] saColumn = this.dbrow.getAllColumnName();
        if (!strColumnName.equals(null)) {
            for (int i = 0; i < strColumnName.length; ++i) {
                if (dr.Column(strColumnName[i]) == null || !sw.IsInArrary(strColumnName[i], saColumn)) continue;
                this.dbrow.Column(strColumnName[i]).setValue(dr.Column(strColumnName[i]).getValue());
            }
        }
    }

    public void fullDataFromRequest(HttpServletRequest request) {
        Hashtable<String, String> has = new Hashtable<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String[] values = request.getParameterValues(name);
            String value = "";
            if (values.length > 1) {
                StringWork sw = new StringWork();
                value = sw.UnSplit(values);
            } else {
                value = values[0];
            }
            has.put(name.toUpperCase(), value);
        }
        this.fullDataFromHashtable(has);
    }

    public void fullDataFromHashtable(Hashtable has) {
        String[] strColumnName = this.dbrow.getAllColumnName();
        String strDate = "";
        if (!strColumnName.equals(null)) {
            for (int i = 0; i < strColumnName.length; ++i) {
                if (has.get(strColumnName[i].toUpperCase()) == null) continue;
                if (this.dbrow.Column(strColumnName[i]).getType().getValue() == dbType.DATE.getValue() || this.dbrow.Column(strColumnName[i]).getType().getValue() == dbType.DATETIME.getValue()) {
                    strDate = (String)has.get(strColumnName[i].toUpperCase());
                    if (strDate.length() > 0) {
                        this.dbrow.Column(strColumnName[i]).setValue(this.stringToDateTime((String)has.get(strColumnName[i].toUpperCase())));
                        continue;
                    }
                    this.dbrow.Column(strColumnName[i]).setValue("");
                    continue;
                }
                if (has.get(strColumnName[i].toUpperCase()).equals("\u672a\u586b\u5199")) continue;
                this.dbrow.Column(strColumnName[i]).setValue(has.get(strColumnName[i].toUpperCase()));
            }
        }
    }

    public void fullData(dbSet ds) {
        if (ds.RowCount() > 0) {
            this.fullData(ds.Row(0));
        }
    }

    private Date stringToDateTime(String param) {
        SimpleDateFormat sdf;
        Date date;
        Date result = null;
        if (param == null) {
            return null;
        }
        if (param.length() == 10) {
            date = null;
            try {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                date = sdf.parse(param);
                result = new Date(date.getTime());
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        if (param.length() == 19) {
            date = null;
            try {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = sdf.parse(param);
                result = new Date(date.getTime());
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public String[] getAllColumnName() {
        return this.dbrow.getAllColumnName();
    }

    public int getColumnCount() {
        return this.dbrow.getColumnCount();
    }

    public dbRow getData() {
        return this.dbrow;
    }

    public dbColumn item(String ItemName) {
        return this.dbrow.Column(ItemName);
    }

    public void setToHTML(boolean IfTo) {
        this.bHTML = IfTo;
    }

    private String replace(String str) {
        StringBuffer sb = new StringBuffer();
        str = str.trim();
        block9: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\r': {
                    sb.append("<br>");
                    continue block9;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

