/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.common.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import zr.zrpower.common.util.SysPreperty;

public class Log
implements Serializable {
    private boolean bIsDebug = true;
    private boolean SaveToLogFile = false;
    private PrintWriter logFile;
    private String logClass = "";
    public String LogFilePath = "";

    public Log() {
        this.ReadProperty();
    }

    public Log(String ClassName) {
        this.logClass = ClassName;
        this.ReadProperty();
    }

    public Log(String ClassName, String LogFileName) {
        this.SetLogFile(LogFileName);
        this.logClass = ClassName;
        this.ReadProperty();
    }

    private void ReadProperty() {
        this.bIsDebug = SysPreperty.getProperty().IsDebug;
        this.LogFilePath = SysPreperty.getProperty().LogFilePath;
    }

    public void SetLogFile(String LogFileName) {
        if (LogFileName != null && !LogFileName.equals("")) {
            LogFileName = this.LogFilePath + '/' + LogFileName;
            try {
                this.logFile = new PrintWriter((Writer)new FileWriter(LogFileName, true), true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.SaveToLogFile = true;
        }
    }

    public void SetLogForClass(String ClassName) {
        this.logClass = ClassName;
    }

    public void WriteLog(String LogMsg) {
        String strMsg = "";
        if (this.bIsDebug) {
            strMsg = "\u3010" + this.logClass + "\u3011Class Info\uff1a" + LogMsg;
            this.Write(strMsg, false);
        }
    }

    public void WriteLog(String FunctionName, String LogMsg) {
        String strMsg = "";
        if (this.bIsDebug) {
            strMsg = "\u3010" + this.logClass + "\u3011Class---" + FunctionName + " Method\uff1a" + LogMsg;
            this.Write(strMsg, false);
        }
    }

    public void WriteErrorLog(String LogMsg) {
        this.Write("\u3010" + this.logClass + "\u3011Class Exception", true);
        this.Write("Exception Info\uff1a" + LogMsg, true);
    }

    public void WriteErrorLog(String FunctionName, String LogMsg) {
        this.Write("\u3010" + this.logClass + "\u3011Class Has Exception", true);
        this.Write("Exception At Method\uff1a" + FunctionName, true);
        this.Write("Exception Info\uff1a" + LogMsg, true);
    }

    private void Write(String strMsg, boolean IsError) {
        if (this.SaveToLogFile) {
            this.SaveToFile(strMsg);
        } else if (IsError) {
            System.err.println(strMsg);
        } else {
            System.out.println(strMsg);
        }
    }

    private void SaveToFile(String LogMsg) {
        Date date = new Date();
        String strDate = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            strDate = df.format(date);
        }
        LogMsg = strDate + " " + LogMsg;
        this.logFile.println(LogMsg);
    }
}

