/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.collectionengine;

import java.util.Enumeration;
import java.util.Hashtable;
import zr.zrpower.collectionengine.FlowList;
import zr.zrpower.collectionengine.ItemField;
import zr.zrpower.collectionengine.service.CollectionService;
import zr.zrpower.common.db.dbColumn;
import zr.zrpower.common.db.dbEngine;
import zr.zrpower.common.db.dbRow;
import zr.zrpower.common.db.dbTag;
import zr.zrpower.common.db.dbType;
import zr.zrpower.common.util.DateWork;
import zr.zrpower.common.util.SysPreperty;

public class ItemList {
    private Hashtable mList = new Hashtable();
    private boolean ReadOnlyMode = false;
    private boolean bAllEditMode = false;
    dbEngine dbengine;

    public ItemList(boolean readonly) {
        this.ReadOnlyMode = readonly;
        this.dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource, SysPreperty.getProperty().IsConvert);
        this.dbengine.initialize();
    }

    public ItemList(boolean readonly, boolean bAllEdit) {
        this.ReadOnlyMode = readonly;
        this.bAllEditMode = bAllEdit;
        this.dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource, SysPreperty.getProperty().IsConvert);
        this.dbengine.initialize();
    }

    public void addItem(ItemField item) {
        if (this.ReadOnlyMode) {
            item.setIsShow(true);
            item.setIsWrite(false);
        }
        if (this.bAllEditMode) {
            item.setIsShow(true);
            item.setIsWrite(true);
        }
        this.mList.put(item.getName().toUpperCase(), item);
    }

    public void removeItem(String itemname) {
        this.mList.remove(itemname.toUpperCase());
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public ItemField getItem(String itemname) {
        return (ItemField)this.mList.get(itemname.toUpperCase());
    }

    public String[] getItemNameList() {
        int i = this.mList.size();
        String[] result = new String[i];
        Enumeration names = this.mList.keys();
        int j = 0;
        while (names.hasMoreElements()) {
            result[j] = (String)names.nextElement();
            ++j;
        }
        return result;
    }

    public void fullFromFlowField(FlowList flowList) {
        if (flowList != null && flowList.getItemCount() > 0) {
            String[] saFlowName = flowList.getItemNameList();
            String[] saFieldName = this.getItemNameList();
            for (int i = 0; i < saFlowName.length; ++i) {
                for (int j = 0; j < saFieldName.length; ++j) {
                    if (!saFlowName[i].toUpperCase().equals(saFieldName[j].toUpperCase())) continue;
                    ((ItemField)this.mList.get(saFieldName[j])).setIsNull(flowList.getItem(saFlowName[i]).isNull());
                    if (this.ReadOnlyMode) {
                        ((ItemField)this.mList.get(saFieldName[j])).setIsWrite(false);
                        ((ItemField)this.mList.get(saFieldName[j])).setIsShow(true);
                        ((ItemField)this.mList.get(saFieldName[j])).setIsForce(false);
                    } else if (this.bAllEditMode) {
                        ((ItemField)this.mList.get(saFieldName[j])).setIsWrite(true);
                        ((ItemField)this.mList.get(saFieldName[j])).setIsShow(true);
                    } else {
                        ((ItemField)this.mList.get(saFieldName[j])).setIsWrite(flowList.getItem(saFlowName[i]).isWrite());
                        ((ItemField)this.mList.get(saFieldName[j])).setIsShow(flowList.getItem(saFlowName[i]).isShow());
                        ((ItemField)this.mList.get(saFieldName[j])).setIsForce(flowList.getItem(saFlowName[i]).isForce());
                    }
                    ((ItemField)this.mList.get(saFieldName[j])).setDefaultValue(flowList.getItem(saFlowName[i]).getDefault());
                    if (!flowList.getItem(saFlowName[i]).isForce()) continue;
                    ((ItemField)this.mList.get(saFieldName[j])).setValue(flowList.getItem(saFlowName[i]).getDefault());
                }
            }
        }
    }

    public int fullFromDbRow(dbRow dr, String Alias) {
        String[] columnName = dr.getAllColumnName();
        int i = 0;
        for (i = 0; i < columnName.length; ++i) {
            DateWork dw;
            String colName = columnName[i];
            if (Alias != null && !Alias.equals("")) {
                colName = (Alias + "$" + colName).toUpperCase();
            }
            if (this.mList.get(colName) != null) {
                this.mList.remove(colName);
            }
            ItemField item = new ItemField();
            dbColumn dc = dr.Column(columnName[i]);
            item.setName(colName);
            item.setChineseName(dc.getChineseName());
            item.setCodeTable(dc.getCodeTable());
            item.setCodeValue(dc.getCValue());
            item.setLength(dc.getLength());
            item.setType(dc.getType());
            item.setIsNull(dc.isNull());
            item.setCodeInput(dc.getTagExt());
            if (item.getType().getValue() == dbType.DATE.getValue()) {
                dw = new DateWork();
                item.setValue(dw.DateToString(dc.getDate()));
            }
            if (item.getType().getValue() == dbType.DATETIME.getValue()) {
                dw = new DateWork();
                item.setValue(dw.DateTimeToString(dc.getDate()));
            }
            if (item.getType().getValue() == dbType.FLOAT.getValue() && dc.getFloat() != 0.0f) {
                item.setValue(Float.toString(dc.getFloat()));
            }
            if (item.getType().getValue() == dbType.LONG.getValue() && dc.getInteger() != 0) {
                item.setValue(Integer.toString(dc.getInteger()));
            }
            if (item.getType().getValue() == dbType.STRING.getValue()) {
                item.setValue(dc.getString());
            }
            if (item.getType().getValue() == dbType.CLOB.getValue()) {
                item.setValue(dc.getClob());
            }
            if (item.getCodeTable() != null && !item.getCodeTable().equals("")) {
                item.setIsCode(true);
            }
            if (dc.getTag().getValue() == dbTag.USER.getValue()) {
                item.setIsUser(true);
            }
            if (dc.getTag().getValue() == dbTag.UNIT.getValue()) {
                item.setIsUnit(true);
                item.setUserField1(dc.getAuto1(), Alias);
                item.setUserField2(dc.getAuto2(), Alias);
                item.setUserField3(dc.getAuto3(), Alias);
            }
            if (this.ReadOnlyMode) {
                item.setIsShow(true);
                item.setIsWrite(false);
                item.setIsForce(false);
            }
            if (item.getType().getValue() == dbType.BLOB.getValue()) {
                item.setBlobSize(this.GetBlobSize(dr.getTableName(), columnName[i]));
            } else {
                item.setBlobSize(0);
            }
            this.mList.put(colName, item);
        }
        return i;
    }

    private int GetBlobSize(String tableName, String fieldName) {
        int rtnValue = 0;
        try {
            CollectionService cs = new CollectionService();
            rtnValue = cs.GetBlobSize(tableName, fieldName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return rtnValue;
    }
}

