/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.collectionengine.html;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.htmlparser.Node;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.InputTag;
import org.htmlparser.util.NodeList;
import zr.zrpower.collectionengine.ItemField;
import zr.zrpower.common.db.dbEngine;
import zr.zrpower.common.db.dbSet;
import zr.zrpower.common.db.dbType;
import zr.zrpower.common.util.Log;
import zr.zrpower.common.util.SysPreperty;

public class PrintControl {
    private InputTag mThis;
    private boolean isRemark = false;
    private int size = -1;
    private String align;
    Log log = new Log();
    dbEngine dbengine;

    public PrintControl(InputTag inputtag) {
        String tmpSize;
        this.log.SetLogForClass("PrintControl");
        this.log.SetLogFile("PrintControl.log");
        this.mThis = inputtag;
        this.dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource, SysPreperty.getProperty().IsConvert);
        this.dbengine.initialize();
        String tmpRemark = this.mThis.getAttribute("remark");
        this.align = this.mThis.getAttribute("align");
        if (this.align == null) {
            this.align = "left";
        }
        if (tmpRemark != null && tmpRemark.equals("remark")) {
            this.isRemark = true;
        }
        if ((tmpSize = this.mThis.getAttribute("size")) != null && !tmpSize.equals("")) {
            this.size = Integer.parseInt(tmpSize);
        }
    }

    public void setItemField(ItemField item) {
        Node n = this.mThis.getParent();
        int ni = n.getChildren().indexOf((Node)this.mThis);
        NodeList nlist = new NodeList();
        for (int ii = 0; ii < n.getChildren().size(); ++ii) {
            if (ii != ni) {
                nlist.add(n.getChildren().elementAt(ii));
                continue;
            }
            if (this.isRemark) {
                if (item.getValue() != null && item.getValue().length() == 16) {
                    ImageTag img = this.getIdiograph(item.getValue());
                    if (img != null) {
                        nlist.add((Node)img);
                        continue;
                    }
                    nlist.add((Node)new TextNode(this.HTMLEncode(this.ConvertData(item))));
                    continue;
                }
                nlist.add((Node)new TextNode(this.HTMLEncode(null)));
                continue;
            }
            nlist.add((Node)new TextNode(this.HTMLEncode(this.ConvertData(item))));
        }
        n.getChildren().removeAll();
        n.getChildren().add(nlist);
    }

    private ImageTag getIdiograph(String userid) {
        this.log.WriteLog("getIdiograph", "\u5f00\u59cb\u8c03\u7528");
        ImageTag img = null;
        String strSql = "Select USERID From BPIP_USER_PHOTO Where IDIOGRAPH IS NOT NULL And  USERID = '" + userid + "'";
        dbSet ds = this.dbengine.QuerySQL(strSql);
        if (ds != null && ds.RowCount() > 0) {
            img = new ImageTag();
            String urlStr = "showuserphoto.do?Act=idiograph&userid=" + userid;
            img.setImageURL(urlStr);
            img.setAttribute("width", "80");
            img.setAttribute("height", "30");
            this.log.WriteLog("img != null");
        }
        this.log.WriteLog("getIdiograph", "\u7ed3\u675f\u8c03\u7528");
        return img;
    }

    private String HTMLEncode(String s) {
        byte[] bc = null;
        int byteCount = 0;
        int len = 0;
        String tmpStr = "";
        if (s != null && !s.equals("")) {
            bc = s.getBytes();
            byteCount = bc.length;
            if (byteCount < this.size) {
                len = this.size - byteCount;
                if (this.align.equalsIgnoreCase("middle") || this.align.equalsIgnoreCase("center")) {
                    int i;
                    for (i = 0; i < len / 2; ++i) {
                        tmpStr = tmpStr + " ";
                    }
                    tmpStr = tmpStr + s;
                    for (i = 0; i < len / 2; ++i) {
                        tmpStr = tmpStr + " ";
                    }
                } else if (this.align.equalsIgnoreCase("right")) {
                    for (int i = 0; i < len; ++i) {
                        tmpStr = tmpStr + " ";
                    }
                    tmpStr = tmpStr + s;
                } else {
                    tmpStr = s;
                    for (int i = 0; i < this.size - byteCount; ++i) {
                        tmpStr = tmpStr + " ";
                    }
                }
                s = tmpStr;
            }
        } else {
            s = "";
            for (int i = 0; i < this.size; ++i) {
                s = s + " ";
            }
        }
        s = this.Replace(s, "<", "&lt;");
        s = this.Replace(s, ">", "&gt;");
        s = this.Replace(s, " ", "&nbsp;");
        s = this.Replace(s, "\"", "&quot;");
        s = s.replace('\r', '^');
        s = this.Replace(s, "^", "<br>");
        return s;
    }

    private String Replace(String strSource, String strFrom, String strTo) {
        String strDest = "";
        try {
            int intPos;
            int intFromLen = strFrom.length();
            while ((intPos = strSource.indexOf(strFrom)) != -1) {
                strDest = strDest + strSource.substring(0, intPos);
                strDest = strDest + strTo;
                strSource = strSource.substring(intPos + intFromLen);
            }
            strDest = strDest + strSource;
        }
        catch (Exception e) {
            // empty catch block
        }
        return strDest;
    }

    private String ConvertData(ItemField item) {
        Date date;
        if (item.getType().getValue() != dbType.DATE.getValue() && item.getType().getValue() != dbType.DATETIME.getValue()) {
            return item.getShowValue();
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = fmt.parse(item.getShowValue());
        }
        catch (ParseException ex) {
            this.log.WriteLog("parse\u4e3ayyyy-MM-dd HH:mm:ss\u7684\u683c\u5f0f\u65f6\u51fa\u73b0\u5f02\u5e38" + ex.getMessage());
            fmt = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date = fmt.parse(item.getShowValue());
            }
            catch (ParseException ex1) {
                this.log.WriteLog("parse\u4e3ayyyy-MM-dd\u7684\u683c\u5f0f\u65f6\u51fa\u73b0\u5f02\u5e38" + ex1.getMessage());
                return item.getShowValue();
            }
        }
        String formatstr = this.mThis.getAttribute("formatstr");
        if (formatstr != null) {
            try {
                fmt = new SimpleDateFormat(formatstr);
                this.log.WriteLog("formatstr=" + formatstr);
                return fmt.format(date);
            }
            catch (Exception ex) {
                this.log.WriteLog("\u683c\u5f0f\u5316\u4e3a" + formatstr + "\u65f6\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage());
                return item.getShowValue();
            }
        }
        String datestyle = this.mThis.getAttribute("datestyle");
        if (datestyle == null) {
            return item.getShowValue();
        }
        if (!datestyle.equalsIgnoreCase("CN")) {
            return item.getShowValue();
        }
        StringBuffer sb = new StringBuffer();
        Hashtable<String, String> numList = new Hashtable<String, String>();
        numList.put("0", "O");
        numList.put("1", "\u4e00");
        numList.put("2", "\u4e8c");
        numList.put("3", "\u4e09");
        numList.put("4", "\u56db");
        numList.put("5", "\u4e94");
        numList.put("6", "\u516d");
        numList.put("7", "\u4e03");
        numList.put("8", "\u516b");
        numList.put("9", "\u4e5d");
        numList.put("10", "\u5341");
        numList.put("11", "\u5341\u4e00");
        numList.put("12", "\u5341\u4e8c");
        numList.put("13", "\u5341\u4e09");
        numList.put("14", "\u5341\u56db");
        numList.put("15", "\u5341\u4e94");
        numList.put("16", "\u5341\u516d");
        numList.put("17", "\u5341\u4e03");
        numList.put("18", "\u5341\u516b");
        numList.put("19", "\u5341\u4e5d");
        numList.put("20", "\u4e8c\u5341");
        numList.put("21", "\u4e8c\u5341\u4e00");
        numList.put("22", "\u4e8c\u5341\u4e8c");
        numList.put("23", "\u4e8c\u5341\u4e09");
        numList.put("24", "\u4e8c\u5341\u56db");
        numList.put("25", "\u4e8c\u5341\u4e94");
        numList.put("26", "\u4e8c\u5341\u516d");
        numList.put("27", "\u4e8c\u5341\u4e03");
        numList.put("28", "\u4e8c\u5341\u516b");
        numList.put("29", "\u4e8c\u5341\u4e5d");
        numList.put("30", "\u4e09\u5341");
        numList.put("31", "\u4e09\u5341\u4e00");
        fmt = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = fmt.parse(item.getShowValue());
        }
        catch (ParseException ex) {
            this.log.WriteLog("parse\u51fa\u73b0\u5f02\u5e38" + ex.getMessage());
            return item.getShowValue();
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        String Year = String.valueOf(calendar.get(1));
        sb.append(numList.get(Year.substring(0, 1)));
        sb.append(numList.get(Year.substring(1, 2)));
        sb.append(numList.get(Year.substring(2, 3)));
        sb.append(numList.get(Year.substring(3)));
        sb.append("\u5e74");
        String Month = String.valueOf(calendar.get(2) + 1);
        sb.append(numList.get(Month));
        sb.append("\u6708");
        String Day = String.valueOf(calendar.get(5));
        sb.append(numList.get(Day));
        sb.append("\u65e5");
        this.log.WriteLog(sb.toString());
        return sb.toString();
    }
}

